-- Wischer
-- Specialization für Wischer


Wischer = {};

function Wischer.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(AnimatedVehicle, specializations);
end;

function Wischer:load(xmlFile)
	self.wischer = {};
	self.wischer.anim = getXMLString(xmlFile, "vehicle.wischer#animName");
	self.wischer.speed = getXMLFloat(xmlFile, "vehicle.wischer#speed");
	self.wischer.isActive = false;
end;

function Wischer:delete()
end;

function Wischer:readStream(streamId, connection)
end;

function Wischer:writeStream(streamId, connection)
end;

function Wischer:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Wischer:keyEvent(unicode, sym, modifier, isDown)
end;

function Wischer:update(dt)
end;

function Wischer:updateTick(dt)

	if self:getIsActive() then
		if self.wischer.isActive then
			if not self:getIsAnimationPlaying(self.wischer.anim) then
				self:playAnimation(self.wischer.anim, self.wischer.speed, 0, true);
			end;
		end;
		
		if g_currentMission.environment.lastRainScale > 0.1 and g_currentMission.environment.timeSinceLastRain < 30 then
			if not self.wischer.isActive then
				self:playAnimation(self.wischer.anim, self.wischer.speed, Utils.clamp(self:getAnimationTime(self.wischer.anim), 0, 1), true);
				self.wischer.isActive = true;
			end;
		else
			if self.wischer.isActive then
				self:setAnimationStopTime(self.wischer.anim, 1);
				self.wischer.isActive = false;
			end;
		end;
	end;
end;

function Wischer:draw()	
end;

function Wischer:onLeave()
	if self.wischer.isActive then
		self:stopAnimation(self.wischer.anim);	
	end;
end;

function Wischer:onEnter()
	if self.wischer.isActive then
		self:playAnimation(self.wischer.anim, self.wischer.speed, Utils.clamp(self:getAnimationTime(self.wischer.anim), 0, 1), true);	
	end;
end;