WheelExtension = {}
function WheelExtension.prerequisitesPresent(specializations)
  return true
end
function WheelExtension:load(xmlFile)
  local i = 0
  while true do
    do
      local baseName = string.format("vehicle.wheels.wheel(%d)", i)
      if not hasXMLProperty(xmlFile, baseName) then
        break
      end
      local wheel = self.wheels[i + 1]
      wheel.fenderNode = Utils.indexToObject(self.components, getXMLString(xmlFile, baseName .. "#fenderNode"))
      wheel.fenderMaxRot = Utils.getNoNil(Utils.degToRad(getXMLFloat(xmlFile, baseName .. "#fenderMaxRot")), wheel.rotMax)
      wheel.fenderMinRot = Utils.getNoNil(Utils.degToRad(getXMLFloat(xmlFile, baseName .. "#fenderMinRot")), wheel.rotMin)
      wheel.fenderSmooth = Utils.getNoNil(getXMLBool(xmlFile, baseName .. "#fenderSmooth"), false)
      wheel.doBrakeOnLift = Utils.getNoNil(getXMLBool(xmlFile, baseName .. "#doBrakeOnLift"), false)
      i = i + 1
    end
  end
end
function WheelExtension:delete()
end
function WheelExtension:mouseEvent(posX, posY, isDown, isUp, button)
end
function WheelExtension:keyEvent(unicode, sym, modifier, isDown)
end
function WheelExtension:update(dt)
  if self:getIsActive() then
    for _, wheel in pairs(self.wheels) do
      if wheel.fenderNode ~= nil then
        local angle = 0
        if wheel.fenderSmooth then
          if 0 < wheel.steeringAngle then
            angle = math.abs(wheel.steeringAngle / wheel.rotMax) * wheel.fenderMaxRot
          else
            angle = math.abs(wheel.steeringAngle / wheel.rotMin) * wheel.fenderMinRot
          end
        else
          angle = Utils.clamp(wheel.steeringAngle, wheel.fenderMinRot, wheel.fenderMaxRot)
        end
        setRotation(wheel.fenderNode, 0, angle, 0)
      end
      if self.isServer and self.firstTimeRun and wheel.doBrakeOnLift then
        local brakeForce = self.brakeForce
        if not self:isLowered() then
          brakeForce = 6
        end
        if not wheel.hasGroundContact then
          setWheelShapeProps(wheel.node, wheel.wheelShape, 0, brakeForce, wheel.steeringAngle)
        end
      end
    end
  end
end
function WheelExtension:updateTick(dt)
end
function WheelExtension:draw()
end