--
-- Specialization for Steyr 6230 CVT 
--
-- @author  	CebuljCek
-- @date  		17/10/2014
--

Steyr6230CVT = {};

function Steyr6230CVT.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function Steyr6230CVT:load(xmlFile)

	-- Switches
	self.numSwitches = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.switches#count"),0);
	self.switch = {};
	for i=1, self.numSwitches do
		local objname = string.format("vehicle.switches.switch" .. "%d", i);
		self.switch[i] = {};
		self.switch[i] = Utils.indexToObject(self.components, getXMLString(xmlFile, objname .. "#index"));
	end;

	--[[ PTO
	self.PTOKnob = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.PTOKnob#index"));
	if self.PTOKnob ~= nil then
		self.PTOKnobStartTrans = {getTranslation(self.PTOKnob)};
	end;
	self.PTOOnLight = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.PTOOnLight#index"));]]
	
	-- Dashboard indicators
	self.controlOil = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.controlOil#index"));
	setVisibility(self.controlOil,false);
	self.controlFuel = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.controlFuel#index"));
	setVisibility(self.controlFuel,false);
	self.control4WD = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.control4WD#index"));
	setVisibility(self.control4WD,false);
	self.controlParkingBrake = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.controlParkingBrake#index"));
	setVisibility(self.controlParkingBrake,false);
	self.controlSlow = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.controlSlow#index"));
	
	self.controlFast = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.controlFast#index"));
	
	self.controlBattery = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.controlBattery#index"));
	setVisibility(self.controlBattery,false);
	self.controlEngineThing1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.controlEngineThing1#index"));
	setVisibility(self.controlEngineThing1,false);
	self.controlEngineThing2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.controlEngineThing2#index"));
	
	self.RPMnumbers = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.RPMnumbers#index"));
	setVisibility(self.RPMnumbers,false);
	self.stechDisplay1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.stechDisplay1#index"));
	setVisibility(self.stechDisplay1,false);
	self.stechDisplay2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.stechDisplay2#index"));
	setVisibility(self.stechDisplay2,false);
	self.stechDisplay3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.stechDisplay3#index"));
	setVisibility(self.stechDisplay3,false);
	self.stechDT = 0;
	self.stech1T = 80;
	self.stech2T = 250;
	self.stechPT = 7;
	
end;

function Steyr6230CVT:delete()
end;

function Steyr6230CVT:readStream(streamId, connection)
end;

function Steyr6230CVT:writeStream(streamId, connection)
end;

function Steyr6230CVT:readUpdateStream(streamId, timestamp, connection)
end;

function Steyr6230CVT:writeUpdateStream(streamId, connection, dirtyMask)
end;

function Steyr6230CVT:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Steyr6230CVT:keyEvent(unicode, sym, modifier, isDown)
end;

function Steyr6230CVT:update(dt)
end;

function Steyr6230CVT:updateTick(dt)
	if self:getIsActive() then
		if self.isMotorStarted then
			if self.fuelFillLevel < 80 then
				setVisibility(self.controlFuel, true);
			else
				setVisibility(self.controlFuel, false);
			end;

			if self.is4wdActive then
				setVisibility(self.control4WD, true);
			else
				setVisibility(self.control4WD, false);
			end;

			--[[if self.controlFast ~= nil then
				if self.currentFwdGear > 14 then
					setVisibility(self.controlFast, true);
				elseif self.currentFwdGear <= 14 then
					setVisibility(self.controlFast, false);
				end;
			end;

			if self.controlSlow ~= nil then
				if self.currentFwdGear <= 6 then
					setVisibility(self.controlSlow, true);
				else
					setVisibility(self.controlSlow, false);
				end;
			end;]]

			local mySpeed = self.lastSpeed*3600;
			if self.isBraking and mySpeed > 0 then
				if self.control4WD ~= nil then
					setVisibility(self.control4WD, true);
				end;
			end;

			if self.controlParkingBrake ~= nil then
				if self.handbrake then
					setVisibility(self.controlParkingBrake, true);
				else
					setVisibility(self.controlParkingBrake, false);
				end;
			end;

			
			--[[if self.realLightsActive then
				setVisibility(self.digitRPMs,false);
				--setVisibility(self.digitRPMsLight,true);
				--setVisibility(self.fuelIndicatorsGroup, false);
				--setVisibility(self.fuelIndicatorsLightGroup, true);
			else
				setVisibility(self.digitRPMs,true);
				--setVisibility(self.digitRPMsLight,false);
				--setVisibility(self.fuelIndicatorsGroup, true);
				--setVisibility(self.fuelIndicatorsLightGroup, false);
			end;]]

			--[[for k, implement in pairs(self.attachedImplements) do
				if implement.object ~= nil then
					if implement.object.isTurnedOn then
						local x, y, z = unpack(self.PTOKnobStartTrans);
						setTranslation(self.PTOKnob, x, y+0.004, z);
					else
						setTranslation(self.PTOKnob, unpack(self.PTOKnobStartTrans));
						setVisibility(self.PTOOnLight, true);
						setVisibility(self.PTOOnLight, false);
					end;
				end;
			end;]]--
		end;
		
		if self.ignitionMode ~= 0 then
			
			if self.stechDT == self.stech2T then
					setVisibility(self.stechDisplay1, false);
					setVisibility(self.stechDisplay2, false);
					setVisibility(self.stechDisplay3, true);
			
			elseif self.stechDT > self.stech1T and self.stechDT < (self.stech1T + self.stechPT) then
					self.stechDT = self.stechDT + 1;
					setVisibility(self.stechDisplay1, false);
					setVisibility(self.stechDisplay2, false);
					setVisibility(self.stechDisplay3, false);
			
			elseif self.stechDT > (self.stech1T + self.stechPT) and self.stechDT < self.stech2T then
					self.stechDT = self.stechDT + 1;
					setVisibility(self.stechDisplay1, false);
					setVisibility(self.stechDisplay2, true);
					setVisibility(self.stechDisplay3, false);
				else
					self.stechDT = self.stechDT + 1;
					setVisibility(self.stechDisplay1, true);
					setVisibility(self.stechDisplay2, false);
					setVisibility(self.stechDisplay3, false);
			end;
			--renderText(0.5, 0.65, 0.040, string.format(self.stechDT));
		else
			self.stechDT = 0;
			setVisibility(self.stechDisplay1, false);
			setVisibility(self.stechDisplay2, false);
			setVisibility(self.stechDisplay3, false);
		
		end;
		
		if self.ignitionMode == 0 then
			if self.controlSlow ~= nil then
				setVisibility(self.controlSlow, false);
			end;
			if self.controlFast ~= nil then
				setVisibility(self.controlFast, false);
			end;
			if self.controlParkingBrake ~= nil then
				setVisibility(self.controlParkingBrake, false);
			end;
			if self.shuttleIndicatorsIndex ~= nil then
				setVisibility(self.shuttleIndicatorsIndex,false);
			end;
			if self.shuttleIndicatorsLightIndex ~= nil then
				setVisibility(self.shuttleIndicatorsLightIndex,false);
			end;
			if self.gearDigits ~= nil then
				setVisibility(self.gearDigits,false);
			end;
			if self.gearDigitsLight ~= nil then
				setVisibility(self.gearDigitsLight,false);
			end;
			if self.control4WD ~= nil then
				setVisibility(self.control4WD, false);
			end;
			if self.controlFuel ~= nil then
				setVisibility(self.controlFuel, false);
			end;
			--if self.digitRPMsLight ~= nil then
				--setVisibility(self.digitRPMsLight,false);
			--end;
			--if self.fuelIndicatorsGroup ~= nil then
				--setVisibility(self.fuelIndicatorsGroup, false);
			--end;
			--if self.fuelIndicatorsLightGroup ~= nil then
				--setVisibility(self.fuelIndicatorsLightGroup, false);
			--end;
			if self.RPMnumbers ~= nil then
				setVisibility(self.RPMnumbers, false);
			end;
			--[[if self.stechDisplay1 ~= nil then
				setVisibility(self.stechDisplay1, false);
			end;
			if self.stechDisplay2 ~= nil then
				setVisibility(self.stechDisplay2, false);
			end;
			if self.stechDisplay3 ~= nil then
				setVisibility(self.stechDisplay3, false);
			end;]]
		elseif self.ignitionMode == 1 then
			--[[if self.realLightsActive then
				if self.fuelIndicatorsGroup ~= nil then
					setVisibility(self.fuelIndicatorsGroup, false);
				end;
				if self.fuelIndicatorsLightGroup ~= nil then
					setVisibility(self.fuelIndicatorsLightGroup, true);
				end;
			else
				if self.fuelIndicatorsGroup ~= nil then
					setVisibility(self.fuelIndicatorsGroup, true);
				end;
				if self.fuelIndicatorsLightGroup ~= nil then
					setVisibility(self.fuelIndicatorsLightGroup, false);
				end;
			end;]]--
			if self.RPMnumbers ~= nil then
				setVisibility(self.RPMnumbers, true);
			end;
			--[[if self.stechDisplay1 ~= nil then
				setVisibility(self.stechDisplay1, true);
			end;
			if self.stechDisplay2 ~= nil then
				setVisibility(self.stechDisplay2, true);
			end;
			if self.stechDisplay3 ~= nil then
				setVisibility(self.stechDisplay3, true);
			end;]]
			if self.controlBattery ~= nil then
				setVisibility(self.controlBattery, true);
			end;
			if self.controlEngineThing1 ~= nil then
				setVisibility(self.controlEngineThing1, true);
			end;
			if self.controlEngineThing2 ~= nil then
				setVisibility(self.controlEngineThing2, true);
			end;
			if self.controlParkingBrake ~= nil then
				setVisibility(self.controlParkingBrake, true);
			end;
			if self.controlOil ~= nil then
				setVisibility(self.controlOil, true);
			end;
			if self.controlFuel ~= nil then
				setVisibility(self.controlFuel, true);
			end;
		elseif self.ignitionMode == 2 then
			if self.RPMnumbers ~= nil then
				setVisibility(self.RPMnumbers, true);
			end;
			--if self.stechDisplays ~= nil then
				--setVisibility(self.stechDisplays, true);
			--end;
			if self.controlBattery ~= nil then
				setVisibility(self.controlBattery, false);
			end;
			if self.controlEngineThing1 ~= nil then
				setVisibility(self.controlEngineThing1, false);
			end;
			if self.controlEngineThing2 ~= nil then
				setVisibility(self.controlEngineThing2, false);
			end;
			if self.controlOil ~= nil then
				setVisibility(self.controlOil, false);
			end;
			if self.controlFuel ~= nil and self.fuelFillLevel > 80 then
				setVisibility(self.controlFuel, false);
			end;
		end;
	end;

	-- Switches rotations
	-- Back wiper switch
	if self.switch[1] ~= nil then
		if self.wiperBackOn then
			setRotation(self.switch[1], math.rad(-43.27), math.rad(-11.6), math.rad(-12));
		else
			setRotation(self.switch[1], math.rad(-44.5), 0, 0);
		end;
	end;

	-- Beaconlights switch
	if self.switch[2] ~= nil then
		if self.beaconLightsActive then
			setRotation(self.switch[2], math.rad(-43.27), math.rad(-11.6), math.rad(-12));
			setVisibility(self.beaconSwitchLight, true);
		else
			setRotation(self.switch[2], math.rad(-44.5), 0, 0);
			setVisibility(self.beaconSwitchLight, false);
		end;
	end;

	-- Warninglights switch
	if self.switch[3] ~= nil then
		--[[if self.B3.wl then
			setRotation(self.switch[3], math.rad(-43.27), math.rad(-11.6), math.rad(-12));
		else
			setRotation(self.switch[3], math.rad(-44.5), 0, 0);
		end;]]
	end;
	
	--[[if self.indicatorsLever ~= nil then
		if not self.B3.wl then
			if self.B3.dirRight[1].a then
				setRotation(self.indicatorsLever, 0, math.rad(20), math.rad(180));
			elseif self.B3.dirLeft[1].a then
				setRotation(self.indicatorsLever, 0, math.rad(-20), math.rad(180));
			else
				setRotation(self.indicatorsLever, 0, 0, math.rad(180));
			end;
		else
			setRotation(self.indicatorsLever, 0, 0, math.rad(180));
		end;
	end;]]
end;

function Steyr6230CVT:draw()
end;

function Steyr6230CVT:onLeave()
end;

function Steyr6230CVT:onEnter()
end;

function Steyr6230CVT:RPMDigits()
	--[[ Digital Display handling RPM
	if self.isEntered then
		if self.isMotorStarted then
			if self.showSpeed then
				local kmh = math.min(100, math.max(0, self.lastSpeed*self.speedDisplayScale*3600)) - 0.00008 *dt;
				self.displayValue = kmh;
			else
				if self.currentCycle < self.cycleRoundMax then
					self.currentCycle = self.currentCycle + 1;
					self.currentRPM = self.motor.lastMotorRpm;
					if self.rpmMeterValue ~= nil then
						self.currentRPM = self.rpmMeterValue;
					end;
					self.lastRpm = math.floor((self.lastRpm + self.currentRPM)/2);
					if self.lastRpm < 400 then
						self.lastRpm = math.random(380, 420);
					end;
				else
					self.currentCycle = 0;
					self.displayValue = self.lastRpm;
				end;
			end;
		else
			self.displayValue = 0;
		end;

		local displayValue = self.displayValue;
		-- Handle the digitRPMs in the display
		if self.isMotorStarted then
			local thousends = math.floor(displayValue/1000);
			local displayIndex = thousends;
			local isBlank = false;
			if self.prevousDigitRPMFour ~= thousends then
				if self.prevousDigitRPMFour > 0 then
					setVisibility(self.digitRPMFour[self.prevousDigitRPMFour].rotNode,false);
					--setVisibility(self.digitRPMFourLight[self.prevousDigitRPMFour].rotNode,false);
				end;
				if displayIndex == 0 then
					isBlank = true;
				end;
				if isBlank then
					for i=1, self.numDigitRPMFour do
						setVisibility(self.digitRPMFour[i].rotNode,false);
						--setVisibility(self.digitRPMFourLight[i].rotNode,false);
					end;
				else
					setVisibility(self.digitRPMFour[displayIndex].rotNode,true);
					--setVisibility(self.digitRPMFourLight[displayIndex].rotNode,true);
				end;
			end;
			self.prevousDigitRPMFour = displayIndex;

			displayValue = displayValue - thousends * 1000;
			local hundreds = math.floor(displayValue/100);
			displayIndex = hundreds;
			isBlank = false;
			if self.prevousDigitRPMThree ~= hundreds then
				if self.prevousDigitRPMThree > 0 then
					setVisibility(self.digitRPMThree[self.prevousDigitRPMThree].rotNode,false);
					--setVisibility(self.digitRPMThreeLight[self.prevousDigitRPMThree].rotNode,false);
					renderText(0.47, 0.65, 0.040, string.format(displayIndex));
				end;
				if displayIndex == 0 and thousends == 0 then
					isBlank = true;
				elseif displayIndex == 0 then
					if thousends > 0 then
						displayIndex = 10;
					end;
				end;
				if isBlank then
					for i=1, self.numDigitRPMThree do
						setVisibility(self.digitRPMThree[i].rotNode,false);
						--setVisibility(self.digitRPMThreeLight[i].rotNode,false);
					end;
				else
					setVisibility(self.digitRPMThree[displayIndex].rotNode,true);
					--setVisibility(self.digitRPMThreeLight[displayIndex].rotNode,true);
				end;
			end;
			self.prevousDigitRPMThree = displayIndex;

			displayValue = displayValue - hundreds * 100;
			local tens = math.floor(displayValue/10);
			displayIndex = tens;
			isBlank = false;
			if self.prevousDigitRPMTwo ~= tens then
				if self.prevousDigitRPMTwo > 0 then
					setVisibility(self.digitRPMTwo[self.prevousDigitRPMTwo].rotNode,false);
					--setVisibility(self.digitRPMTwoLight[self.prevousDigitRPMTwo].rotNode,false);
					renderText(0.48, 0.65, 0.040, string.format(displayIndex));
				end;
				if displayIndex == 0 and hundreds == 0 then
					isBlank = true;
				elseif displayIndex == 0 then
					if hundreds > 0 or thousends > 0 then
						displayIndex = 10;
					end;
				end;
				if isBlank then
					for i=1, self.numDigitRPMTwo do
						setVisibility(self.digitRPMTwo[i].rotNode,false);
						--setVisibility(self.digitRPMTwoLight[i].rotNode,false);
					end;
				else
					setVisibility(self.digitRPMTwo[displayIndex].rotNode,true);
					--setVisibility(self.digitRPMTwoLight[displayIndex].rotNode,true);
					renderText(0.49, 0.65, 0.040, string.format(displayIndex));
				end;
			end;
			self.prevousDigitRPMTwo = displayIndex;

			displayValue = displayValue - tens * 10;
			local ones = math.floor(displayValue);
			--displayIndex = 10;
			if self.showSpeed then
				if displayValue >= 10 and displayValue < 20 then
					displayIndex = displayValue-10;
				elseif displayValue >= 20 and displayValue < 30 then
					displayIndex = displayValue-20;
				elseif displayValue >= 30 and displayValue < 40 then
					displayIndex = displayValue-30;
				elseif displayValue >= 40 and displayValue < 50 then
					displayIndex = displayValue-40;
				elseif displayValue >= 50 and displayValue < 60 then
					displayIndex = displayValue-50;
				else
					displayIndex = displayValue;
				end;
				--renderText(0.5, 0.65, 0.040, string.format(displayIndex));
			end;
			if self.prevousDigitRPMOne ~= ones then
				if self.prevousDigitRPMOne > 0 then
					if (math.floor(displayIndex)+1) ~= 11 then
						setVisibility(self.digitRPMOne[self.prevousDigitRPMOne].rotNode,false);
						--setVisibility(self.digitRPMOneLight[self.prevousDigitRPMOne].rotNode,false);
						renderText(0.5, 0.65, 0.040, string.format(displayIndex));
					end;
				end;

				if math.floor(displayIndex) == 0 then
					displayIndex = 10;
				end;
				--renderText(0.5, 0.65, 0.040, string.format(displayIndex));
				setVisibility(self.digitRPMOne[math.floor(displayIndex)].rotNode,true);
				--setVisibility(self.digitRPMOneLight[math.floor(displayIndex)].rotNode,true);
			end;
			self.prevousDigitRPMOne = math.floor(displayIndex);
			self.rpmDisplaysSetOff = false;
		else
			if not self.rpmDisplaysSetOff then
				for i=1, self.numDigitRPMOne do
					setVisibility(self.digitRPMOne[i].rotNode,false);
				end;

				for i=1, self.numDigitRPMTwo do
					setVisibility(self.digitRPMTwo[i].rotNode,false);
				end;

				for i=1, self.numDigitRPMThree do
					setVisibility(self.digitRPMThree[i].rotNode,false);
				end;

				for i=1, self.numDigitRPMFour do
					setVisibility(self.digitRPMFour[i].rotNode,false);
				end;

				
				for i=1, self.numDigitRPMOneLight do
					setVisibility(self.digitRPMOneLight[i].rotNode,false);
				end;

				for i=1, self.numDigitRPMTwoLight do
					setVisibility(self.digitRPMTwoLight[i].rotNode,false);
				end;

				for i=1, self.numDigitRPMThreeLight do
					setVisibility(self.digitRPMThreeLight[i].rotNode,false);
				end;

				for i=1, self.numDigitRPMFourLight do
					setVisibility(self.digitRPMFourLight[i].rotNode,false);
				end;
				

				self.rpmDisplaysSetOff = true;
			end;
		end;
	end;]]
end;

function Steyr6230CVT:updateFuelIndicators()
	--[[local amountOfFuelPerIndicator = self.fuelCapacity/12;

	local timesToIterate = self.fuelFillLevel/amountOfFuelPerIndicator;

	timesToIterate = math.floor(timesToIterate);

	if self.oldTimesToIterate ~= timesToIterate then
		for i=1, self.numFuelIndicators do
			setVisibility(self.fuelIndicators[i].rotNode, false);
			setVisibility(self.fuelIndicatorsLight[i].rotNode, false);
		end;

		for i=1, timesToIterate do
			setVisibility(self.fuelIndicators[i].rotNode, true);
			setVisibility(self.fuelIndicatorsLight[i].rotNode, true);
		end;
	end;

	self.oldTimesToIterate = timesToIterate;]]--
end;
