-- [e-3D Modding] Mrludo
-- Script pour le pack de benne maitre Skipper_SK80


Skipper_SK80 = {};

function Skipper_SK80.prerequisitesPresent(specializations)
	  return SpecializationUtil.hasSpecialization(Fillable, specializations);
end;

function Skipper_SK80:load(xmlFile)



	
	
	 self.toggleSupport = SpecializationUtil.callSpecializationsFunction("toggleSupport");  
    self.manualSupportAnimation = getXMLString(xmlFile, "vehicle.manualSupport#animationName");
    self.supportRangeIndex = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.manualSupport#rangeIndex"));
    self.isInRangeSupport = false;
    self.isSupportDown = true;
 	
	
	
end;

function Skipper_SK80:delete()

end;

function Skipper_SK80:readStream(streamId, connection)

   local isSupportDown = streamReadBool(streamId);
	self:toggleSupport(isSupportDown, true); 
end;

function Skipper_SK80:writeStream(streamId, connection)

streamWriteBool(streamId, self.isSupportDown); 

end;

function Skipper_SK80:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Skipper_SK80:keyEvent(unicode, sym, modifier, isDown) 
end;

function Skipper_SK80:update(dt)
         if self:getIsActive() then		
		if self.isClient and self:getIsActiveForInput(false) and not self:hasInputConflictWithSelection() then
			-- Show warning about the support being down
			if self.isSupportDown then
				g_currentMission:addWarning(string.format(g_i18n:getText("BJR_SUPPORT_WARNING")), 0.018, 0.033);
			end;
		end;
	end;
         if self.supportRangeIndex then
		-- Manage key events for inrange support --
		if self.isInRangeSupport then
			if InputBinding.hasEvent(InputBinding.LOWER_IMPLEMENT) then
				if self.isSupportDown then
					self:toggleSupport(false);
				else
					self:toggleSupport(true);
				end;
			end;
			-- Display key when in range --
			if self.isSupportDown then
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("BJR_RAISE_SUPPORT")), InputBinding.LOWER_IMPLEMENT);
			else
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("BJR_LOWER_SUPPORT")), InputBinding.LOWER_IMPLEMENT);
			end;
		end;
	end;


end;

function Skipper_SK80:updateTick(dt)

 if self.supportRangeIndex then
		if g_currentMission.player ~= nil then
			-- Getting the distance between the player and the support
			local nearestDistance = 1.5; --max distance allowed
			local px, py, pz = getWorldTranslation(self.supportRangeIndex);
			local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
			local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);
			if distance < nearestDistance then
				self.isInRangeSupport = true;
			else
				self.isInRangeSupport = false;
			end;
		end;
	else
		self.isInRangeSupport = false;
	end;
	

end;

function Skipper_SK80:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	local isSupportDown = Utils.getNoNil(getXMLBool(xmlFile, key .. "#isSupportDown"), false);
	self:toggleSupport(isSupportDown);	
	
    return BaseMission.VEHICLE_LOAD_OK;
end;

function Skipper_SK80:getSaveAttributesAndNodes(nodeIdent)
    local attributes = 'isSupportDown="' .. tostring(self.isSupportDown) .. '"';
    return attributes, nil;
end;
  
function Skipper_SK80:onDetach()
     self.isSupportDown = true;
  
end;

function Skipper_SK80:onAttach()

end;

function Skipper_SK80:draw() 

end;

function Skipper_SK80:toggleSupport(isSupportDown, noEventSend)
	ToggleSupportEvent.sendEvent(self, isSupportDown, noEventSend);	
	
	if not isSupportDown then
		if self.manualSupportAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.manualSupportAnimation, -1, nil, true);
		end;
	else
		if self.manualSupportAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.manualSupportAnimation, 1, nil, true);
		end;
	end;
	
	self.isSupportDown = isSupportDown;
end;



-- Support event

ToggleSupportEvent = {};
ToggleSupportEvent_mt = Class(ToggleSupportEvent, Event);

InitEventClass(ToggleSupportEvent, "ToggleSupportEvent");

function ToggleSupportEvent:emptyNew()
    local self = Event:new(ToggleSupportEvent_mt);
    return self;
end;

function ToggleSupportEvent:new(object, isSupportDown)
    local self = ToggleSupportEvent:emptyNew()
    self.object = object;
	self.isSupportDown = isSupportDown;
    return self;
end;

function ToggleSupportEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.object = networkGetObject(id);
	self.isSupportDown = streamReadBool(streamId);
    self:run(connection);
end;

function ToggleSupportEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));	
	streamWriteBool(streamId, self.isSupportDown);
end;

function ToggleSupportEvent:run(connection)
	self.object:toggleSupport(self.isSupportDown, true);
end;

function ToggleSupportEvent.sendEvent(object, isSupportDown, noEventSend)
	
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(ToggleSupportEvent:new(object, isSupportDown), nil, nil, object);
		else
			g_client:getServerConnection():sendEvent(ToggleSupportEvent:new(object, isSupportDown));
		end;
	end;
end;


--if g_currentModName ~= "Pack_Maitre_Skipper_SK80" then
	--print("Error: The mod must not be renamed. It must be called Pack_Maitre_Skipper_SK80.zip");
	--print("Erreur: Le mods ne doit pas être renommé. Il doit être appelé Pack_Maitre_Skipper_SK80.zip");		
--end;
