--
-- Specjalizacja dla Sipma PK4000 
-- Autor: Rockstar94 
-- Data: 12.11.2015 
--

PK4000 = {};

function PK4000.prerequisitesPresent(specializations)
return true;
end;

function PK4000:load(xmlFile)
	local klapa_przod = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.klapa_przod#index"));
	if klapa_przod ~= nil then
		self.klapa_przod = klapa_przod;
	end;
	
	local klapa_boczna = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.klapa_boczna#index"));
	if klapa_boczna ~= nil then
		self.klapa_boczna = klapa_boczna;
	end;
	
	local klapa_mechanizmy = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.klapa_mechanizmy#index"));
	if klapa_mechanizmy ~= nil then
		self.klapa_mechanizmy = klapa_mechanizmy;
	end;
	
	local klapa_tylna = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.klapa_tylna#index"));
	if klapa_tylna ~= nil then
		self.klapa_tylna = klapa_tylna;
	end;
	
	local klapa_belki = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.klapa_belki#index"));
	if klapa_belki ~= nil then
		self.klapa_belki = klapa_belki;
	end;
	
	local podbierak = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.podbierak#index"));
	if podbierak ~= nil then
		self.podbierak = podbierak;
	end;
	
	self.kolko = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.kolko#index"));
	
	self.File = Utils.getFilename("Tekstury/hud.dds", self.baseDirectory);
	self.hudPoxX = 0.9095;
    self.hudPoxY = 0.86; 
    self.hudWidth = 0.13325;
    self.hudHeight = 0.0513825;
    self.HUDSipma = Overlay:new("HUDSipma", self.File, self.hudPoxX, self.hudPoxY, self.hudWidth, self.hudHeight);
    self.HUD = false;
	self.TotalBalesCount = 0;
	self.lastBaleCount = 0;
	
	self.ropePanelAnimation = getXMLString(xmlFile, "vehicle.ropePanel#animationName");
	self.setRopePanel = SpecializationUtil.callSpecializationsFunction("setRopePanel");
end;

function PK4000:delete()
	if self.HUDSipma ~= nil then
		self.HUDSipma:delete();
	end;
end;

function PK4000:keyEvent(unicode, sym, modifier, isDown)
 end;
 
function PK4000:update(dt)	
	if self.przy_klapa_belki then
		if self.animationParts[8].clipEndTime then
			if self.animationParts[16].clipStartTime then
				if InputBinding.hasEvent(InputBinding.oslona2_sipma) then
					if self.animationParts[15].clipEndTime then
						self:setAnimationTime(15, self.animationParts[15].offSet);
					elseif self.animationParts[15].clipStartTime  then
						self:setAnimationTime(15, self.animationParts[15].animDuration);	
					end;
				end;
			end;
		end;
	end;

	if self.przy_klapa_belki then
		if not self.animationParts[8].clipEndTime then
			g_currentMission:addExtraPrintText(g_i18n:getText("podajnik_info1"));
		end;
		if self.animationParts[8].clipEndTime then
			if self.animationParts[16].clipStartTime then
				if self.animationParts[15].clipStartTime then
					g_currentMission:addHelpButtonText(string.format(g_i18n:getText("podajnik_sipma1")), InputBinding.oslona2_sipma);
				else
					g_currentMission:addHelpButtonText(string.format(g_i18n:getText("podajnik_sipma12")), InputBinding.oslona2_sipma);
				end;
			end;
		end;
	end;
	
	if self.przy_klapa_belki then
		if self.animationParts[8].clipEndTime then
			if self.animationParts[15].clipEndTime then
				local baleCountInBaler = table.getn(self.bales);
				if baleCountInBaler == 0 or baleCountInBaler == 1 then
					if InputBinding.hasEvent(InputBinding.skladanie_sipma) then
						if self.animationParts[16].clipEndTime then
							self:setAnimationTime(16, self.animationParts[16].offSet);
						elseif self.animationParts[16].clipStartTime  then
							self:setAnimationTime(16, self.animationParts[16].animDuration);	
						end;
					end;
				else
					g_currentMission:addExtraPrintText(g_i18n:getText("podajnik_infozzz"));
				end;
			end;
		end;
	end;

	if self.przy_klapa_belki then	
		if self.animationParts[8].clipEndTime then
			if self.animationParts[15].clipEndTime then
				local baleCountInBaler = table.getn(self.bales);
				if baleCountInBaler == 0 or baleCountInBaler == 1 then
					if self.animationParts[16].clipStartTime then
						g_currentMission:addHelpButtonText(string.format(g_i18n:getText("podajnik_sipma2")), InputBinding.skladanie_sipma);
					else
						g_currentMission:addHelpButtonText(string.format(g_i18n:getText("podajnik_sipma22")), InputBinding.skladanie_sipma);
					end;
				end;
			end;
		end;
	end;

	if self:getIsActive() then
		if self.TotalBalesCount >= 230 and self.TotalBalesCount < 250 then
			g_currentMission:addExtraPrintText(g_i18n:getText("sznurek_koniec"));
		end;
	end;
	
	if self.isTurnedOn then
        self:setAnimationTime(1, 1);
		self:setAnimationTime(2, 1);
		self:setAnimationTime(3, 1);
		self:setAnimationTime(11, 1);
    else
        self:setAnimationTime(1, 0);
		self:setAnimationTime(2, 0);
		self:setAnimationTime(3, 0);
		self:setAnimationTime(11, 0);
    end;	
	
	local nearestDistance = 1.5;
    local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
    local px, py, pz = getWorldTranslation(self.klapa_przod);
    local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);
		if distance < nearestDistance then
			self.przy_klapa_przod = true;
		else
			self.przy_klapa_przod = false;
		end;
		
    if self.przy_klapa_przod then
		if InputBinding.hasEvent(InputBinding.klapa_sipma) then
			if self.animationParts[4].clipEndTime then
				self:setAnimationTime(4, self.animationParts[4].offSet);
			elseif self.animationParts[4].clipStartTime  then
				self:setAnimationTime(4, self.animationParts[4].animDuration);	
			end;
		end;
    end;
	
	if self.przy_klapa_przod then
		if self.animationParts[4].clipStartTime then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("rozloz2_sipma1")), InputBinding.klapa_sipma);
		else
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("zloz2_sipma1")), InputBinding.klapa_sipma);
		end;
	end;	
	
	local nearestDistance = 1;
    local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
    local px, py, pz = getWorldTranslation(self.klapa_boczna);
    local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);
		if distance < nearestDistance then
			self.przy_klapa_boczna = true;
		else
			self.przy_klapa_boczna = false;
		end;
		
    if self.przy_klapa_boczna then
		if InputBinding.hasEvent(InputBinding.oslona2_sipma) then
			if self.animationParts[5].clipEndTime then
				self:setAnimationTime(5, self.animationParts[5].offSet);
			elseif self.animationParts[5].clipStartTime  then
				self:setAnimationTime(5, self.animationParts[5].animDuration);	
			end;
		end;
    end;
	
	if self.przy_klapa_boczna then
		if self.animationParts[5].clipStartTime then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("rozloz2_sipma2")), InputBinding.oslona2_sipma);
		else
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("zloz2_sipma2")), InputBinding.oslona2_sipma);
		end;
	end;	
	
	local nearestDistance = 1;
    local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
    local px, py, pz = getWorldTranslation(self.klapa_mechanizmy);
    local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);
		if distance < nearestDistance then
			self.przy_klapa_mechanizmy = true;
		else
			self.przy_klapa_mechanizmy = false;
		end;
		
    if self.przy_klapa_mechanizmy then
		if InputBinding.hasEvent(InputBinding.klapa_sipma) then
			if self.animationParts[6].clipEndTime then
				self:setAnimationTime(6, self.animationParts[6].offSet);
			elseif self.animationParts[6].clipStartTime  then
				self:setAnimationTime(6, self.animationParts[6].animDuration);	
			end;
		end;
    end;
	
	if self.przy_klapa_mechanizmy then
		if self.animationParts[6].clipStartTime then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("rozloz2_sipma3")), InputBinding.klapa_sipma);
		else
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("zloz2_sipma3")), InputBinding.klapa_sipma);
		end;
	end;	
	
	local nearestDistance = 1;
    local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
    local px, py, pz = getWorldTranslation(self.klapa_tylna);
    local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);
		if distance < nearestDistance then
			self.przy_klapa_tylna = true;
		else
			self.przy_klapa_tylna = false;
		end;
		
    if self.przy_klapa_tylna then
		if InputBinding.hasEvent(InputBinding.klapa_sipma) then
			if self.animationParts[7].clipEndTime then
				self:setAnimationTime(7, self.animationParts[7].offSet);
			elseif self.animationParts[7].clipStartTime  then
				self:setAnimationTime(7, self.animationParts[7].animDuration);	
			end;
		end;
    end;
	
	if self.przy_klapa_tylna then
		if self.animationParts[7].clipStartTime then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("rozloz2_sipma4")), InputBinding.klapa_sipma);
		else
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("zloz2_sipma4")), InputBinding.klapa_sipma);
		end;
	end;	
	
	local nearestDistance = 1.2;
    local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
    local px, py, pz = getWorldTranslation(self.klapa_belki);
    local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);
		if distance < nearestDistance then
			self.przy_klapa_belki = true;
		else
			self.przy_klapa_belki = false;
		end;
		
    if self.przy_klapa_belki then
		local baleCountInBaler = table.getn(self.bales);
		if baleCountInBaler == 0 or baleCountInBaler == 1 then
			if self.animationParts[15].clipStartTime then
				if InputBinding.hasEvent(InputBinding.klapa1_sipma) then
					if self.animationParts[8].clipEndTime then
						self:setAnimationTime(8, self.animationParts[8].offSet);
					elseif self.animationParts[8].clipStartTime  then
						self:setAnimationTime(8, self.animationParts[8].animDuration);	
					end;
				end;
			end;
		end;						
    end;

	if self.przy_klapa_belki then
		local baleCountInBaler = table.getn(self.bales);
		if baleCountInBaler == 0 or baleCountInBaler == 1 then
			if self.animationParts[15].clipStartTime then
				if self.animationParts[8].clipStartTime then
					g_currentMission:addHelpButtonText(string.format(g_i18n:getText("rozloz2_sipma5")), InputBinding.klapa1_sipma);
				else
					g_currentMission:addHelpButtonText(string.format(g_i18n:getText("zloz2_sipma5")), InputBinding.klapa1_sipma);	
				end;
			end;
		end;
	end;
	
	if self.przy_klapa_belki then
		if InputBinding.hasEvent(InputBinding.zaczep_sipma) then
			if self.animationParts[9].clipEndTime then
				self:setAnimationTime(9, self.animationParts[9].offSet);
			elseif self.animationParts[9].clipStartTime  then
				self:setAnimationTime(9, self.animationParts[9].animDuration);	
			end;
		end;
	end;

	if self.przy_klapa_belki then
		if self.animationParts[9].clipStartTime then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("zaczep_rozloz_sipma1")), InputBinding.zaczep_sipma);
		else
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("zaczep_zloz_sipma1")), InputBinding.zaczep_sipma);
		end;
	end;
	
	local nearestDistance = 1.5;
    local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
    local px, py, pz = getWorldTranslation(self.podbierak);
    local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);
		if distance < nearestDistance then
			self.przy_podbierak = true;
		else
			self.przy_podbierak = false;
		end;
		
    if self.przy_podbierak then
		if InputBinding.hasEvent(InputBinding.podbierak_sipma) then
			if self.animationParts[10].clipEndTime then
				self:setAnimationTime(10, self.animationParts[10].offSet);
			elseif self.animationParts[10].clipStartTime  then
				self:setAnimationTime(10, self.animationParts[10].animDuration);	
			end;
		end;
    end;
	
	if not self.animationParts[10].clipEndTime then
		self.isPickupLowered = false;
	else
		self.isPickupLowered = true;
	end;
	
	if self.przy_podbierak then
		if not self.isPickupLowered then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("rozloz1_sipma1")), InputBinding.podbierak_sipma);
		else
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("zloz1_sipma1")), InputBinding.podbierak_sipma);
		end;
	end;
	
	if self:getIsActive() then
		if self.animationParts[10].clipEndTime then
			rotate(self.kolko, 2.5 * self.lastSpeedReal * self.movingDirection * dt ,0,0);
		end;
	end;
	
	if not self.animationParts[8].clipEndTime and self:getIsActive(false) then
		self.isTurnedOn = false;
	end;
	
	if not self.animationParts[8].clipEndTime and self:getIsActive(false) then
		if Input.isKeyPressed(Input.KEY_b) then
			g_currentMission:showBlinkingWarning(g_i18n:getText("info_sipma"), 2000);
		end;
	end;

	if not self.animationParts[8].clipEndTime and self:getIsActive(false) then
		g_currentMission:addExtraPrintText(g_i18n:getText("KLAPA_info1"));
	end;
	
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.hud_sipma) then
			self.HUD = not self.HUD;
		end;
	end;

	if table.getn(self.bales) > self.lastBaleCount then
		self.TotalBalesCount = self.TotalBalesCount + 1;
		self.lastBaleCount = self.lastBaleCount + 1;
	elseif table.getn(self.bales) < self.lastBaleCount then
		self.lastBaleCount = self.lastBaleCount - 1;
	end;
	
	if self.TotalBalesCount >= 250 then
		self.isTurnedOn = false;
		if self.animationParts[12].clipStartTime  then
			self:setAnimationTime(12, self.animationParts[12].animDuration);	
		end;
		if self:getIsActive() then
			g_currentMission:showBlinkingWarning(g_i18n:getText("info1_sipma"));
		end;
		if self.przy_klapa_tylna then
			if self.animationParts[7].clipEndTime then
				if Input.isKeyPressed(Input.KEY_o) then
					if self.animationParts[12].clipEndTime then
						self:setAnimationTime(12, self.animationParts[12].offSet);
					end;
					self.TotalBalesCount = 0;
					g_currentMission:addSharedMoney(-50);
				end;
			end;
		end;
	end;
	
	if self.przy_klapa_tylna then
		if self.animationParts[7].clipEndTime then
			if self.TotalBalesCount >= 250 then
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("sipma_sznurek"), self.typeDesc), InputBinding.sznurek_sipma)
			end;
		end;
	end;
	
	if self.attacherVehicle ~= nil then
		self:setAnimationTime(13, self.animationParts[13].animDuration);
	else
		self:setAnimationTime(13, self.animationParts[13].startPosition);
	end;
	
	if self.przy_podbierak then
		if InputBinding.hasEvent(InputBinding.skladanie_sipma) then
			self:setRopePanel(not self.ropePanel);
		end;
		if self.ropePanel then
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("open_sipma"), self.typeDesc), InputBinding.skladanie_sipma);
		else
			g_currentMission:addHelpButtonText(string.format(g_i18n:getText("close_sipma"), self.typeDesc), InputBinding.skladanie_sipma);
		end;
	end;
end;

function PK4000:setRopePanel(isRopePanel)
	if isRopePanel then
		if self.ropePanelAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.ropePanelAnimation, -1, nil, true);
			self.ropePanel = true;
		end;
	else
		if self.ropePanelAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.ropePanelAnimation, 1, nil, true);
			self.ropePanel = false;
		end;
	end;
end;

function PK4000:mouseEvent(posX, posY, isDown, isUp, button)
end;

function PK4000:validateAttacherJoint(implement, jointDesc, dt)
return true;
end;

function PK4000:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then	
		local TotalBalesCount = Utils.getNoNil(getXMLInt(xmlFile, key.."#totalBalesCount"),0);
		self.TotalBalesCount = TotalBalesCount;
		
		local hud = getXMLBool(xmlFile, key.."#hud");
		if hud ~= nil then
			self.HUD = hud;
		end;
	end;
    return BaseMission.VEHICLE_LOAD_OK;
end;

function PK4000:getSaveAttributesAndNodes(nodeIdent)
	local TotalBalesCount = Utils.getNoNil(self.TotalBalesCount, 0);

	if self.HUD then
		hud = "true";
	else
		hud = "false";
	end;
	
	local attributes = string.format('hud="%s" totalBalesCount="%d"',hud,TotalBalesCount);
    return attributes,nodes;
end

function PK4000:draw()
	if self.HUD then
		self.HUDSipma:render();
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("hud_off"), self.typeDesc), InputBinding.hud_sipma);
		if self.TotalBalesCount >= 230 then
			setTextBold(true);
			setTextColor(1,0,0,1);
			totalBalesCountString = string.format("%d", self.TotalBalesCount);
			renderText(0.9592, 0.8789, 0.022, string.format(totalBalesCountString));
		end;
		if self.TotalBalesCount >= 0 and self.TotalBalesCount < 230 then
			setTextColor(0,1,0,1);
			setTextBold(true);
			totalBalesCountString = string.format("%d", self.TotalBalesCount);
			renderText(0.9592, 0.8789, 0.022, string.format(totalBalesCountString));
		end;
	else
		g_currentMission:addHelpButtonText(string.format(g_i18n:getText("hud_on"), self.typeDesc), InputBinding.hud_sipma);	
	end;
end;