Pickup = {};
source("dataS/scripts/vehicles/specializations/PickupSetStateEvent.lua");
	
function Pickup.prerequisitesPresent(specializations)
    return true;
end;
	
function Pickup:preLoad(xmlFile)
    assert(self.allowPickingUp == nil, "Pickup needs to be the first specialization which implements allowPickingUp");
    self.allowPickingUp = Pickup.allowPickingUp;
end
	
function Pickup:load(xmlFile)
	
    self.setPickupState = Pickup.setPickupState;
    self.isLowered = Utils.overwrittenFunction(self.isLowered, Pickup.isLowered);
	    
    self.isPickupLowered = false;
    self.pickupAnimationName = Utils.getNoNil(getXMLString(xmlFile, "vehicle.pickupAnimation#name"), "");
    if self.playAnimation == nil or self.getIsAnimationPlaying == nil then
        self.pickupAnimationName = "";
        self.isPickupLowered = true;
    end;
    self.pickupAnimationLowerSpeed = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.pickupAnimation#lowerSpeed"), 1);
    self.pickupAnimationLiftSpeed = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.pickupAnimation#liftSpeed"), -self.pickupAnimationLowerSpeed); 
	    
    if self.pickupAnimationName ~= "" then
        self.pickupAnimationIsDefaultLowered = Utils.getNoNil(getXMLBool(xmlFile, "vehicle.pickupAnimation#isDefaultLowered"), false);
        local dir = -20;
        if self.pickupAnimationIsDefaultLowered then
            dir = 20;
            self.isPickupLowered = true;
        end;
        self:playAnimation(self.pickupAnimationName, dir, nil, true);
        AnimatedVehicle.updateAnimations(self, 99999999);
    end;
end;
	
function Pickup:delete()
end;
	
function Pickup:readStream(streamId, connection)
    local isPickupLowered = streamReadBool(streamId);
    self:setPickupState(isPickupLowered, true);
end;
	
function Pickup:writeStream(streamId, connection)
    streamWriteBool(streamId, self.isPickupLowered);
end;
	
function Pickup:mouseEvent(posX, posY, isDown, isUp, button)
end;
	
function Pickup:keyEvent(unicode, sym, modifier, isDown)
end;
	
function Pickup:update(dt)
end;
	
function Pickup:draw()
end;
	
function Pickup:setPickupState(isPickupLowered, noEventSend)
    PickupSetStateEvent.sendEvent(self, isPickupLowered, noEventSend)
    self.isPickupLowered = isPickupLowered;
	    
    if self.pickupAnimationName ~= "" then
        local animTime = nil;
        if self:getIsAnimationPlaying(self.pickupAnimationName) then
            animTime = self:getAnimationTime(self.pickupAnimationName);
        end;
        if isPickupLowered then
            self:playAnimation(self.pickupAnimationName, self.pickupAnimationLowerSpeed, animTime, true)
        else
            self:playAnimation(self.pickupAnimationName, self.pickupAnimationLiftSpeed, animTime, true)
        end;
    end;
end;
	
function Pickup:allowPickingUp()    
    return self.isPickupLowered;
end;
	
function Pickup:isLowered(superFunc, default)
    if not self.isPickupLowered then
        return false;
    end
	
    if superFunc ~= nil then
        return superFunc(self, default);
    end
    return default;
end;
	
function Pickup:onLowerAll(doLowering, jointDescIndex)
    self:setPickupState(doLowering);
end;