--for trailers  

RotationNodes = {}

function RotationNodes.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations);
end
function RotationNodes:load(xmlFile)
    ----------   ---
	self.RotateParts = {}
	local i = 0
	while true do
		local baseName = string.format("vehicle.RotateParts.rotatePart(%d)", i)
		local index = getXMLString(xmlFile, baseName .. "#index")
		if index == nil then
			break
		end
		local node = Utils.indexToObject(self.components, index)
		if node ~= nil then
			local entry = {}
			entry.node = node
			entry.speedX = getXMLFloat(xmlFile, baseName .. "#x")
			entry.speedY = getXMLFloat(xmlFile, baseName .. "#y")
			entry.speedZ = getXMLFloat(xmlFile, baseName .. "#z")
			entry.lastMotor = getXMLBool(xmlFile, baseName .. "#lastMotor")
			table.insert(self.RotateParts, entry)
		end
		i = i + 1
	end
    ----------   ---
end

function RotationNodes:delete()
end

function RotationNodes:mouseEvent(posX, posY, isDown, isUp, button)
end

function RotationNodes:keyEvent(unicode, sym, modifier, isDown)
end

function RotationNodes:update(dt)
    ----------    ---
	if self.attacherVehicle and self.attacherVehicle.isMotorStarted then
		for _, v in pairs(self.RotateParts) do
			if v.lastMotor then
				local motorRpm = self.attacherVehicle.motor.lastMotorRpm/100;
				rotate(v.node, v.speedX*motorRpm, v.speedY*motorRpm, v.speedZ*motorRpm);
			else
				rotate(v.node, v.speedX, v.speedY, v.speedZ);
			end
		end
	end;
    ----------    ---
end

function RotationNodes:updateTick(dt)
end

function RotationNodes:draw()
end
