-- by "Marhu" 
-- v 1.0
-- Date: 30.03.2013
-- to send Filling Status for MilkTrailer

MilchTrailerSetIsFillingEvent = {};
MilchTrailerSetIsFillingEvent_mt = Class(MilchTrailerSetIsFillingEvent, Event);

InitEventClass(MilchTrailerSetIsFillingEvent, "MilchTrailerSetIsFillingEvent");

function MilchTrailerSetIsFillingEvent:emptyNew()
    local self = Event:new(MilchTrailerSetIsFillingEvent_mt);
    return self;
end;
    
function MilchTrailerSetIsFillingEvent:new(object, fill, buy, unload)
	local self = MilchTrailerSetIsFillingEvent:emptyNew()
	self.object = object;
	self.fill = fill;
	self.buy = buy;
	self.unload = unload;
	return self;
end;

function MilchTrailerSetIsFillingEvent:readStream(streamId, connection)
	local id = streamReadInt32(streamId);
	self.fill = streamReadBool(streamId);
	self.buy = streamReadBool(streamId);
	self.unload = streamReadBool(streamId);
	self.object = networkGetObject(id);
	self:run(connection);
end;

function MilchTrailerSetIsFillingEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.fill);
	streamWriteBool(streamId, self.buy);
	streamWriteBool(streamId, self.unload);
end;

function MilchTrailerSetIsFillingEvent:run(connection)
	if not connection:getIsServer() then
		g_server:broadcastEvent(self, false, connection, self.object);
	end;
	if self.object ~= nil then
		self.object:setIsMilchTrailerFilling(self.fill, true);
		self.object:setIsMilchTrailerBuyMilk(self.buy, true);
		self.object:setIsZuchtFilling(self.unload, true);
	end;
end;

function MilchTrailerSetIsFillingEvent.sendEvent(vehicle, fill, buy, unload, noEventSend)
	if fill ~= vehicle.isMilchTrailerFilling or buy ~= vehicle.isMilchTrailerBuyMilk or unload ~= vehicle.isZuchtFilling then
		if noEventSend == nil or noEventSend == false then
			if g_server ~= nil then
				g_server:broadcastEvent(MilchTrailerSetIsFillingEvent:new(vehicle, fill, buy, unload), nil, nil, vehicle);
			else
				g_client:getServerConnection():sendEvent(MilchTrailerSetIsFillingEvent:new(vehicle, fill, buy, unload));
			end;
		end;
	end;
end;