
ChangeToolsEvent = {};
ChangeToolsEvent_mt = Class(ChangeToolsEvent, Event);

InitEventClass(ChangeToolsEvent, "ChangeToolsEvent");

function ChangeToolsEvent:emptyNew()
    local self = Event:new(ChangeToolsEvent_mt);
    self.className="ChangeToolsEvent";
    return self;
end;

function ChangeToolsEvent:new(vehicle, toolsState)
    local self = ChangeToolsEvent:emptyNew()
    self.vehicle = vehicle;
	self.toolsState = toolsState;
    return self;
end;

function ChangeToolsEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.toolsState = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function ChangeToolsEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.toolsState);
end;

function ChangeToolsEvent:run(connection)   
	self.vehicle:changeTools(self.toolsState, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(ChangeToolsEvent:new(self.vehicle, self.toolsState), nil, connection, self.vehicle);
    end;
end;

function ChangeToolsEvent.sendEvent(vehicle, toolsState, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(ChangeToolsEvent:new(vehicle, toolsState), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(ChangeToolsEvent:new(vehicle, toolsState));
		end;
	end;
end;
