
Plandeka = {};

function Plandeka.prerequisitesPresent(specializations)
    return true;
end;

function Plandeka:load(xmlFile)
	self.plandeka1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.plandeka1#index"));
    self.plandeka1Active = true;
    self.plandeka2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.plandeka2#index"));
    self.changeTools = SpecializationUtil.callSpecializationsFunction("changeTools");
	self.objectInRange = Plandeka.objectInRange;
end;

function Plandeka:readStream(streamId, connection)
	self:changeTools(streamReadBool(streamId), true);
end;

function Plandeka:writeStream(streamId, connection)
	streamWriteBool(streamId, self.plandeka1Active);
end;

function Plandeka:delete()
end;

function Plandeka:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Plandeka:keyEvent(unicode, sym, modifier, isDown)
end;

function Plandeka:update(dt)

	if self.plandeka1 ~= nil then
		setVisibility(self.plandeka1, self.plandeka1Active);
	end;
	if self.plandeka2 ~= nil then
		setVisibility(self.plandeka2, not self.plandeka1Active);
	end;
	
	if self.isClient then
		if self:objectInRange(self.plandeka1) then
			if InputBinding.hasEvent(InputBinding.NAKRYCIE) then
				self:changeTools(not self.plandeka1Active);
			end;
			if self.plandeka1Active then
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("ZDEJMIJ_PLANDEKE")), InputBinding.NAKRYCIE);
			else
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("ZALOZ_PLANDEKE")), InputBinding.NAKRYCIE);
			end;
		end;
	end;
end;

function Plandeka:draw()
end;

function Plandeka:onAttach()
end;

function Plandeka:onDetach()
end;

function Plandeka:changeTools(plandeka1Status,noEventSend)
	ChangeToolsEvent.sendEvent(self, plandeka1Status, noEventSend);
	self.plandeka1Active = plandeka1Status;
end;

function Plandeka:objectInRange(object)
	if g_currentMission.player ~= nil and object ~= nil then
		local nearestDistance = 2.5;
		local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
		local px, py, pz = getWorldTranslation(object); 
		local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);	
		if distance < nearestDistance then
			return true;
		else
			return false;
		end;
	else
		return false;
	end;
end;
