---------------------------------
-----------PompaCaprari-----------
---------------------------------
---------------------------------
--------- @author matteo135 ---------
-------- @date  11/07/10 --------
---------------------------------

Caprari = {};

function Caprari.prerequisitesPresent(specializations)
    return true;
end;

function Caprari:load(xmlFile)

	local rotationNodePartGora = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.rotationPartGora#index"));
    if rotationNodePartGora ~= nil then
        self.rotationPartGora = {};
        self.rotationPartGora.node = rotationNodePartGora;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartGora#minRot"));
        self.rotationPartGora.minRot = {};
        self.rotationPartGora.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartGora.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartGora.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.rotationPartGora#maxRot"));
        self.rotationPartGora.maxRot = {};
        self.rotationPartGora.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartGora.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartGora.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartGora.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartGora#rotTime"), 2)*250;
        self.rotationPartGora.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.rotationPartGora#touchRotLimit"), 10));
    end; 
end;
function Caprari:delete()
end;

function Caprari:mouseEvent(posX, posY, isDown, isUp, button)

end;

function Caprari:keyEvent(unicode, sym, modifier, isDown)


	if sym == Input.KEY_z then
		self.rotationMaxGora = isDown;
	end;
	if sym == Input.KEY_x then
		self.rotationMinGora = isDown;
	end;
end;

function Caprari:update(dt)

	local doRotate = self.rotationMaxGora or self.rotationMinGora
		if self.rotationPartGora ~= nil and doRotate then
			local x, y, z = getRotation(self.rotationPartGora.node);
			local rot = {x,y,z};
			local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartGora.maxRot, self.rotationPartGora.minRot, 3, self.rotationPartGora.rotTime, dt, not self.rotationMaxGora);
			setRotation(self.rotationPartGora.node, unpack(newRot));
		end;
end;

function Caprari:draw()

end;

function Caprari:onAttach(attacherVehicle)
         
end;

function Caprari:onDetach()
         
end;

function Caprari:onEnter()
end;

function Caprari:onLeave()
end;

function Caprari:onActivate()
end;

function Caprari:onDeactivate()
end;

function Caprari:onDeactivateSounds()
end;

function Caprari:addContactReports()
end;

function Caprari:removeContactReports()
end;

function Caprari:groundContactReport(objectId, otherObjectId, isStart, normalForce, tangentialForce)

end;

function Caprari:validateAttacherJoint(implement, jointDesc, dt)
end;