-- author: rafftnix
-- date: 30.06.2015

-- note: rafftnixGUI needed!!

WorkCamera = {};

function WorkCamera.prerequisitesPresent(specializations)
    return RafftnixGUI ~= nil;
end;

function WorkCamera:load(xmlFile)
	self.gui = RafftnixGUI:new(nil, false, false);

	local posX = getXMLFloat(xmlFile, "vehicle.workCamera.backGround#x");
	local posY = getXMLFloat(xmlFile, "vehicle.workCamera.backGround#y");
	local width = getXMLFloat(xmlFile, "vehicle.workCamera.backGround#width");
	local height = getXMLFloat(xmlFile, "vehicle.workCamera.backGround#height");
	local fileName = getXMLString(xmlFile, "vehicle.workCamera.backGround#fileName");
	self.gui:createImage(self.gui.baseElement, posX, posY, width, height, fileName);

	local cameraId = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.workCamera#index"));
	local posX = getXMLFloat(xmlFile, "vehicle.workCamera.position#x");
	local posY = getXMLFloat(xmlFile, "vehicle.workCamera.position#y");
	local width = getXMLFloat(xmlFile, "vehicle.workCamera.position#width");
	local height = getXMLFloat(xmlFile, "vehicle.workCamera.position#height");
	self.gui:createRenderOverlay(self.gui.baseElement, posX, posY, width, height, cameraId, 516, 516, getScreenAspectRatio());
end;

function WorkCamera:delete()
  
end;

function WorkCamera:mouseEvent(posX, posY, isDown, isUp, button)
end;

function WorkCamera:keyEvent(unicode, sym, modifier, isDown)
end;

function WorkCamera:update(dt)
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.WORKCAMERA) then
			local visibility = self.gui.baseElement.visibility;
			visibility = not visibility;
			if visibility then
				self.gui:open();
			else
				self.gui:close();
			end;
		end;
	elseif self.gui.baseElement.visibility then
		self.gui:close();
	end;
end;

function WorkCamera:draw()
	if self.gui.baseElement.visibility then
		g_currentMission:addHelpButtonText(g_i18n:getText("deactivateWorkCamera"), InputBinding.WORKCAMERA); 
	else
		g_currentMission:addHelpButtonText(g_i18n:getText("activateWorkCamera"), InputBinding.WORKCAMERA); 
	end;
end;