moveFillVolumeLoad = {};

function moveFillVolumeLoad.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Fillable, specializations);
end;

function moveFillVolumeLoad:load(xmlFile)
	local fvLoadCurveX = AnimCurve:new(linearInterpolator1);
	fvLoadCurveX:addKeyframe({v=0.507, time = 0});
	fvLoadCurveX:addKeyframe({v=0.507, time = 48});
	fvLoadCurveX:addKeyframe({v=0, time = 50});
	fvLoadCurveX:addKeyframe({v=0, time = 100});
	
	local fvLoadCurveZ = AnimCurve:new(linearInterpolator1);
	fvLoadCurveZ:addKeyframe({v=0.25, time = 0});
	fvLoadCurveZ:addKeyframe({v=0.25, time = 48});
	fvLoadCurveZ:addKeyframe({v=-4, time = 80});
	fvLoadCurveZ:addKeyframe({v=0.2, time = 80.1});
	fvLoadCurveZ:addKeyframe({v=3, time = 100});

	self.fvLoadCurveX = fvLoadCurveX;
	self.fvLoadCurveZ = fvLoadCurveZ;
end;

function moveFillVolumeLoad:delete()
end;

function moveFillVolumeLoad:mouseEvent(posX, posY, isDown, isUp, button)
end;

function moveFillVolumeLoad:keyEvent(unicode, sym, modifier, isDown)
end;

function moveFillVolumeLoad:update(dt)
	if self:getIsActive() then
		if self:getIsTurnedOn() then
			local percent = Utils.clamp(self.fillLevel / self:getCapacity(), 0, 1)*100;
			setTranslation(self.fillVolumeLoadInfo.node, self.fvLoadCurveX:get(percent), 4.251, self.fvLoadCurveZ:get(percent));
		end;
	end;
end;

function moveFillVolumeLoad:updateTick(dt)
end;

function moveFillVolumeLoad:draw()
end;