--
-- IndoorSound
-- Specialization for IndoorSound
--
-- @author  	Manuel Leithner (SFM-Modding)
-- @version 	v1.0
-- @date  		02/11/11
-- @history:	v1.0 - Initial version
--
-- free for noncommerical-usage
--

IndoorSound = {};

function IndoorSound.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function IndoorSound:load(xmlFile)

	self.indoorSounds = {};
	self.indoorSounds.sounds = {};
	i = 0;
	while true do 
		local key = string.format("vehicle.indoorSounds.sound(%d)", i);
		if not hasXMLProperty(xmlFile, key .. "#id") then
			break;
		end;
		
		local id = getXMLString(xmlFile, key .. "#id");
		
		local sound = {};
		sound.id = self[id].sample;
		sound.name = id;
		if sound.id == nil then
			break;
		end;
		sound.isDynamic = Utils.getNoNil(getXMLBool(xmlFile, key.."#isDynamic"), false);
		sound.playWhileTreshing = Utils.getNoNil(getXMLBool(xmlFile, key.."#playWhileTreshing"), false);
		sound.outdoor = self[id].volume;
		sound.indoorFactor = Utils.getNoNil(getXMLFloat(xmlFile, key .. "#percent"), 0.5);
		sound.indoor = sound.outdoor * sound.indoorFactor;
		table.insert(self.indoorSounds.sounds, sound);
		i = i + 1;
	end;
	
	self.indoorSounds.indoorCamIndex = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.indoorSounds#camIndex"), 2);	
	self.indoorSounds.lastCamIndex = 1;
	
	self.volume = 1;
end;

function IndoorSound:delete()
end;

function IndoorSound:readStream(streamId, connection)
end;

function IndoorSound:writeStream(streamId, connection)
end;

function IndoorSound:mouseEvent(posX, posY, isDown, isUp, button)
end;

function IndoorSound:keyEvent(unicode, sym, modifier, isDown)
end;

function IndoorSound:update(dt)
	if self.isEntered then
		if g_currentMission.driveControl ~= nil and g_currentMission.driveControl.useModules.inDoorSound then
			g_currentMission.driveControl.useModules.inDoorSound = false;
		end;
	end;
	if self:getIsActive() and self.isClient then
		if self:getIsTurnedOn() then
			if self.volume > 0 then
				self.volume = self.volume - dt/1000;
			else
				self.volume = 0;
			end;
		else
			if self.volume < 1 then
				self.volume = self.volume + dt/1000;
			else
				self.volume = 1;
			end;
		end;
	end;
end;

function IndoorSound:updateTick(dt)
	if self:getIsActiveForInput(false) then

		local sound = self.indoorSounds;
		if self.isMotorStarted then
			if (self.camIndex == sound.indoorCamIndex or self.passengerPlayer == g_currentMission.player) and self.animationParts[9].clipStartTime and self.animationParts[10].clipStartTime then
				for _, sound in pairs(sound.sounds) do
					if not sound.playWhileTreshing then
						if sound.isDynamic then
							self[sound.name].volume = sound.indoor*self.volume;
						else
							setSampleVolume(sound.id, sound.indoor*self.volume);	
						end;
					else
						if sound.isDynamic then
							self[sound.name].volume = sound.indoor;
						else
							setSampleVolume(sound.id, sound.indoor);	
						end;
					end;
				end;
				sound.lastCamIndex = self.camIndex;
			else
				for _, sound in pairs(sound.sounds) do
					if not sound.playWhileTreshing then
						if sound.isDynamic then
							self[sound.name].volume = sound.outdoor*self.volume;
						else
							setSampleVolume(sound.id, sound.outdoor*self.volume);	
						end;
					else
						if sound.isDynamic then
							self[sound.name].volume = sound.outdoor;
						else
							setSampleVolume(sound.id, sound.outdoor);	
						end;
					end;
				end;			
				sound.lastCamIndex = self.camIndex;
			end;
		end;
	end;
end;

function IndoorSound:draw()	
end;