--
-- InteractiveButtons
-- Specialization for an interactive control button
--
-- @author  	Manuel Leithner (SFM-Modding)
-- @version 	v2.1
-- @date  		29/08/11
-- @history:	v1.0 - Initial version
--				v2.0 - converted to ls2011
--				v2.1 - improvements
--

InteractiveButtons = {};

function InteractiveButtons.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(InteractiveControl, specializations);
end;

function InteractiveButtons:load(xmlFile)

	local i=0;
	while true do
		local buttonName = string.format("vehicle.interactiveComponents.buttons.button(%d)", i);	
		if not hasXMLProperty(xmlFile, buttonName) then
			break;
		end;
		local name = Utils.getNoNil(g_i18n:getText(getXMLString(xmlFile, buttonName .. "#name")), "ERROR");
		local mark = Utils.indexToObject(self.components, getXMLString(xmlFile, buttonName .. "#mark"));
		local highlight = getChildAt(mark, 0);
		local size = Utils.getNoNil(getXMLFloat(xmlFile, buttonName .. "#size"), 0.1);
		local event = getXMLString(xmlFile, buttonName .. "#event");
		local onMessage = g_i18n:getText(Utils.getNoNil(getXMLString(xmlFile, buttonName .. "#onMessage"), "ic_button_on"));
		local offMessage =  g_i18n:getText(Utils.getNoNil(getXMLString(xmlFile, buttonName .. "#offMessage") , "ic_button_off"));
	
		local button = Button:new(nil, highlight, name, mark, size, event, self, onMessage, offMessage, self.infoBar);
		
		button.synch = Utils.getNoNil(getXMLBool(xmlFile, buttonName .. "#synch"), true);

		table.insert(self.interactiveObjects, button);
		i = i + 1;
	end;
end;

function InteractiveButtons:delete()
end;

function InteractiveButtons:mouseEvent(posX, posY, isDown, isUp, button)
end;

function InteractiveButtons:keyEvent(unicode, sym, modifier, isDown)
end;

function InteractiveButtons:update(dt)	
end;

function InteractiveButtons:draw()
end;



--
-- Button Class
-- Specifies an interactive Button
--
-- SFM-Modding
-- @author  Manuel Leithner
-- @date  29/08/11
--

Button = {};

function Button:new(node, highlight, name, mark, size, event, vehicle, onMessage, offMessage, infobar)

	local Button_mt = Class(Button, InteractiveComponentInterface);	
    local instance = InteractiveComponentInterface:new(node, highlight, name, mark, size, onMessage, offMessage, infobar, Button_mt);

	instance.vehicle = vehicle;
	instance.event = event;
	
	return instance;	
end;

function Button:delete()
	InteractiveComponentInterface.delete(self);
end;

function Button:mouseEvent(posX, posY, isDown, isUp, button)
	InteractiveComponentInterface.mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function Button:keyEvent(unicode, sym, modifier, isDown)
	InteractiveComponentInterface.keyEvent(self, unicode, sym, modifier, isDown);
end;

function Button:update(dt)
	if self.vehicle ~= nil then
		if self.event == "foldPickup" then
			self.isOpen = self.vehicle.animationParts[2].clipEndTime;
		elseif self.event == "foldElevator" then
			self.isOpen = self.vehicle.animationParts[8].clipEndTime;
			
		elseif self.event == "turnOn" then
			self.isOpen = self.vehicle.isTurnedOn;
		--elseif self.event == "workLight1" then
			--self.isOpen = self.vehicle.B3["work"][1].a;
		--elseif self.event == "workLight2" then
			--self.isOpen = self.vehicle.B3["work"][2].a;
		--elseif self.event == "workLight3" then
			--self.isOpen = self.vehicle.B3["work"][3].a;
		--elseif self.event == "workLight4" then
			--self.isOpen = self.vehicle.B3["work"][4].a;
		end;
	end;
	InteractiveComponentInterface.update(self, dt);
end;

function Button:draw()
	InteractiveComponentInterface.draw(self);
end;

function Button:doAction(noEventSend, forceAction)
	if self.vehicle ~= nil then
		if self.event == "activatePickup" then
			self.vehicle:setCurrentTool(RopaEuroMaus.PICKUP);
		elseif self.event == "activateFrontArm" then
			self.vehicle:setCurrentTool(RopaEuroMaus.FRONTARM);
		elseif self.event == "activateCounterweight" then
			self.vehicle:setCurrentTool(RopaEuroMaus.COUNTERWEIGHT);
		elseif self.event == "activateSeat" then
			self.vehicle:setCurrentTool(RopaEuroMaus.SEAT);
		elseif self.event == "activateElevator" then
			self.vehicle:setCurrentTool(RopaEuroMaus.ELEVATOR);
		elseif self.event == "activateElevatorPart2" then
			self.vehicle:setCurrentTool(RopaEuroMaus.ELEVATOR_PART2);
		elseif self.event == "toggleSteering" then
			self.vehicle:changeSteeringMode();
		elseif self.event == "foldPickup" then
			self.vehicle:foldPickup()
		elseif self.event == "foldElevator" then
			self.vehicle:foldElevator()		
		elseif self.event == "turnOn" then
			self.vehicle:setIsTurnedOn(not self.vehicle.isTurnedOn);
		elseif self.event == "workLight1" then
			local lt = self.vehicle.B3["work"];			
			self.vehicle:setState("work:1", not lt[1].a);
		elseif self.event == "workLight2" then
			local lt = self.vehicle.B3["work"];			
			self.vehicle:setState("work:2", not lt[2].a);
		elseif self.event == "workLight3" then
			local lt = self.vehicle.B3["work"];			
			self.vehicle:setState("work:3", not lt[3].a);
		elseif self.event == "workLight4" then
			local lt = self.vehicle.B3["work"];			
			self.vehicle:setState("work:4", not lt[4].a);
		end;
	end;
end;

function Button:onEnter(dt)
	InteractiveComponentInterface.onEnter(self, dt);
end;

function Button:onExit(dt)
	InteractiveComponentInterface.onExit(self, dt);
end;

function Button:setActive()
	InteractiveComponentInterface.setActive(self, isActive);
end;

function Button:setVisible(isVisible)
	InteractiveComponentInterface.setVisible(self, isVisible);
end;