-- @ Ziuta
-- @ 27.02.2015
-- @ v1.0
--
-- http://landwirtschafts-simulator.pl/
-- Thanks for you help Koper :P
--
-- You can use and edit but keep the original author ;)

changeCapacity = {}

function changeCapacity.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(AnimatedVehicle, specializations) and SpecializationUtil.hasSpecialization(Fillable, specializations)
end

function changeCapacity:load(xmlFile)
	self.setMode = changeCapacity.setMode
	self.mode = 1
	self.extraCapacity = {}
    local i = 0
    while true do
		local key = string.format("vehicle.extraCapacity.extra(%d)", i)
		if not hasXMLProperty(xmlFile, key) then
            break
        end
		local capacity = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.capacity"), 0.0)
      	local newCapacity = Utils.getNoNil(getXMLFloat(xmlFile, key.."#capacity"), capacity)
		local animationName = getXMLString(xmlFile, key.."#animationName")
		table.insert(self.extraCapacity, {newCapacity=newCapacity, animationName=animationName})
		i = i + 1		
	end
end

function changeCapacity:delete()end

function changeCapacity:readStream(streamId, connection)
	self.mode = streamReadInt8(streamId)
end

function changeCapacity:writeStream(streamId, connection)
	streamWriteInt8(streamId, self.mode)
end

function changeCapacity:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	self.mode = Utils.getNoNil(getXMLInt(xmlFile, key.."#changeCapacity"),1)
	return BaseMission.VEHICLE_LOAD_OK
end

function changeCapacity:getSaveAttributesAndNodes(nodeIdent)
	local attributes = 'changeCapacity="'..tostring(self.mode)..'"'
	return attributes, nil
end

function changeCapacity:mouseEvent(posX, posY, isDown, isUp, button)end

function changeCapacity:keyEvent(unicode, sym, modifier, isDown)end

function changeCapacity:update(dt)
	if self.isClient then
		if self.fillLevel == 0 and self:getIsActiveForInput() then
			if InputBinding.hasEvent(InputBinding.changeCapacity) then
				if self.mode < table.getn(self.extraCapacity) then
					self.mode = self.mode + 1
				else 
					self.mode = 1
				end
				self:setMode(self.mode)
			end			
		end
				
		for k, part in pairs(self.extraCapacity) do
			if k == self.mode then
				self.capacity = part.newCapacity
				self:playAnimation(part.animationName,1,self:getAnimationTime(part.animationName),true)
			end
		end
	end
end

function changeCapacity:updateTick(dt)end

function changeCapacity:draw()
	g_currentMission:addHelpButtonText(g_i18n:getText("changeCapacity"), InputBinding.changeCapacity)
	if self.fillLevel ~= 0 and InputBinding.isPressed(InputBinding.changeCapacity) then
		g_currentMission:addWarning(g_i18n:getText("warning"), 0.07+0.022, 0.019+0.029)
	end
end

function changeCapacity:setMode(mode, noEventSend)
	self.mode = mode
	setModeEvent.sendEvent(self, mode, noEventSend)
end

--
-- MP ready
--

setModeEvent = {}
setModeEvent_mt = Class(setModeEvent, Event)

InitEventClass(setModeEvent, "setModeEvent")

function setModeEvent:emptyNew()
    local self = Event:new(setModeEvent_mt)
    return self
end

function setModeEvent:new(object, changeMode)
    local self = setModeEvent:emptyNew()
    self.object = object
	self.changeMode = changeMode
    return self
end

function setModeEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId)
	self.changeMode = streamReadInt8(streamId)
    self.object = networkGetObject(id)
    self:run(connection)
end

function setModeEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object))
	streamWriteInt8(streamId, self.changeMode)
end;

function setModeEvent:run(connection)
	self.object:setMode(self.changeMode, true)
    if not connection:getIsServer() then
        g_server:broadcastEvent(setModeEvent:new(self.object, self.changeMode), nil, connection, self.object)
    end
end

function setModeEvent.sendEvent(vehicle, changeMode, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(setModeEvent:new(vehicle, changeMode), nil, nil, vehicle)
		else
			g_client:getServerConnection():sendEvent(setModeEvent:new(vehicle, changeMode))
		end
	end
end