-- @ Ziuta
-- @ 27.02.2015
-- @ v1.0
--
-- http://landwirtschafts-simulator.pl/
-- Thanks for your help Koper,lip4 and Decker_MMIV :P
--
-- You can use and edit but keep the original author ;)

animXML = {}

function animXML.prerequisitesPresent(specializations)
   return SpecializationUtil.hasSpecialization(AnimatedVehicle, specializations)
end

function animXML:load(xmlFile)	
	self.getIsInRange = animXML.getIsInRange
	self.setAnim = animXML.setAnim
	self.onApproach = {}
	local i = 0
    while true do
		local key = string.format("vehicle.animate.object(%d)", i)
		if not hasXMLProperty(xmlFile, key) then
            break
        end
		local ob = {}
		ob.index = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"))
      	ob.minDistance = Utils.getNoNil(getXMLFloat(xmlFile, key.."#distance"), 1.0)
		ob.animationName = getXMLString(xmlFile, key.."#animationName")
		ob.animIsChange = false
		table.insert(self.onApproach, ob)
		i = i + 1
	end
end

function animXML:delete()
end

function animXML:readStream(streamId, connection)
	for i=1, table.getn(self.onApproach) do
		local state = streamReadBool(streamId)
		self:setAnim(i, state, true)
	end
end

function animXML:writeStream(streamId, connection)
	for i=1, table.getn(self.onApproach) do
		local ob = self.onApproach[i]
		local state = ob.animIsChange
		streamWriteBool(streamId, state)
	end
end

function animXML:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	local animChange = getXMLString(xmlFile, key.."#animationChange")
	local obj = false
	if animChange ~= nil then
		local ob = Utils.splitString(" ", animChange)		
		for i=1, table.getn(self.onApproach) do
			if ob[i] == "true" then
				obj = true
			elseif ob[i] == "false" then
				obj = false
			end
			local state = obj
			self:setAnim(i, state)
		end
	elseif animChange == nil then
		for i=1, table.getn(self.onApproach) do
			self:setAnim(i, obj)
		end
	end	
	return BaseMission.VEHICLE_LOAD_OK
end

function animXML:getSaveAttributesAndNodes(nodeIdent)
	local attributes = 'animationChange="'
	for i=1, table.getn(self.onApproach) do
		local ob = self.onApproach[i]
		local state = ob.animIsChange
		attributes = attributes..tostring(state).." "
	end
	attributes = attributes..'"'
	return attributes, ""
end

function animXML:mouseEvent(posX, posY, isDown, isUp, button)
end

function animXML:keyEvent(unicode, sym, modifier, isDown)
end

function animXML:update(dt)
	if self.isClient then
		for i=1, table.getn(self.onApproach) do
			if self:getIsInRange(i) then
				if InputBinding.hasEvent(InputBinding.anim) then
					self:setAnim(i, not self.onApproach[i].animIsChange)
				end
				local animTime = self:getAnimationTime(self.onApproach[i].animationName)
				if animTime > 0 then
					g_currentMission:addHelpButtonText(g_i18n:getText("close"), InputBinding.anim)
				elseif animTime < 1 then
					g_currentMission:addHelpButtonText(g_i18n:getText("open"), InputBinding.anim)
				end
			end
		end
	end
end

function animXML:draw()
end

function animXML:getIsInRange(i)
	local rx, ry, rz = getWorldTranslation(g_currentMission.player.rootNode)
	local ox, oy, oz = getWorldTranslation(self.onApproach[i].index)
	local distance = Utils.vector3Length(rx-ox, ry-oy, rz-oz)

	if distance <= self.onApproach[i].minDistance then
		return true
	else
		return false
	end
end

function animXML:setAnim(index, state, noEventSend)
	setAnimEvent.sendEvent(self, index, state, noEventSend)
	local ob = self.onApproach[index]
	local animTime = self:getAnimationTime(ob.animationName)
	if state and animTime < 1 then
		self:playAnimation(ob.animationName,1,animTime,true)
	elseif animTime > 0 then
		self:playAnimation(ob.animationName,-1,animTime,true)
	end
	ob.animIsChange = state
end

--
-- MP ready
--

setAnimEvent = {}
setAnimEvent_mt = Class(setAnimEvent, Event)

InitEventClass(setAnimEvent, "setAnimEvent")

function setAnimEvent:emptyNew()
    local self = Event:new(setAnimEvent_mt)
    return self
end

function setAnimEvent:new(object, index, state)
    local self = setAnimEvent:emptyNew()
    self.object = object
    self.index = index
	self.state = state
    return self
end

function setAnimEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId)
	self.object = networkGetObject(id)	
	self.index = streamReadInt8(streamId)
	self.state = streamReadBool(streamId)	
    self:run(connection)
end

function setAnimEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object))
	streamWriteInt8(streamId, self.index)
	streamWriteBool(streamId, self.state)
end;

function setAnimEvent:run(connection)
    self.object:setAnim(self.index, self.state, true)
    if not connection:getIsServer() then
        g_server:broadcastEvent(setAnimEvent:new(self.object, self.index, self.state), nil, connection, self.object)
    end
end

function setAnimEvent.sendEvent(vehicle, index, state, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(setAnimEvent:new(vehicle, index, state), nil, nil, vehicle)
		else
			g_client:getServerConnection():sendEvent(setAnimEvent:new(vehicle, index, state))
		end
	end
end