-- NI Modding
--
-- author  	Henly20 
-- date  	03-01-2013.
-- ni_modding@hotmail.com
-- http://nimodding.wordpress.com
--
LM126 = {}

function LM126.prerequisitesPresent(specializations)
    return true;
end;

function LM126:load(xmlFile)

	self.setArmOne = SpecializationUtil.callSpecializationsFunction("setArmOne");
	self.ArmOneAnimation = getXMLString(xmlFile, "vehicle.armOne#animationName");
	self.ArmOne = false;

	self.setArmTwo = SpecializationUtil.callSpecializationsFunction("setArmTwo");
	self.ArmTwoAnimation = getXMLString(xmlFile, "vehicle.armTwo#animationName");
	self.ArmTwo = false;
	
	self.setArmThree = SpecializationUtil.callSpecializationsFunction("setArmThree");
	self.ArmThreeAnimation = getXMLString(xmlFile, "vehicle.armThree#animationName");
	self.ArmThree = false;
	
	self.setCrateVisibility = SpecializationUtil.callSpecializationsFunction("setCrateVisibility");
	
	self.ramp = {};
	self.ramp[1] = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.ramp#index1"));
	self.ramp[2] = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.ramp#index2"));
	self.ramp[3] = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.ramp#index3"));
	self.ramp.node = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.ramp#indexramp"));
	
	self.crate = {};
	self.crate1 = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.crate#index1"));
	self.crate2 = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.crate#index2"));
	self.crate3 = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.crate#index3"));
	self.crate4 = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.crate#index4"));
	self.crate.node = Utils.indexToObject(self.components,getXMLString(xmlFile,"vehicle.crate#indexcrate"));
	
	self.ramp1Active = true;
	self.ramp2Active = false;
	self.ramp3Active = true;
	setVisibility(self.crate1, true);
	setVisibility(self.crate2, true);
	setVisibility(self.crate3, true);
	setVisibility(self.crate4, true);		
end;
      
function LM126:delete()
end;

function LM126:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
		local isArmTwoOn = Utils.getNoNil(getXMLBool(xmlFile, key .. "#isArmTwoOn"), false);
		if isArmTwoOn ~= nil then
			self:setArmTwo(isArmTwoOn);
		end;
		local isArmThreeOn = Utils.getNoNil(getXMLBool(xmlFile, key .. "#isArmThreeOn"), false);
		if isArmThreeOn ~= nil then
			self:setArmThree(isArmThreeOn);
		end;
		local isArmOneOn = Utils.getNoNil(getXMLBool(xmlFile, key .. "#isArmOneOn"), false);
		if isArmOneOn ~= nil then
			self:setArmOne(isArmOneOn);
		end;
		local crateId = Utils.getNoNil(getXMLBool(xmlFile, key .. "#crateId"), false);
		if crateId ~= nil then
			self:setCrateVisibility(crateId);
		end;		
	end;
    return BaseMission.VEHICLE_LOAD_OK;
end;

function LM126:getSaveAttributesAndNodes(nodeIdent)
	local attributes = ' ';
	
	local mystring = 'isArmTwoOn = "' .. tostring(self.isArmTwoOn) ..'"';	
	attributes = attributes .. mystring;

	local mystring = 'isArmThreeOn = "' .. tostring(self.isArmThreeOn) ..'"';	
	attributes = attributes .. mystring;
	
	local mystring = 'isArmOneOn = "' .. tostring(self.isArmOneOn) ..'"';	
	attributes = attributes .. mystring;

	local mystring = 'crateId = "' .. tostring(self.crateId) ..'"';	
	attributes = attributes .. mystring;	
	
    local node = nil;
	return attributes, node;
end;


function LM126:readStream(streamId, connection)
    self:setArmOne(streamReadBool(streamId), true);
    self:setArmTwo(streamReadBool(streamId), true); 
    self:setArmThree(streamReadBool(streamId), true);
	self:setCrateVisibility(streamReadBool(streamId), true);
end;

function LM126:writeStream(streamId, connection)
	streamWriteBool(streamId, self.ArmOne);
	streamWriteBool(streamId, self.ArmTwo);
	streamWriteBool(streamId, self.ArmThree);
	streamWriteBool(streamId, self.crate);	
end;

function LM126:mouseEvent(posX, posY, isDown, isUp, button)
end;
	  
function LM126:keyEvent(unicode, sym, modifier, isDown)
end;

function LM126:update(dt)

	if not self:getIsActive() then

		if self.RampsInRange then
			if self.isArmTwoOn then
				self:setArmThree(true);
			end;
			if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2) then
				self:setArmTwo(not self.isArmTwoOn);
			end;
			if self.isArmTwoOn then
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("rampoff"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA2);
			else
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("rampon"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA2);
			end;
		end;
		if self.BackCrateInRange and not self.crateId and not self.isArmTwoOn then
			if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA3) then
				self:setArmThree(not self.isArmThreeOn);
			end;
			if not self.crateId and not self.isArmTwoOn then
				if self.isArmThreeOn then
					g_currentMission:addHelpButtonText(string.format(g_i18n:getText("backcrateoff"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA3);
				else
					g_currentMission:addHelpButtonText(string.format(g_i18n:getText("backcrateon"), self.typeDesc), InputBinding.IMPLEMENT_EXTRA3);
				end;
			end;
		end;
		if self.CratesInRange and not self.crateId then		
			if InputBinding.hasEvent(InputBinding.LOWER_IMPLEMENT) then
				self:setArmOne(not self.isArmOneOn);
			end;	
			if self.isArmOneOn and not self.crateId then
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("raise"), self.typeDesc), InputBinding.LOWER_IMPLEMENT);
			else
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("lower"), self.typeDesc), InputBinding.LOWER_IMPLEMENT);
			end;
		end;
		if self.CratesVisibilityInRange then	
			if not self.crateId and InputBinding.hasEvent(InputBinding.CAMERA_SWITCH) then
				self:setArmThree(true);
				self:setArmOne(true);
			end;		
			if InputBinding.hasEvent(InputBinding.CAMERA_SWITCH) then
				self:setCrateVisibility(not self.crateId);
			end;	
			if self.crateId then
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("add"), self.typeDesc), InputBinding.CAMERA_SWITCH);
			else
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("remove"), self.typeDesc), InputBinding.CAMERA_SWITCH);
			end;
		end;
	end;
	if self:getIsActiveForInput() then

	end;
	
	
	for i, jointDesc in pairs(self.componentJoints) do
		setJointFrame(self.componentJoints[i].jointIndex, 0, self.componentJoints[i].jointNode);
	end;	
	
	setVisibility(self.ramp[1], self.ramp1Active);
	setVisibility(self.ramp[2], self.ramp2Active);
	setVisibility(self.ramp[3], self.ramp3Active);
	

end;

function LM126:updateTick(dt)	
	if g_currentMission.player ~= nil then
		local nearestDistance = 3.0;
		local x1,y1,z1 = getWorldTranslation(self.ramp.node);
		local x2,y2,z2 = getWorldTranslation(g_currentMission.player.rootNode);
		local distance = Utils.vector3Length(x1-x2,y1-y2,z1-z2);
		if distance < nearestDistance then
			self.RampsInRange = true; 
		else
			self.RampsInRange = false; 
		end;
		if distance < nearestDistance then
			self.BackCrateInRange = true; 
		else
			self.BackCrateInRange = false; 
		end;
		local x3,y3,z3 = getWorldTranslation(self.crate.node);
		local distance = Utils.vector3Length(x3-x2,y3-y2,z3-z2);
		if distance < nearestDistance then
			self.CratesInRange = true; 
		else
			self.CratesInRange = false; 
		end;
		if distance < nearestDistance then
			self.CratesVisibilityInRange = true; 
		else
			self.CratesVisibilityInRange = false; 
		end;
	end;
	if not self:getIsActive() then	
		if not self.crateId then
			setVisibility(self.crate1, true);
			setVisibility(self.crate2, true);
			setVisibility(self.crate3, true);
			setVisibility(self.crate4, true);		
		elseif self.crateId then
			setVisibility(self.crate1, false);
			setVisibility(self.crate2, false);
			setVisibility(self.crate3, false);
			setVisibility(self.crate4, false);		
		end;
	end;

end;

function LM126:onLeave()
end;

function LM126:draw()
	if self:getIsActive() then

	end;
end;

function LM126:setArmOne(isArmOne,noEventSend)
	SetArmOneEvent.sendEvent(self, isArmOne, noEventSend);
	-- Play ArmOne animation --
	self.isArmOneOn = isArmOne;
	if self.isArmOneOn then
		if self.ArmOneAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.ArmOneAnimation, 1, nil, true);
			self.ArmOne = true;
		end;
	else
		if self.ArmOneAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.ArmOneAnimation, -1, nil, true);
			self.ArmOne = false;
		end;
	end;	
end;

function LM126:setArmTwo(isArmTwo,noEventSend)
	SetArmTwoEvent.sendEvent(self, isArmTwo, noEventSend);
	-- Play ArmTwo animation --
	self.isArmTwoOn = isArmTwo;
	if self.isArmTwoOn then
		if self.ArmTwoAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.ArmTwoAnimation, 1, nil, true);
			self.ArmTwo = true;

			self.ramp1Active = false;
			self.ramp2Active = true;
			self.ramp3Active = false;
		end;
	else
		if self.ArmTwoAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.ArmTwoAnimation, -1, nil, true);
			self.ArmTwo = false;
			self.ramp1Active = true;
			self.ramp2Active = false;
			self.ramp3Active = true;
		end;
	end;	

	setVisibility(self.ramp[1], self.ramp1Active);
	setVisibility(self.ramp[2], self.ramp2Active);
	setVisibility(self.ramp[3], self.ramp3Active);
end;

function LM126:setArmThree(isArmThree,noEventSend)
	SetArmThreeEvent.sendEvent(self, isArmThree, noEventSend);
	-- Play ArmThree animation --
	self.isArmThreeOn = isArmThree;
	if self.isArmThreeOn then
		if self.ArmThreeAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.ArmThreeAnimation, 1, nil, true);
			self.ArmThree = true;
		end;
	else
		if self.ArmThreeAnimation ~= nil and self.playAnimation ~= nil then
			self:playAnimation(self.ArmThreeAnimation, -1, nil, true);
			self.ArmThree = false;
		end;
	end;	
end;

function LM126:setCrateVisibility(crate, noEventSend)
	if crate ~= self.crateId then
		 if noEventSend == nil or noEventSend == false then
			  if g_server ~= nil then
				  g_server:broadcastEvent(SetCrateVisibilityEvent:new(self, crate), nil, nil, self);
			  else
				  g_client:getServerConnection():sendEvent(SetCrateVisibilityEvent:new(self, crate));
			  end;
		  end;	
	end;

	self.crateId = crate;

	if not self.crateId then
		setVisibility(self.crate1, true);
		setVisibility(self.crate2, true);
		setVisibility(self.crate3, true);
		setVisibility(self.crate4, true);		
	elseif self.crateId then
		setVisibility(self.crate1, false);
		setVisibility(self.crate2, false);
		setVisibility(self.crate3, false);
		setVisibility(self.crate4, false);		
	end;
	
	
end;

SetArmOneEvent = {};
SetArmOneEvent_mt = Class(SetArmOneEvent, Event);

InitEventClass(SetArmOneEvent, "SetArmOneEvent");

function SetArmOneEvent:emptyNew()
    local self = Event:new(SetArmOneEvent_mt);
    self.className="SetArmOneEvent";
    return self;
end;

function SetArmOneEvent:new(vehicle, isArmOne)
    local self = SetArmOneEvent:emptyNew()
    self.vehicle = vehicle;
	self.isArmOne = isArmOne;
    return self;
end;

function SetArmOneEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isArmOne = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetArmOneEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.isArmOne);
end;

function SetArmOneEvent:run(connection)   
	self.vehicle:setArmOne(self.isArmOne, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetArmOneEvent:new(self.vehicle, self.isArmOne), nil, connection, self.vehicle);
    end;
end;

function SetArmOneEvent.sendEvent(vehicle, isArmOne, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetArmOneEvent:new(vehicle, isArmOne), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetArmOneEvent:new(vehicle, isArmOne));
		end;
	end;
end;

SetArmTwoEvent = {};
SetArmTwoEvent_mt = Class(SetArmTwoEvent, Event);

InitEventClass(SetArmTwoEvent, "SetArmTwoEvent");

function SetArmTwoEvent:emptyNew()
    local self = Event:new(SetArmTwoEvent_mt);
    self.className="SetArmTwoEvent";
    return self;
end;

function SetArmTwoEvent:new(vehicle, isArmTwo)
    local self = SetArmTwoEvent:emptyNew()
    self.vehicle = vehicle;
	self.isArmTwo = isArmTwo;
    return self;
end;

function SetArmTwoEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isArmTwo = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetArmTwoEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.isArmTwo);
end;

function SetArmTwoEvent:run(connection)   
	self.vehicle:setArmTwo(self.isArmTwo, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetArmTwoEvent:new(self.vehicle, self.isArmTwo), nil, connection, self.vehicle);
    end;
end;

function SetArmTwoEvent.sendEvent(vehicle, isArmTwo, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetArmTwoEvent:new(vehicle, isArmTwo), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetArmTwoEvent:new(vehicle, isArmTwo));
		end;
	end;
end;

SetArmThreeEvent = {};
SetArmThreeEvent_mt = Class(SetArmThreeEvent, Event);

InitEventClass(SetArmThreeEvent, "SetArmThreeEvent");

function SetArmThreeEvent:emptyNew()
    local self = Event:new(SetArmThreeEvent_mt);
    self.className="SetArmThreeEvent";
    return self;
end;

function SetArmThreeEvent:new(vehicle, isArmThree)
    local self = SetArmThreeEvent:emptyNew()
    self.vehicle = vehicle;
	self.isArmThree = isArmThree;
    return self;
end;

function SetArmThreeEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.isArmThree = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetArmThreeEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.isArmThree);
end;

function SetArmThreeEvent:run(connection)   
	self.vehicle:setArmThree(self.isArmThree, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(SetArmThreeEvent:new(self.vehicle, self.isArmThree), nil, connection, self.vehicle);
    end;
end;

function SetArmThreeEvent.sendEvent(vehicle, isArmThree, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetArmThreeEvent:new(vehicle, isArmThree), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetArmThreeEvent:new(vehicle, isArmThree));
		end;
	end;
end;

SetCrateVisibilityEvent = {};
SetCrateVisibilityEvent_mt = Class(SetCrateVisibilityEvent, Event);

InitEventClass(SetCrateVisibilityEvent, "SetCrateVisibilityEvent");

function SetCrateVisibilityEvent:emptyNew()
    local self = Event:new(SetCrateVisibilityEvent_mt);
    self.className="SetCrateVisibilityEvent";
    return self;
end;

function SetCrateVisibilityEvent:new(object, crate)
    local self = SetCrateVisibilityEvent:emptyNew()
    self.object = object;
	self.crate = crate;
    return self;
end;

function SetCrateVisibilityEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.crate = streamReadBool(streamId);
    self.object = networkGetObject(id);
    self:run(connection);
end;

function SetCrateVisibilityEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));	
	streamWriteBool(streamId, self.crate);	
end;

function SetCrateVisibilityEvent:run(connection)
	self.object:setCrateVisibility(self.crate, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(SetCrateVisibilityEvent:new(self.object, self.crate), nil, connection, self.object);
	end;
end;
