--
-- Tuer_R1
--
-- M@D Author:  Heady
-- M@D date: 24.11.2010
--
-- > Copyright (C) Heady - www.planet-ls.de < --
--

Tuer_R = {};

function Tuer_R.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(AnimatedVehicle, specializations);
end;

function Tuer_R:load(xmlFile)

	self.updateSendEvent = SpecializationUtil.callSpecializationsFunction("updateSendEvent");

	local Tuer_R = {};
    Tuer_R.name = getXMLString(xmlFile, "vehicle.Tuer_R#name");
    Tuer_R.openSpeedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.Tuer_R#upSpeedScale"), 1);
    Tuer_R.closeSpeedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.Tuer_R#downSpeedScale"), -Tuer_R.openSpeedScale);
    if Tuer_R.name ~= nil then
        self.Tuer_R = Tuer_R;
    end;
	self.Tuer_R.active = false;
	
	
	self.jointmove = false;

	
end;

function Tuer_R:delete()
end;

function Tuer_R:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Tuer_R:keyEvent(unicode, sym, modifier, isDown)
end;

function Tuer_R:readStream(streamId, connection)
	-- update animation on synchroninzation --
	local Tuer_RAnimTime = streamReadFloat32(streamId);
	
	if Tuer_RAnimTime ~= nil then
		local currentTime = self:getAnimationTime(self.Tuer_R.name);
		local speed = 1;
		if currentTime > Tuer_RAnimTime then
			speed = -1;
		end;
		self:playAnimation(self.Tuer_R.name, speed, currentTime, true);
		self:setAnimationStopTime(self.Tuer_R.name, Tuer_RAnimTime);
	end;

	AnimatedVehicle.updateAnimations(self, 50);		

end;

function Tuer_R:writeStream(streamId, connection)
	streamWriteFloat32(streamId, self:getAnimationTime(self.Tuer_R.name));
end;

function Tuer_R:update(dt)
	
	local movejoint = self.jointmove;

	if self:getIsActiveForInput() then	
		
		local isTuer_RActive = false;
		if InputBinding.isPressed(InputBinding.TUER_R_OPEN) then
			self.jointmove = true;		
			isTuer_RActive = true;
			if InputBinding.hasEvent(InputBinding.TUER_R_OPEN) then
				self:playAnimation(self.Tuer_R.name, self.Tuer_R.openSpeedScale, self:getAnimationTime(self.Tuer_R.name)); 
			end;
		elseif InputBinding.isPressed(InputBinding.TUER_R_CLOSE) then
			self.jointmove = true;	
			isTuer_RActive = true;	
			if InputBinding.hasEvent(InputBinding.TUER_R_CLOSE) then
				self:playAnimation(self.Tuer_R.name, self.Tuer_R.closeSpeedScale, self:getAnimationTime(self.Tuer_R.name)); 
			end;			
		end;
			
		if self.Tuer_R.active and not isTuer_RActive then
			self:stopAnimation(self.Tuer_R.name);	
			self.jointmove = false;
		end;
		self.Tuer_R.active = isTuer_RActive;
		
	end;
	
	if movejoint ~= self.jointmove then -- wenn gendert dann sende an server/client (minimierung der bertragungsrate) --
		self:updateSendEvent();
	end;
	
	if self:getIsActive() then
	
		if self.isServer then
			if self.attacherVehicle ~= nil and self.jointmove then
				for k, implement in pairs(self.attacherVehicle.attachedImplements) do
					local jointDesc = self.attacherVehicle.attacherJoints[implement.jointDescIndex];
					if k == self.attacherVehicle.selectedImplement  then
						setJointFrame(jointDesc.jointIndex, 1, self.attacherJoint.node);
					end;
				end;
			end;
		end;
		
	end;

end;

function Tuer_R:updateTick(dt)
	--[[if self:getIsActive() then
		for _, part in pairs(self.movingParts) do
			part.isDirty = true;
		end;	
	end;]]--
end;

function Tuer_R:draw()	

	g_currentMission:addExtraPrintText(InputBinding.getKeyNamesOfDigitalAction(InputBinding.TUER_R_OPEN).." / "..InputBinding.getKeyNamesOfDigitalAction(InputBinding.TUER_R_CLOSE)..": Tuer R auf / zu");
	
end;

function Tuer_R:updateSendEvent()	

	if g_server ~= nil then
		g_server:broadcastEvent(MPEvent:new(self));
	else
		g_client:getServerConnection():sendEvent(MPEvent:new(self));
	end;

end;


