--
-- Tuer_L1
--
-- M@D Author:  Heady
-- M@D date: 24.11.2010
--
-- > Copyright (C) Heady - www.planet-ls.de < --
--

Tuer_L = {};

function Tuer_L.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(AnimatedVehicle, specializations);
end;

function Tuer_L:load(xmlFile)

	self.updateSendEvent = SpecializationUtil.callSpecializationsFunction("updateSendEvent");

	local Tuer_L = {};
    Tuer_L.name = getXMLString(xmlFile, "vehicle.Tuer_L#name");
    Tuer_L.openSpeedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.Tuer_L#upSpeedScale"), 1);
    Tuer_L.closeSpeedScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.Tuer_L#downSpeedScale"), -Tuer_L.openSpeedScale);
    if Tuer_L.name ~= nil then
        self.Tuer_L = Tuer_L;
    end;
	self.Tuer_L.active = false;
	
	
	self.jointmove = false;

	
end;

function Tuer_L:delete()
end;

function Tuer_L:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Tuer_L:keyEvent(unicode, sym, modifier, isDown)
end;

function Tuer_L:readStream(streamId, connection)
	-- update animation on synchroninzation --
	local Tuer_LAnimTime = streamReadFloat32(streamId);
	
	if Tuer_LAnimTime ~= nil then
		local currentTime = self:getAnimationTime(self.Tuer_L.name);
		local speed = 1;
		if currentTime > Tuer_LAnimTime then
			speed = -1;
		end;
		self:playAnimation(self.Tuer_L.name, speed, currentTime, true);
		self:setAnimationStopTime(self.Tuer_L.name, Tuer_LAnimTime);
	end;

	AnimatedVehicle.updateAnimations(self, 50);		

end;

function Tuer_L:writeStream(streamId, connection)
	streamWriteFloat32(streamId, self:getAnimationTime(self.Tuer_L.name));
end;

function Tuer_L:update(dt)
	
	local movejoint = self.jointmove;

	if self:getIsActiveForInput() then	
		
		local isTuer_LActive = false;
		if InputBinding.isPressed(InputBinding.TUER_L_OPEN) then
			self.jointmove = true;		
			isTuer_LActive = true;
			if InputBinding.hasEvent(InputBinding.TUER_L_OPEN) then
				self:playAnimation(self.Tuer_L.name, self.Tuer_L.openSpeedScale, self:getAnimationTime(self.Tuer_L.name)); 
			end;
		elseif InputBinding.isPressed(InputBinding.TUER_L_CLOSE) then
			self.jointmove = true;	
			isTuer_LActive = true;	
			if InputBinding.hasEvent(InputBinding.TUER_L_CLOSE) then
				self:playAnimation(self.Tuer_L.name, self.Tuer_L.closeSpeedScale, self:getAnimationTime(self.Tuer_L.name)); 
			end;			
		end;
			
		if self.Tuer_L.active and not isTuer_LActive then
			self:stopAnimation(self.Tuer_L.name);	
			self.jointmove = false;
		end;
		self.Tuer_L.active = isTuer_LActive;
		
	end;
	
	if movejoint ~= self.jointmove then -- wenn gendert dann sende an server/client (minimierung der bertragungsrate) --
		self:updateSendEvent();
	end;
	
	if self:getIsActive() then
	
		if self.isServer then
			if self.attacherVehicle ~= nil and self.jointmove then
				for k, implement in pairs(self.attacherVehicle.attachedImplements) do
					local jointDesc = self.attacherVehicle.attacherJoints[implement.jointDescIndex];
					if k == self.attacherVehicle.selectedImplement  then
						setJointFrame(jointDesc.jointIndex, 1, self.attacherJoint.node);
					end;
				end;
			end;
		end;
		
	end;

end;

function Tuer_L:updateTick(dt)
	--[[if self:getIsActive() then
		for _, part in pairs(self.movingParts) do
			part.isDirty = true;
		end;	
	end;]]--
end;

function Tuer_L:draw()	

	g_currentMission:addExtraPrintText(InputBinding.getKeyNamesOfDigitalAction(InputBinding.TUER_L_OPEN).." / "..InputBinding.getKeyNamesOfDigitalAction(InputBinding.TUER_L_CLOSE)..": Tuer L auf / zu");
	
end;

function Tuer_L:updateSendEvent()	

	if g_server ~= nil then
		g_server:broadcastEvent(MPEvent:new(self));
	else
		g_client:getServerConnection():sendEvent(MPEvent:new(self));
	end;

end;


