-- Pronar_T680
-- 
--
-- @ Autor  FireAndIce (www.bm-modding.de)
-- @ Last Edit  20/12/2012

Pronar_T680 = {};

function Pronar_T680.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(Fillable, specializations) and SpecializationUtil.hasSpecialization(Cylindered, specializations); 
end;

function Pronar_T680:postLoad(xmlFile)
	setJointRotationLimit(self.componentJoints[2].jointIndex, 0, true, Utils.degToRad(-8), Utils.degToRad(8));
end;

function Pronar_T680:load(xmlFile)
	self.setTipAngle = SpecializationUtil.callSpecializationsFunction("setTipAngle");

	self.axle1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.axis#index1"));
	self.axle2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.axis#index2"));
	
	setJointRotationLimit(self.componentJoints[2].jointIndex, 0, true, Utils.degToRad(-8), Utils.degToRad(8));	
	
	getMass(self.components[2].node)
	setMass(self.components[2].node, 0.1)
	
	self.maxTipAngle = 47;
	self.currentTipAngle = 47;
end;

function Pronar_T680:delete()
end;

function Pronar_T680:readStream(streamId, connection)
	self:setTipAngle(streamReadInt8(streamId), true);
end;

function Pronar_T680:writeStream(streamId, connection)
	streamWriteInt8(streamId, self.currentTipAngle);
end;

function Pronar_T680:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Pronar_T680:keyEvent(unicode, sym, modifier, isDown)
end;

function Pronar_T680:update(dt)
	if self:getIsActive() and self.movingDirection ~= 0 then
		xr1,_,_ = getRotation(self.axle1);
		xr2,_,_ = getRotation(self.axle2);
		xrw1,yrw1,zrw1 = getRotation(self.wheels[1].repr);
		xrw2,yrw2,zrw2 = getRotation(self.wheels[2].repr);
		xrw3,yrw3,zrw3 = getRotation(self.wheels[3].repr);
		xrw4,yrw4,zrw4 = getRotation(self.wheels[4].repr);
		self.newRot1 = zrw1 - xr1;
		self.newRot2 = zrw3 - xr2;
		setRotation(self.wheels[1].repr, xrw1,yrw1,self.newRot1)
		setRotation(self.wheels[2].repr, xrw2,yrw2,self.newRot1)
		setRotation(self.wheels[3].repr, xrw3,yrw3,self.newRot2)
		setRotation(self.wheels[4].repr, xrw4,yrw4,self.newRot2)
	end;
end;

function Pronar_T680:updateTick(dt)
	for _, part in pairs(self.movingParts) do
		Cylindered.setDirty(self, part);
	end;

	for _, part in pairs(self.movingTools) do
		Cylindered.setDirty(self, part);
	end;
	
	if self:getIsActive() then
		if self:getIsActiveForInput() then
			if self.tipState == Trailer.TIPSTATE_CLOSED then
				if InputBinding.isPressed(InputBinding.CTA_plus) then
					self:setTipAngle(self.currentTipAngle + 1);
				elseif InputBinding.isPressed(InputBinding.CTA_minus) then
					self:setTipAngle(self.currentTipAngle - 1);
				end;
			end;
		end;
	end;
	
	self.animations["tipAnimationBack"].parts[1].endRot = {Utils.degToRad(-self.currentTipAngle), 0, 0};
	self.animations["tipAnimationBack"].parts[2].endRot = {Utils.degToRad(self.currentTipAngle), 0, 0};
	self.animations["tipAnimationLeft"].parts[1].endRot = {0, 0, Utils.degToRad(-self.currentTipAngle)};
	self.animations["tipAnimationLeft"].parts[2].endRot = {0, 0, Utils.degToRad(self.currentTipAngle)};
	self.animations["tipAnimationLeft"].parts[3].endRot = {0, 0, Utils.degToRad(self.currentTipAngle)};
	self.animations["tipAnimationRight"].parts[1].endRot = {0, 0, Utils.degToRad(self.currentTipAngle)};
	self.animations["tipAnimationRight"].parts[2].endRot = {0, 0, Utils.degToRad(-self.currentTipAngle)};
	self.animations["tipAnimationRight"].parts[3].endRot = {0, 0, Utils.degToRad(-self.currentTipAngle)};
	self.animations["tipAnimationGrainDoor"].parts[4].endRot = {Utils.degToRad(-self.currentTipAngle), 0, 0};
end;

function Pronar_T680:draw()
	if self.tipState == Trailer.TIPSTATE_CLOSED then
		g_currentMission:addExtraPrintText(string.format(g_i18n:getText("CHANGE_TIP_ANGLE")) .. " " .. InputBinding.getKeyNamesOfDigitalAction(InputBinding.CTA_minus) .. "/" .. InputBinding.getKeyNamesOfDigitalAction(InputBinding.CTA_plus));
		g_currentMission:addExtraPrintText(string.format(g_i18n:getText("CURRENT_TIP_ANGLE"), self.currentTipAngle));
	end;
end;

function Pronar_T680:onAttach(attacherVehicle)
	setJointRotationLimit(self.componentJoints[2].jointIndex, 0, true, Utils.degToRad(-20), Utils.degToRad(20));
end;

function Pronar_T680:onDetach()
	setJointRotationLimit(self.componentJoints[2].jointIndex, 0, true, Utils.degToRad(-8), Utils.degToRad(8));
end;

function Pronar_T680:setTipAngle(id, noEventSend)
	if id ~= self.currentTipAngle then
		if id >= self.maxTipAngle then
			id = 47;
		elseif id <= 0 then
			id = 0;
		end;
		
		self.currentTipAngle = id;
		sendTipAngleEvent.sendEvent(self, id, noEventSend);
	end;
end;

sendTipAngleEvent = {};
sendTipAngleEvent_mt = Class(sendTipAngleEvent, Event);

InitEventClass(sendTipAngleEvent, "sendTipAngleEvent");

function sendTipAngleEvent:emptyNew()
    local self = Event:new(sendTipAngleEvent_mt);
    self.className = "sendTipAngleEvent";
    return self;
end;

function sendTipAngleEvent:new(object, id)
    local self = sendTipAngleEvent:emptyNew()
    self.object = object;
	self.id = id;
    return self;
end;

function sendTipAngleEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.id = streamReadInt8(streamId);
    self.object = networkGetObject(id);
    self:run(connection);
end;

function sendTipAngleEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteInt8(streamId, self.id);
end;

function sendTipAngleEvent:run(connection)
	self.object:setTipAngle(self.id, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(sendTipAngleEvent:new(self.object, self.id), nil, connection, self.object);
	end;
end;
function sendTipAngleEvent.sendEvent(object, id, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(sendTipAngleEvent:new(object, id), nil, nil, object);
		else
			g_client:getServerConnection():sendEvent(sendTipAngleEvent:new(object, id));
		end;
	end;
end;