

Convert = {};
Convert.modDir = g_currentModDirectory;

function Convert.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations) and SpecializationUtil.hasSpecialization(Fillable, specializations);
end;

function Convert:load(xmlFile)

	self.convertFruit = SpecializationUtil.callSpecializationsFunction("convertFruit");
	self.setFillLevel = Utils.overwrittenFunction(self.setFillLevel, Convert.setFillLevel)

	local filename = getXMLString(xmlFile, "vehicle.materialHolder#file")
	if filename ~= nil then
		local materialFile = Utils.loadSharedI3DFile(Convert.modDir..filename)
		self.overwrite_material = getMaterial(Utils.indexToObject(materialFile,getXMLString(xmlFile, "vehicle.materialHolder#index")), 0);
	end
	
	self.currentFillType = fillType;
	self.convertModeForage = false;
	self.convertModeSilage = false;
	self.convertModeWoodchips = false;	
end;

function Convert:readStream(streamId, connection)
    
	self.convertModeForage = streamReadBool(streamId); 
	self.convertModeSilage = streamReadBool(streamId); 
	self.convertModeWoodchips = streamReadBool(streamId); 	
end;

function Convert:writeStream(streamId, connection) 
  
	streamWriteBool(streamId, self.convertModeForage);
	streamWriteBool(streamId, self.convertModeSilage);
	streamWriteBool(streamId, self.convertModeWoodchips);	
end;

function Convert:delete()
end;

function Convert:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Convert:keyEvent(unicode, sym, modifier, isDown)
end;

function Convert:update(dt)	
    if self:getIsActive() then		
		if self:getIsActiveForInput() then	
			if self.fillLevel > 0 then
				if self.currentFillType ~= Fillable.FILLTYPE_FORAGE and not self.convertModeForage and InputBinding.hasEvent(InputBinding.Kraftfutter) then
					self:convertFruit("forage", false);
				end;				
				if self.currentFillType ~= Fillable.FILLTYPE_SILAGE and not self.convertModeSilage and InputBinding.hasEvent(InputBinding.Biomasse) then
					self:convertFruit("silage", false);
				end;
				if self.currentFillType ~= Fillable.FILLTYPE_WOODCHIPS and not self.convertModeWoodchips and InputBinding.hasEvent(InputBinding.Brennstoff) then
					self:convertFruit("woodChips", false);
				end;				
				if self.fillLevel == self.capacity then
					if self.currentFillType ~= Fillable.FILLTYPE_FORAGE and self.convertModeForage then
						self:convertFruit("forage", false);						
					elseif self.currentFillType ~= Fillable.FILLTYPE_SILAGE and self.convertModeSilage then
						self:convertFruit("silage", false);
					elseif self.currentFillType ~= Fillable.FILLTYPE_WOODCHIPS and self.convertModeWoodchips then
						self:convertFruit("woodChips", false);						
					end;
				end;	
			end;
			if (self.convertModeForage or self.convertModeGrass) and InputBinding.hasEvent(InputBinding.CONVERTOFF) then
				self:convertFruit("conversionOFF", false);
			end;
		end;
	end;
end;

function Convert:updateTick()
end;

function Convert:convertFruit(fruitConversion, noEventSend) 

	if noEventSend == nil or noEventSend == false then	
		convertFruitEvent.sendEvent(self, fruitConversion, noEventSend); 	
	end;
	if fruitConversion == "forage" then 
		self.currentFillType = Fillable.FILLTYPE_FORAGE
		self.convertModeSilage = false;
		self.convertModeWoodchips = false;	
		self.convertModeForage = true;	
	elseif fruitConversion == "silage" then
		self.currentFillType = Fillable.FILLTYPE_SILAGE
		self.convertModeForage = false;		
		self.convertModeWoodchips = false;		
		self.convertModeSilage = true;
	elseif fruitConversion == "woodChips" then
		self.currentFillType = Fillable.FILLTYPE_WOODCHIPS
		self.convertModeForage = false;		
		self.convertModeSilage = false;
		self.convertModeWoodchips = true;		
	elseif fruitConversion == "conversionOFF" then
		self.convertModeForage = false;		
		self.convertModeSilage = false;
		self.convertModeWoodchips = false;		
	end;
end;

function Convert:draw()

	if self.fillLevel > 0 then
		if self.currentFillType ~= Fillable.FILLTYPE_FORAGE and not self.convertModeForage then	
			g_currentMission:addHelpButtonText(g_i18n:getText("Kraftfutter"), InputBinding.Kraftfutter);
		end;		
		if self.currentFillType ~= Fillable.FILLTYPE_SILAGE and not self.convertModeSilage then			
			g_currentMission:addHelpButtonText(g_i18n:getText("Biomasse"), InputBinding.Biomasse);
		end;
		if self.currentFillType ~= Fillable.FILLTYPE_WOODCHIPS and not self.convertModeWoodchips then			
			g_currentMission:addHelpButtonText(g_i18n:getText("Brennstoff"), InputBinding.Brennstoff);
		end;		
	end;
	if self.convertModeForage then
		g_currentMission:addHelpButtonText(g_i18n:getText("CONVERTOFF"), InputBinding.PRESSENSTOP);
		g_currentMission:addExtraPrintText(g_i18n:getText("CONVERTMODEFORAGE"));		
	elseif self.convertModeSilage then
		g_currentMission:addHelpButtonText(g_i18n:getText("CONVERTOFF"), InputBinding.PRESSENSTOP);
		g_currentMission:addExtraPrintText(g_i18n:getText("CONVERTMODESILAGE"));
	elseif self.convertModeWoodchips then
		g_currentMission:addHelpButtonText(g_i18n:getText("CONVERTOFF"), InputBinding.PRESSENSTOP);
		g_currentMission:addExtraPrintText(g_i18n:getText("CONVERTMODEWOODCHIPS"));		
	end;
end;

function Convert:setFillLevel(superFunc, fillLevel, fillType, force, fillSourceStruct)
	local lastFillType = self.currentFillType;
	
	superFunc(self, fillLevel, fillType, force, fillSourceStruct)
	
	if self.currentFillType ~= Fillable.FILLTYPE_UNKNOWN and self.currentFillType ~= lastFillType then
		for _, fillVolume in pairs(self.fillVolumes) do
            setMaterial(fillVolume.volume, self.overwrite_material, 0);
		end
	end
end

convertFruitEvent = {};
convertFruitEvent_mt = Class(convertFruitEvent, Event);

InitEventClass(convertFruitEvent, "convertFruitEvent");

function convertFruitEvent:emptyNew()
  
    local self = Event:new(convertFruitEvent_mt);
    self.className="convertFruitEvent";
    return self;
end;

function convertFruitEvent:new(vehicle, fruitConversion)

    local self = convertFruitEvent:emptyNew()
    self.vehicle = vehicle;
	self.fruitConversion = fruitConversion;
    return self;
end;

function convertFruitEvent:readStream(streamId, connection) 

    local id = streamReadInt32(streamId); 
	self.fruitConversion = streamReadString(streamId);  
    self.vehicle = networkGetObject(id); 
    self:run(connection);
end;

function convertFruitEvent:writeStream(streamId, connection) 
  
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
	streamWriteString(streamId, self.fruitConversion);
end;

function convertFruitEvent:run(connection) 
  
	if not connection:getIsServer() then	
		for k, v in pairs(g_server.clientConnections) do
			if v ~= connection and not v:getIsLocal() then
				v:sendEvent(convertFruitEvent:new(self.vehicle, self.fruitConversion));
			end;
		end;
	end;	
	self.vehicle:convertFruit(self.fruitConversion, true);
end;

function convertFruitEvent.sendEvent(vehicle, fruitConversion, noEventSend)  
		
	if g_server ~= nil then  
		g_server:broadcastEvent(convertFruitEvent:new(vehicle, fruitConversion), nil, nil, vehicle);
	else  
		g_client:getServerConnection():sendEvent(convertFruitEvent:new(vehicle, fruitConversion));
	end;
end;

