local metadata = {
"## Interface: 1.4.1.0 1.4.1RC2",
"## Title: ForageWagonEffects",
"## Notes: Load and handle Effects for ForageWagon",
"## Author: Marhu",
"## Version: 0.1.0-11",
"## Date: 24.01.2016",
"## Web: http://Marhu.net"
}

ForageWagonEffects = {};

function ForageWagonEffects.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(ForageWagon, specializations);
end;

function ForageWagonEffects:load(xmlFile)
	self.getAreTipScrollersActive = Utils.overwrittenFunction(self.getAreTipScrollersActive, ForageWagonEffects.getAreTipScrollersActive)
	
	self.ForageWagonParticleDeactivateTime = -1;
	
	self.turnedOnTipScrollerSpeedFactor = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.turnedOnTipScrollerSpeedFactor#value"), 0.25);
	
	if self.isClient then
			
		self.ForageWagonParticleSystems = {}
		local i = 0
		while true do
			local key = string.format("vehicle.ForageWagonParticleSystems.ForageWagonParticleSystem(%d)", i)
			local t = getXMLString(xmlFile, key .. "#type")

			if t == nil then
				break
			end

			local fillType = Fillable.fillTypeNameToInt[t]

			if fillType ~= nil then
				local currentPS = Utils.getNoNil(self.ForageWagonParticleSystems[fillType], {})
				local particleNode = Utils.loadParticleSystem(xmlFile, currentPS, key, self.components, false, nil, self.baseDirectory)

				self.ForageWagonParticleSystems[fillType] = currentPS

				if self.defaultForageWagonParticleSystem == nil then
					self.defaultForageWagonParticleSystem = currentPS
				end
			end

			i = i + 1
		end

		self.ForageWagonEffect = EffectManager:loadEffect(xmlFile, "vehicle.ForageWagonEffect", self.components, self)
		self.ForageWagonScrollers = Utils.loadScrollers(self.components, xmlFile, "vehicle.ForageWagonScrollers.ForageWagonScroller", {}, true)
    end;
   
end;
function ForageWagonEffects:delete()
    if self.isClient then
       
		EffectManager:deleteEffect(self.ForageWagonEffect)

		for _, v in pairs(self.ForageWagonParticleSystems) do
			Utils.deleteParticleSystem(v)
		end

    end;
end;
function ForageWagonEffects:readStream(streamId, connection)
end;
function ForageWagonEffects:writeStream(streamId, connection)
end;
function ForageWagonEffects:readUpdateStream(streamId, timestamp, connection)
end;
function ForageWagonEffects:writeUpdateStream(streamId, connection, dirtyMask)
end;
function ForageWagonEffects:mouseEvent(posX, posY, isDown, isUp, button)
end;
function ForageWagonEffects:keyEvent(unicode, sym, modifier, isDown)
end;
function ForageWagonEffects:update(dt)
	if self.isClient then
		if self:getIsActive() and self:getIsTurnedOn() and self.fillLevelIncreased == true then 
			local currentForageWagonScrollers = self.ForageWagonScrollers[self.lastValidFillType]

			if currentForageWagonScrollers ~= self.currentForageWagonScrollers and self.currentForageWagonScrollers ~= nil then
				self.lastForageWagonScrollers = self.currentForageWagonScrollers
			end

			self.currentForageWagonScrollers = currentForageWagonScrollers

			if self.currentForageWagonScrollers ~= nil then
				Utils.updateScrollers(self.currentForageWagonScrollers, dt, true, true)
			end
		elseif self.currentForageWagonScrollers ~= nil then
			if self.currentForageWagonScrollers.isRunning == true then
				Utils.updateScrollers(self.currentForageWagonScrollers, dt, false, true)
			else
				Utils.updateScrollers(self.currentForageWagonScrollers, dt, false, false)

				self.currentForageWagonScrollers = nil
			end
		end

		if self.lastForageWagonScrollers ~= nil then
			Utils.updateScrollers(self.lastForageWagonScrollers, dt, false, false)

			self.lastForageWagonScrollers = nil
		end
    end;
end;
function ForageWagonEffects:updateTick(dt)
   
    if self.isClient then
		if self:getIsActive() and self:getIsTurnedOn() and self.fillLevelIncreased == true then
			self.ForageWagonParticleDeactivateTime = g_currentMission.time + 500
			local currentForageWagonParticleSystem = self.ForageWagonParticleSystems[self.lastValidFillType]

			if currentForageWagonParticleSystem == nil then
				currentForageWagonParticleSystem = self.defaultForageWagonParticleSystem
			end

			if currentForageWagonParticleSystem ~= self.currentForageWagonParticleSystem then
				Utils.setEmittingState(self.currentForageWagonParticleSystem, false)

				self.currentForageWagonParticleSystem = currentForageWagonParticleSystem

				Utils.setEmittingState(self.currentForageWagonParticleSystem, true)
			end

			if self.ForageWagonEffect ~= nil then
				self.ForageWagonEffect:setFillType(self.lastValidFillType)
				EffectManager:startEffect(self.ForageWagonEffect)
			end
		elseif 0 <= self.ForageWagonParticleDeactivateTime and self.ForageWagonParticleDeactivateTime <= g_currentMission.time then
			self.ForageWagonParticleDeactivateTime = -1

			if self.currentForageWagonParticleSystem ~= nil then
				Utils.setEmittingState(self.currentForageWagonParticleSystem, false)

				self.currentForageWagonParticleSystem = nil
			end

			if self.ForageWagonEffect ~= nil then
				EffectManager:stopEffect(self.ForageWagonEffect)
			end
		end;
	end;
end;
function ForageWagonEffects:draw()
end;
function ForageWagonEffects:getAreTipScrollersActive(superFunc)
	local value = 0

	if self:getIsTurnedOn() then
		value = self.turnedOnTipScrollerSpeedFactor;
	end

	return math.max(value, superFunc(self))
end