--
-- FastCouplerFastCouplerPowerShaft
-- Specialization for FastCouplerPowerShaft
--
-- @author  Manuel Leithner
-- @date  10/08/09
--
--
-- @Edit: Bluebaby210 to LS13
-- @date 13/03/2013
--
-- v2.0 ptoOutputNode to FastCoupler
--
--		<powerShaft index="XXX" part="XXX" fixPoint="XXX"/>
--		<powerShaft index="XXX" overrideFilename="Texturen/powerTakeoff.i3d"/>
--
--		if overrideFilename="Texturen/powerTakeoff.i3d" the PTO load from direction, then part and fixPoint not necessary.
--		if use overrideFilename then pto not visibility when detach implement.
--		 
-- 

FastCouplerPowerShaft = {};

function FastCouplerPowerShaft.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(FastCouplerAttachment, specializations);
end;

function FastCouplerPowerShaft:load(xmlFile)

	self.ptoAttach = SpecializationUtil.callSpecializationsFunction("ptoAttach");
	self.ptoDetach = SpecializationUtil.callSpecializationsFunction("ptoDetach");

	self.fastCouplerPowerShaft = {};		
	self.fastCouplerPowerShaft.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.powerShaft#index"));
	

	local filename = Utils.getNoNil(getXMLString(xmlFile, "vehicle.powerShaft#overrideFilename"), nil);
		if filename ~= nil then
			self.filename = Utils.getFilename(filename, self.baseDirectory);
			self.pto = Utils.loadSharedI3DFile(self.filename);
			if self.pto ~= 0 then
				link(self.fastCouplerPowerShaft.node, self.pto);
				local x,y,z = getRotation(self.fastCouplerPowerShaft.node);
				self.fastCouplerPowerShaft.rot = {x,y,z};
				local rootNode = getChildAt(self.pto, 0);
				local node = getChildAt(rootNode, 0);
				local nodefix = getChildAt(node, 0);
				self.fastCouplerPowerShaft.part = nodefix;
				x,y,z = getTranslation(self.fastCouplerPowerShaft.part);
				self.fastCouplerPowerShaft.trans = {x,y,z};
				local attachNode = getChildAt(self.fastCouplerPowerShaft.part, 0);
				self.fastCouplerPowerShaft.fixPoint = attachNode;
				local ax, ay, az = getWorldTranslation(self.fastCouplerPowerShaft.part);
				local bx, by, bz = getWorldTranslation(self.fastCouplerPowerShaft.fixPoint);
				self.fastCouplerPowerShaft.distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
				setVisibility(self.pto, false);
			end;
		else
			local x,y,z = getRotation(self.fastCouplerPowerShaft.node);
			self.fastCouplerPowerShaft.rot = {x,y,z};	
			self.fastCouplerPowerShaft.part = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.powerShaft#part"));
			x,y,z = getTranslation(self.fastCouplerPowerShaft.part);
			self.fastCouplerPowerShaft.trans = {x,y,z};
			self.fastCouplerPowerShaft.fixPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.powerShaft#fixPoint"));
			local ax, ay, az = getWorldTranslation(self.fastCouplerPowerShaft.part);
			local bx, by, bz = getWorldTranslation(self.fastCouplerPowerShaft.fixPoint);		
			self.fastCouplerPowerShaft.distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
		end;

	self.attacherVehiclePowerShaft = nil;
	self.doPowerShaftJointSearch = false;
end;

function FastCouplerPowerShaft:ptoAttach()
	if self.pto ~= nil then
		setVisibility(self.pto, true);
	end;
end;

function FastCouplerPowerShaft:ptoDetach()
	if self.pto ~= nil then
		setVisibility(self.pto, false);
	end;
end;

function FastCouplerPowerShaft:delete()
	if self.pto ~= nil then
		delete(self.pto);
	end;
end;

function FastCouplerPowerShaft:mouseEvent(posX, posY, isDown, isUp, button)
end;

function FastCouplerPowerShaft:keyEvent(unicode, sym, modifier, isDown)
end;

function FastCouplerPowerShaft:update(dt)
	
	if self.doPowerShaftJointSearch then
		if self.fastCouplerAttacher ~= nil then 
		for i=1, table.getn(self.fastCouplerAttacher.attachedImplements) do
			if self.fastCouplerAttacher.attachedImplements[i].object == self.attacherVehicle then			
				local index = self.fastCouplerAttacher.attachedImplements[i].jointDescIndex;
				local joint = self.fastCouplerAttacher.attacherJoints[index];	
				if joint.ptoOutput.node ~= nil then
					self.attacherVehiclePowerShaft = joint.ptoOutput.node;
					--print(".................... >>> self.attacherVehiclePowerShaft ="..tostring(self.attacherVehiclePowerShaft));
					break;						
				end;
			end;
		end;
		self.doPowerShaftJointSearch = false;	
		end;
	end;
	
	if self:getIsActive() then	
		if self.attacherVehiclePowerShaft ~= nil then	
			local ax, ay, az = getWorldTranslation(self.fastCouplerPowerShaft.node);
			local bx, by, bz = getWorldTranslation(self.attacherVehiclePowerShaft);
			local x, y, z = worldDirectionToLocal(getParent(self.fastCouplerPowerShaft.node), bx-ax, by-ay, bz-az);
			setDirection(self.fastCouplerPowerShaft.node, x, y, z, 0, -1, 0);
			local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			setTranslation(self.fastCouplerPowerShaft.part, 0, 0, distance-self.fastCouplerPowerShaft.distance);		
		end;
	end;
	
end;

function FastCouplerPowerShaft:draw()
end;

function FastCouplerPowerShaft:onAttach(attacherVehicle)
	self:ptoAttach();
	self.doPowerShaftJointSearch = true;
end;

function FastCouplerPowerShaft:onDetach()
	setTranslation(self.fastCouplerPowerShaft.part, unpack(self.fastCouplerPowerShaft.trans));
	setRotation(self.fastCouplerPowerShaft.node, unpack(self.fastCouplerPowerShaft.rot));
	self.attacherVehiclePowerShaft = nil;
	self:ptoDetach();
end;

function FastCouplerPowerShaft:onFastCouplerDetach()
	setTranslation(self.fastCouplerPowerShaft.part, unpack(self.fastCouplerPowerShaft.trans));
	setRotation(self.fastCouplerPowerShaft.node, unpack(self.fastCouplerPowerShaft.rot));
	self.attacherVehiclePowerShaft = nil;
	self:ptoDetach();
end;

function FastCouplerPowerShaft:onFastCouplerAttach(attacherVehicle)
	self.doPowerShaftJointSearch = true;
	self:ptoAttach();
end;





