 --
-- Easycut
-- Class for all easycuts
--
-- @author  Stefan Geiger 
-- @date  11/05/08	    
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

--[[  ## EDITS ##

15.05.2011 - FIAT80-90DT | swath function, particleSystem, copy to spec
23.03.2013 - Bluebaby210 | Animation for sideParts | Rotation swath drums | delete drawPart, control from fastCoupler

]]--
 
Easycut = {};
  
function Easycut.prerequisitesPresent(specializations)
	Vehicle.registerJointType("fastCoupling");
	print('register JointType '..'"'..'fastCoupling'..'"' )
    return true;
end;
  
function Easycut:load(xmlFile)

  	
	-- ps - ParticleSystem
	self.particleSystems = {};
    local i = 0;
    while true do
        local systemi = string.format("vehicle.particleSystems.system(%d)", i);
		local indexi = Utils.indexToObject(self.components, getXMLString(xmlFile, systemi .. "#index"));
		if indexi == nil then
			break;
		end; 
        Utils.loadParticleSystem(xmlFile, self.particleSystems, systemi, indexi, false, nil, self.baseDirectory)		
		i = i +1;		
    end;
	
	self.checkGrassAreas = {};
	local numCheckAreas = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.checkGrassAreas#count"), 0);
    for i=1, numCheckAreas do
		self.checkGrassAreas[i] = {};
		local areanamei = string.format("vehicle.checkGrassAreas.checkGrassArea%d", i);
		self.checkGrassAreas[i].start = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#startIndex"));
		self.checkGrassAreas[i].width = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#widthIndex"));
        self.checkGrassAreas[i].height = Utils.indexToObject(self.components, getXMLString(xmlFile, areanamei .. "#heightIndex"));
	end;
	
	--Expand
	self.AnimDone = true;	
		
	--rotatingPlates	
	self.rotPlates = {};
	local i=0;
	while true do
		local main = string.format("vehicle.rotPlates.plate(%d)", i);
		local rotPoint = getXMLString(xmlFile, main.. "#rotPoint");
		local x,y,z = Utils.getVectorFromString(getXMLString(xmlFile, main.. "#rotTempo"));
		local rotTempo = {x,y,z};
		local timeTillOff = Utils.getNoNil(getXMLFloat(xmlFile, main.. "#timeTillOff"), 1);
		if rotPoint == nil or rotTempo == nil or timeTillOff == nil then
			break;
		end;
		local node = Utils.indexToObject(self.components, rotPoint);
		if node ~= nil then
			local var = {};
			var.node = node;
			var.timeTillOff = timeTillOff;
			var.rotTempoMax = rotTempo;
			var.rotTempoMin = {0,0,0};
			var.rotTempoNow = {0,0,0};
			table.insert(self.rotPlates, var);
			self.newRotPlates = {};
			self.newRotPlates = {0,0,0};
		end;
		
		i = i+1;
	end;


end;

function Easycut:draw()  
end;

function Easycut:delete()  
	if self.particleSystems ~= nil then
		Utils.deleteParticleSystem(self.particleSystems);
	end;
end;
  
function Easycut:mouseEvent(posX, posY, isDown, isUp, button)
end;
 
function Easycut:keyEvent(unicode, sym, modifier, isDown)
end;

function Easycut:update(dt)
	if self:getIsActive() then
		if self:getRealAnimationTime("Expand") == self:getAnimationDuration("Expand") or self:getRealAnimationTime("Expand") == 0 then
			self.AnimDone = true;
		else
			self.AnimDone = false;
		end;
	end;
end;

function Easycut:updateTick(dt)
	self.wasToFast = false;
	if self:getIsActive() then
		if self.isTurnedOn then
			local x1,y1,z1 = getWorldTranslation(self.groundReferenceNode);
			local terrain = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x1, 0, z1);
			if terrain+self.groundReferenceThreshold >= y1 then
				local toFast = self:doCheckSpeedLimit() and self.lastSpeed*3600 > 31;
				if not toFast then 
					if self.isServer then
						local x,y,z = getWorldTranslation(self.groundReferenceNode);
						local terrainHeight = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, x, 0, z);
						if terrainHeight+self.groundReferenceThreshold >= y then
							for _, checkGrassArea in pairs(self.checkGrassAreas) do
								if self:getIsAreaActive(checkGrassArea) then
									local x,y,z = getWorldTranslation(checkGrassArea.start);
									local x1,y1,z1 = getWorldTranslation(checkGrassArea.width);
									local x2,y2,z2 = getWorldTranslation(checkGrassArea.height);
									local CheckArea = Utils.getFruitArea(FruitUtil.FRUITTYPE_GRASS, x, z, x1, z1, x2, z2);
									if CheckArea > 0 and self.lastSpeed*3600 > 1 and self.lastSpeed*3600 < 31 then
										self.showPS = true;
										Utils.setEmittingState(self.particleSystems, true);
									else
										self.showPS = false;
										Utils.setEmittingState(self.particleSystems, false);	
									end;
								end;
							end;		
						else
							if self.showPS then
								self.showPS = false;
								Utils.setEmittingState(self.particleSystems, false);
							end;
						end;
					end;
				else
					if self.showPS then
						self.showPS = false;
						Utils.setEmittingState(self.particleSystems, false);
					end;
				end;
			
				self.wasToFast = toFast;
			else
				if self.showPS then
					self.showPS = false;
					Utils.setEmittingState(self.particleSystems, false);
				end;
			end;
						
		else
			if self.showPS then
				self.showPS = false;
				Utils.setEmittingState(self.particleSystems, false);
			end;
		end;

		--rotatingPlates
		for s, plate in pairs(self.rotPlates) do
			local values = Utils.getMovedLimitedValues(plate.rotTempoNow, plate.rotTempoMax, plate.rotTempoMin, 3, plate.timeTillOff*2500, dt, not self.isTurnedOn);
			plate.rotTempoNow = values;
			rotate(plate.node, unpack(plate.rotTempoNow));
		end;

	end;
end;

function Easycut:draw()
end;

function Easycut:onDetach()
	if self.particleSystems ~= nil then
		if self.showPS then
			self.showPS = false;
			Utils.setEmittingState(self.particleSystems, false);
		end;
		for s, plate in pairs(self.rotPlates) do
			plate.rotTempoNow = self.newRotPlates;
		end;
	end;

end;

function Easycut:onLeave()
	if self.particleSystems ~= nil then
		if self.showPS then
			self.showPS = false;
			Utils.setEmittingState(self.particleSystems, false);
		end;
	end;
end;

function Easycut:onDeactivate()
	if self.particleSystems ~= nil then
		if self.showPS then
			self.showPS = false;
			Utils.setEmittingState(self.particleSystems, false);
		end;
		for s, plate in pairs(self.rotPlates) do
			plate.rotTempoNow = self.newRotPlates;
		end;
	end;

end;

function Easycut:onDeactivateSounds()
end;
