﻿--
--EasyCutManagement
-- 
--specialization to control the EasyCut from FastCoupler
--
--@author Bluebaby210 www.mod-portal.de
--@date 23.03.2013
--
--


EasyCutManagement = {};

function EasyCutManagement.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(FastCoupler, specializations);
end;

function EasyCutManagement:load(xmlFile)

	self.sidePanelsFoldFC = SpecializationUtil.callSpecializationsFunction("sidePanelsFoldFC");
	self.turnOnFC = SpecializationUtil.callSpecializationsFunction("turnOnFC");
	self.detachEasyCut = SpecializationUtil.callSpecializationsFunction("detachEasyCut");

	self.vehicleAttach = nil;
	self.implementAttached =  nil;
	self.searchImplement = true;

end;

function EasyCutManagement:delete()
end;

function EasyCutManagement:mouseEvent(posX, posY, isDown, isUp, button)
end;

function EasyCutManagement:keyEvent(unicode, sym, modifier, isDown)
end;

function EasyCutManagement:updateTick(dt)
		if self.vehicleAttach ~= nil then
			if self.implementAttached ~= nil then
				if self.implementAttached.isTurnedOn and self:isLowered() then
					local toFast = self:doCheckSpeedLimit() and self.lastSpeed*3600 > 31;
						self.implementAttached.wasToFast = toFast;
				end;
			end;
		end;
end;

function EasyCutManagement:update(dt)

	
	if self.searchImplement then
		if self.vehicleAttach ~= nil then
			for k,v in pairs(self.attachedImplements) do
				if v.object.sidePanelsFoldEC ~= nil then
					self.implementAttached = v.object;
				end;
			end;
			self.searchImplement = false;
		end;
	end;
	
	if self:getIsActiveForInput() and self.implementAttached ~= nil then
		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2) then
			self:sidePanelsFoldFC();
		end;
		if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA) then
			self:turnOnFC();
		end;
		
		if InputBinding.isPressed(InputBinding.DetachEasyCut) then
			if InputBinding.hasEvent(InputBinding.DetachEasyCutTwo) then
				self:detachEasyCut();
			end;
		end;
	end;
end;

function EasyCutManagement:detachImplement()
	self.implementAttached = nil;
end;

function EasyCutManagement:attachImplement()
	self.searchImplement = true;
end;

function EasyCutManagement:draw()
	if self:getIsActive() then
		if self.implementAttached ~= nil then
			if self.implementAttached:getRealAnimationTime("Expand") < self.implementAttached:getAnimationDuration("Expand") and self.implementAttached.AnimDone and not self.implementAttached.isTurnedOn then
				g_currentMission:addHelpButtonText(g_i18n:getText("Expand_pos"), InputBinding.IMPLEMENT_EXTRA2)
			elseif self.implementAttached:getRealAnimationTime("Expand") >= self.implementAttached:getAnimationDuration("Expand") and not self.implementAttached.isTurnedOn then
				g_currentMission:addHelpButtonText(g_i18n:getText("Expand_neg"), InputBinding.IMPLEMENT_EXTRA2)
			end;
			if self.implementAttached.isTurnedOn then
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("turn_off_OBJECT"), self.implementAttached.typeDesc), InputBinding.IMPLEMENT_EXTRA);
				if 	self.implementAttached.wasToFast and self:isLowered() then
					g_currentMission:addWarning(g_i18n:getText("Dont_drive_to_fast") .. "\n" .. string.format(g_i18n:getText("Cruise_control_levelN"), "2"), 0.07+0.022, 0.019+0.029);
				end;
			else
				g_currentMission:addHelpButtonText(string.format(g_i18n:getText("turn_on_OBJECT"), self.implementAttached.typeDesc), InputBinding.IMPLEMENT_EXTRA);
			end;
			g_currentMission:addExtraPrintText(string.format(InputBinding.getKeyNamesOfDigitalAction(InputBinding.DetachEasyCut).." ".."+".." "..InputBinding.getKeyNamesOfDigitalAction(InputBinding.DetachEasyCutTwo).." ".."    ".." "..self.implementAttached.typeDesc.." "..(g_i18n:getText("Detach_Easy_Cut"))));
		end;
	end;


end;

function EasyCutManagement:sidePanelsFoldFC(attacherVehicle)

	if self.vehicleAttach ~= nil then
		for k,v in pairs(self.attachedImplements) do
			if v.object.sidePanelsFoldEC ~= nil then
				v.object:sidePanelsFoldEC();
			end;
		end;
	end;
end;

function EasyCutManagement:detachEasyCut(attacherVehicle)
	if self.vehicleAttach ~= nil then
		for k,v in pairs(self.attachedImplements) do
			if v.object.detachEasyCutEC ~= nil then 
				v.object:detachEasyCutEC();
				self.vehicleAttach:playDetachSound();
			end;
		end;
	end;

end;

function EasyCutManagement:turnOnFC(attacherVehicle)
	if self.vehicleAttach ~= nil then
		for k,v in pairs(self.attachedImplements) do
			if v.object.setIsTurnedOn ~= nil then 
				v.object:setIsTurnedOn(not v.object.isTurnedOn);
			end;
		end;
	end;
end;

function EasyCutManagement:onAttach(attacherVehicle)
	self.vehicleAttach = attacherVehicle;
end;

function EasyCutManagement:onDetach()
	self.vehicleAttach = nil;
	if self.attachedImplements ~= nil then
		for k,v in pairs(self.attachedImplements) do
			if v.object.setIsTurnedOn ~= nil then 
				v.object:setIsTurnedOn(not v.object.isTurnedOn);
			end;
			if v.object.onDeactivate ~= nil then 
				v.object:onDeactivate();
			end;
		end;
	end;

end;
