--
-- EasyCutControl
-- specialization for EasyCut, special for FastCoupler attach, when Fast Coupler from Package is attached
-- EasyCut not selectable and control from FastCoupler. When another FastCoupler attached, then switch to EasyCut allowed.
--
--
--
--@author Bluebaby210 www.mod-portal.de
--@date 23.03.2013
--


EasyCutControl = {};

function EasyCutControl.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Easycut, specializations);
end;

function EasyCutControl:load(xmlFile)

	self.sidePanelsFoldEC = SpecializationUtil.callSpecializationsFunction("sidePanelsFoldEC");
	self.turnOnEC = SpecializationUtil.callSpecializationsFunction("turnOnEC");
	self.detachEasyCutEC = SpecializationUtil.callSpecializationsFunction("detachEasyCutEC");
	self.decideSelectable = SpecializationUtil.callSpecializationsFunction("decideSelectable");

	self.attacherVehicle = nil;
	self.easyCutAttacher = nil;
	self.isSelectable = false;
	
	--
	self.newSchemaOverlay = self.schemaOverlay;

	
	--self:decideSelectable();
	self.firstRun = true;
end;

function EasyCutControl:delete()
end;

function EasyCutControl:mouseEvent(posX, posY, isDown, isUp, button)
end;

function EasyCutControl:keyEvent(unicode, sym, modifier, isDown)
end;

function EasyCutControl:update(dt)
	if self.firstRun then
		if self.attacherVehicle ~= nil then
			for k,v in pairs(self.attacherVehicle.attachedImplements) do
				if self.attacherVehicle.detachEasyCut ~= nil then
					self.isSelectable = false;
					self.schemaOverlay = nil;
				else
					self.isSelectable = true;
				end;
			end;
		end;
		self.firstRun = false;
	end;
	
	
	if self:getIsActive() then
		if self.isTurnedOn and self.AnimDone and self:getRealAnimationTime("Expand") < self:getAnimationDuration("Expand") then
			self:turnOnEC();
		end;
		if self.isSelectable then
			if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2) then
					self:sidePanelsFoldEC();
			end;
		end;
	end;	
end;

function EasyCutControl:draw()
	if self:getIsActive() and self.isSelectable then
		if self:getRealAnimationTime("Expand") < self:getAnimationDuration("Expand") and self.AnimDone and not self.isTurnedOn then
			g_currentMission:addHelpButtonText(g_i18n:getText("Expand_pos"), InputBinding.IMPLEMENT_EXTRA2)
		elseif self:getRealAnimationTime("Expand") >= self:getAnimationDuration("Expand") and not self.isTurnedOn then
			g_currentMission:addHelpButtonText(g_i18n:getText("Expand_neg"), InputBinding.IMPLEMENT_EXTRA2)
		end;
	end;

end;

function EasyCutControl:sidePanelsFoldEC()
		if self.AnimDone and not self.isTurnedOn then
			if self:getRealAnimationTime("Expand") > self:getAnimationDuration("Expand")/2 then
				self:playAnimation("Expand", -1, nil);
			else
				self:playAnimation("Expand", 1, nil);				
			end;
		end;
		if self.isTurnedOn then 
			self:playAnimation("Expand", -1, nil);
			self:setIsTurnedOn(not self.isTurnedOn);
		end;
end;

function EasyCutControl:detachEasyCutEC()
	if not self.isSelectable then
		self.attacherVehicle:detachImplementByObject(self);
	end;
end;

function EasyCutControl:turnOnEC()
	if self.isTurnedOn and self.AnimDone and self:getRealAnimationTime("Expand") < self:getAnimationDuration("Expand") then
		self:playAnimation("Expand", 1, nil);
	end;
end;

function EasyCutControl:onAttach(attacherVehicle)
	self.attacherVehicle = attacherVehicle;
	self.easyCutAttacher = attacherVehicle.attacherVehicle;
	self:decideSelectable();
end;

function EasyCutControl:onDetach()
	self.attacherVehicle = nil;
	self.easyCutAttacher = nil;
	self.schemaOverlay = {};
	self.schemaOverlay = self.newSchemaOverlay;
	self.isSelectable = true;
end;

function EasyCutControl:decideSelectable()
		if self.easyCutAttacher ~= nil then
			for k,v in pairs(self.easyCutAttacher.attachedImplements) do
				if self.attacherVehicle.detachEasyCut ~= nil then
					self.isSelectable = false;
					self.schemaOverlay = nil;
				else
					self.isSelectable = true;
				end;
			end;
		end;
end;