--
-- wheellanes
-- Specialization for wheellanes
--
-- Author		Blacky_BPG
-- Version	v1.0
-- Datum		10.03.13
--
--[[
	Die Fahrgassen bentigen keine extra Eintrge in der Fahrzeug-XML.
	Sie berechnen sich aus dem Radius des Reifens.
	Gras wird plattgefahren (auf kleinste Wachstumstufe zurckgesetzt), andere
	Fruchtsorten welche bereits erntereif sind werden unbrauchbar, solche die
	noch nicht erntereif sind werden es auch nicht mehr werden da quasi die Saat
	durch das drberfahren komplett zerstrt wird.
	
	Auch wenn die Fahrgassen keine XML Eintrge bentigen kann es durchaus welche
	verarbeiten um Einstellungen zu modifizieren. Dabei ist keine der Einstellungen
	zwingend erforderlich so das man nur die eintragen mu welche man eben grad bentigt.
	Nachfolgend die Aufschlsselung:
	
	<wheelOverride isActive="true" idx1="0.8" idx2="0.8" idx3="1.02" idx4="1.02" add1="0|0|0|0" add2="1|0|0|0" add3="2|0|0" add4="3|0|0" />
	
	isActive		-->>		hiermit kann man die Fahrgassen komplett abgeschalten

	idx??		-->>		hiermit kann der verwendete Ausgangswert zur Berechnung der
						Reifenbreite gendert werden, Standard hierbei ist der Radius
						des Reifens. Dieser passt manchmal aber nicht, z.B. bei
						LKW's mit Ballonbereifung (kleiner Radius, groe Breite) oder
						bei Pflegebereifung (groer Radius, kleine Breite) und kann
						eben auf diese Art angepasst werden.

	add??		-->>		hier wird der Index der Zwillingsbereifung eingetragen, die
						Berechnung erfolgt auf die gleiche Weise und mit gleichen
						Parametern wie bei der Standardbereifung. Es wird vom Script
						berprft ob die Zwillingsbreifung sichtbar, also angeschaltet
						ist, und erst dann wird auch fr diese die Fahrspur erstellt.
]]--

wheellanes = {};
wheellanesArea = {};

function wheellanes.prerequisitesPresent(specializations)
    return true;
end;

function wheellanes:load(xmlFile)
	if g_currentMission.extraHudMode == nil then
		g_currentMission.extraHudMode = 0;
	end;
	for _, v in pairs(VehicleTypeUtil.vehicleTypes) do  
		if v ~= nil then
			for i = 1, table.maxn(v.specializations) do
				local vs = v.specializations[i];
				if vs ~= nil and vs == SpecializationUtil.getSpecialization("attachable") then
					if not SpecializationUtil.hasSpecialization(wheellanes, v.specializations) then
						table.insert(v.specializations, SpecializationUtil.getSpecialization("wheellanes"));
					end
				end;
				if vs ~= nil and vs == SpecializationUtil.getSpecialization("motorized") then
					if not SpecializationUtil.hasSpecialization(wheellanes, v.specializations) then
						table.insert(v.specializations, SpecializationUtil.getSpecialization("wheellanes"));
					end
				end;
			end;
		end;
	end;

	self.setwheellanes = SpecializationUtil.callSpecializationsFunction("setwheellanes");

	self.wheelOverrideActive = Utils.getNoNil(getXMLString(xmlFile, "vehicle.wheelOverride#isActive"),true);
	if table.getn(self.wheels) == 0 then
		self.wheelOverrideActive = false;
	end;
	for i=1, table.getn(self.wheels) do
		local key1 = string.format("vehicle.wheelOverride#idx%d",i);
		local key2 = string.format("vehicle.wheelOverride#add%d",i);
		self.wheels[i].override = Utils.getNoNil(getXMLString(xmlFile, key1),self.wheels[i].radius);
		self.wheels[i].add = getXMLString(xmlFile, key2);
	end;
end;

function wheellanes:delete()
end;

function wheellanes:readStream(streamId, connection)
	self.wheelOverrideActive = streamReadBool(streamId);
	for i=1, table.getn(self.wheels) do
		self.wheels[i].override = streamReadFloat32(streamId);
		self.wheels[i].add = streamReadFloat32(streamId);
	end;
	self:setwheellanes(self.wheelOverrideActive,self.wheels, true);
end;

function wheellanes:writeStream(streamId, connection)
	streamWriteBool(streamId, self.wheelOverrideActive)
	for i=1, table.getn(self.wheels) do
		streamWriteFloat32(streamId, self.wheels[i].override);
		streamWriteFloat32(streamId, self.wheels[i].add);
	end;
end;

function wheellanes:mouseEvent(posX, posY, isDown, isUp, button)
end;

function wheellanes:keyEvent(unicode, sym, modifier, isDown)
end;

function wheellanes:update(dt)
	if self.dynamicMountForceLimit == nil then
		self.dynamicMountForceLimit = 0.1;
	end;
end;

function wheellanes:updateTick(dt)
  if self:getIsActive() then
     if self.isClient then
        if self.wheelOverrideActive == true then
		if table.getn(self.wheels) > 0 then
			for i=1, table.getn(self.wheels) do
				if self.wheels[i].hasGroundContact then
					local radius = self.wheels[i].override;
					if radius ~= nil then
						local x,y,z = getWorldTranslation(self.wheels[i].repr);
						x = x - (radius / 4);
						z = z - (radius / 4);
						local x1 = x + (radius / 2);
						local z1 = z;
						local x2 = x;
						local z2 = z + (radius / 2);
						for index,fruit in pairs(g_currentMission.fruits) do
							local fruitDesc = FruitUtil.fruitIndexToDesc[index];
							if fruitDesc.needsSeeding then
								local xx,zz, widthX,widthZ, heightX,heightZ = Utils.getXZWidthAndHeight(g_currentMission.fruits[index].id, x, z, x1, z1, x2, z2);
								local valx,area,totalArea = getDensityParallelogram(g_currentMission.fruits[index].id, x, z, widthX, widthZ, heightX, heightZ, 0, g_currentMission.numFruitStateChannels);
								if valx ~= 0 then
									Utils.cutFruitArea(index, x, z, x1, z1, x2, z2);
									Utils.updateFruitCutShortArea(index, x, z, x1, z1, x2, z2, 0);
									local valy,area,totalArea = getDensityParallelogram(g_currentMission.fruits[index].id, x, z, widthX, widthZ, heightX, heightZ, 0, g_currentMission.numFruitStateChannels);
									local tbl = {};
									tbl.x = x;
									tbl.z = z;
									tbl.radius = radius;
									tbl.index = index;
									tbl.valx = valx;
									tbl.valy = valy;
									table.insert(wheellanesArea, tbl);
									if FruitUtil.FRUITTYPE_GRASS == index then
										setDensityMaskedParallelogram(g_currentMission.fruits[FruitUtil.FRUITTYPE_GRASS].id, xx, zz, widthX, widthZ, heightX, heightZ, 0, 3, g_currentMission.fruits[FruitUtil.FRUITTYPE_GRASS].id, 0, 3, 2);
									elseif valx == valy then
										if valy ~= 18 and valy ~= 9 then
											setDensityMaskedParallelogram(g_currentMission.fruits[index].id, xx, zz, widthX, widthZ, heightX, heightZ, 0,  g_currentMission.numFruitStateChannels, g_currentMission.fruits[index].id, 0, g_currentMission.numFruitStateChannels, 0);
										end;
									end;
								end;
							end;
						end;
						if self.wheels[i].add ~= nil then
							local addWheel = Utils.indexToObject(self.components, self.wheels[i].add);
							if getVisibility(addWheel) == true then
								local x,y,z = getWorldTranslation(addWheel);
								x = x - (radius / 4);
								z = z - (radius / 4);
								local x1 = x + (radius / 2);
								local z1 = z;
								local x2 = x;
								local z2 = z + (radius / 2);
								for index,fruit in pairs(g_currentMission.fruits) do
									local fruitDesc = FruitUtil.fruitIndexToDesc[index];
									if fruitDesc.needsSeeding then
										local xx,zz, widthX,widthZ, heightX,heightZ = Utils.getXZWidthAndHeight(g_currentMission.fruits[index].id, x, z, x1, z1, x2, z2);
										local valx,area,totalArea = getDensityParallelogram(g_currentMission.fruits[index].id, x, z, widthX, widthZ, heightX, heightZ, 0, g_currentMission.numFruitStateChannels);
										if valx ~= 0 then
											Utils.cutFruitArea(index, x, z, x1, z1, x2, z2);
											Utils.updateFruitCutShortArea(index, x, z, x1, z1, x2, z2, 0);
											local valy,area,totalArea = getDensityParallelogram(g_currentMission.fruits[index].id, x, z, widthX, widthZ, heightX, heightZ, 0, g_currentMission.numFruitStateChannels);
											local tbl = {};
											tbl.x = x;
											tbl.z = z;
											tbl.radius = radius;
											tbl.index = index;
											tbl.valx = valx;
											tbl.valy = valy;
											table.insert(wheellanesArea, tbl);
											if FruitUtil.FRUITTYPE_GRASS == index then
												setDensityMaskedParallelogram(g_currentMission.fruits[FruitUtil.FRUITTYPE_GRASS].id, xx, zz, widthX, widthZ, heightX, heightZ, 0, 3, g_currentMission.fruits[FruitUtil.FRUITTYPE_GRASS].id, 0, 3, 2);
											elseif valx == valy then
												if valy ~= 18 and valy ~= 9 then
													setDensityMaskedParallelogram(g_currentMission.fruits[index].id, xx, zz, widthX, widthZ, heightX, heightZ, 0,  g_currentMission.numFruitStateChannels, g_currentMission.fruits[index].id, 0, g_currentMission.numFruitStateChannels, 0);
												end;
											end;
										end;
									end;
								end;
							end;
						end;
					end;
				end;
			end;
		end;
        end;
     end;
  end;
end;

function wheellanes:setwheellanes(active, wheels, noEventSend)
	self.wheelOverrideActive = active;
	for i=1, table.getn(self.wheels) do
		self.wheels[i].override = wheels[i].override;
		self.wheels[i].add = wheels[i].add;
	end;
	wheellanesEvent.sendEvent(self, active, wheels, noEventSend);
end;

function wheellanes:draw()	
end;

wheellanesEvent = {};
wheellanesEvent_mt = Class(wheellanesEvent, Event);

InitEventClass(wheellanesEvent, "wheellanesEvent");

function wheellanesEvent:emptyNew()
    local self = Event:new(wheellanesEvent_mt);
    self.className="wheellanesEvent";
    return self;
end;

function wheellanesEvent:new(vehicle, wheelOverrideActive, wheels)
    local self = wheellanesEvent:emptyNew()
    self.vehicle = vehicle;
    self.wheelOverrideActive = wheelOverrideActive;
	for i=1, table.getn(wheels) do
		self.wheels[i].override = wheels[i].override;
		self.wheels[i].add = wheels[i].add;
	end;
    return self;
end;

function wheellanesEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.wheelOverrideActive = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
	for i=1, table.getn(self.vehicle.wheels) do
		self.wheels[i].override = streamReadFloat32(streamId);
		self.wheels[i].add = streamReadFloat32(streamId);
	end;
    self:run(connection);
end;

function wheellanesEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));
	streamWriteBool(streamId, self.wheelOverrideActive)
	for i=1, table.getn(self.wheels) do
		streamWriteFloat32(streamId, self.wheels[i].override);
		streamWriteFloat32(streamId, self.wheels[i].add);
	end;
end;

function wheellanesEvent:run(connection)
	self.vehicle:setwheellanes(self.wheelOverrideActive, self.wheels, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(wheellanesEvent:new(self.vehicle, self.wheelOverrideActive, self.wheels), nil, connection, self.object);
	end;
end;
function wheellanesEvent.sendEvent(vehicle, active, wheels, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(wheellanesEvent:new(vehicle, active, wheels), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(wheellanesEvent:new(vehicle, active, wheels));
		end;
	end;
end;

