FruitSiloBand = {};

local FruitSiloBand_mt = Class(FruitSiloBand);

print("Load Script: FruitSiloBand = OK");

function FruitSiloBand.onCreate(id)
	g_currentMission:addUpdateable(FruitSiloBand:new(id));
	--print("created FruitSiloBand, id: ", id);
end;

function FruitSiloBand:new(id, customMt)
  
	local instance = {};
	if customMt ~= nil then
		setmetatable(instance, customMt);
	else
		setmetatable(instance, FruitSiloBand_mt);
	end;
	
	local fruitType = getUserAttribute(id, "fruitType");
    if fruitType ~= nil then
		local trigger = SiloTrigger:new(g_server ~= nil, g_client ~= nil);
		local index = g_currentMission:addOnCreateLoadedObject(trigger);
		trigger:load(id);
		trigger:register(true);
		local desc = FruitUtil.fruitTypes[fruitType];
        if desc ~= nil then
			instance.Band = trigger;
		elseif Fillable.fillTypeNameToInt[fruitType] then
			trigger.fillType = Fillable.fillTypeNameToInt[fruitType]
			instance.Band  = trigger;
			if trigger.fillType ~= Fillable.FILLTYPE_MANURE then
				instance.isCowManure = Utils.getNoNil(getUserAttribute(id, "CowManure"), false);
				if instance.isCowManure then
					instance.Ori_update = instance.Band.update;
					function instance.Band:update(dt)
					end;
				end	
			end
			if trigger.fillType == Fillable.FILLTYPE_BARLEY_WINDROW or trigger.fillType == Fillable.FILLTYPE_WHEAT_WINDROW then
				--trigger.fillType = function() if g_currentMission:getSiloAmount(Fillable.FILLTYPE_BARLEY_WINDROW) > 0 then return Fillable.FILLTYPE_BARLEY_WINDROW else return Fillable.FILLTYPE_WHEAT_WINDROW end end;
				instance.Stroh = true;
			end	
		end
		
		instance.IsNotSilo = Utils.getNoNil(getUserAttribute(id, "IsNotSilo"), false);
		if instance.IsNotSilo then
			instance.Ori_update = instance.Band.update
			function instance.Band:update(dt) end;
		end
		
		instance.plane = Utils.indexToObject(id, getUserAttribute(id, "PlaneIndex"));
        if instance.plane ~= nil then
            instance.planeShaderParameterName =  "scollSpeed";
            local planeScrollSpeed = getUserAttribute(instance.plane, "scrollSpeed");
            if planeScrollSpeed ~= nil then
                instance.planeSpeedX, instance.planeSpeedY = Utils.getVectorFromString(planeScrollSpeed);
            end
            if instance.planeSpeedX == nil then
                instance.planeSpeedX = 0;
            end
            if instance.planeSpeedY == nil then
                instance.planeSpeedY = -0.75;
            end
			setVisibility(instance.plane, false);
            setShaderParameter(instance.plane, instance.planeShaderParameterName, 0, 0, 0, 0, false);
		end
	end
	
	return instance;
end;

function FruitSiloBand:delete()
end;

function FruitSiloBand:update(dt)
  
	if g_currentMission:getIsClient() then
		if self.Band.isFilling then
			if self.plane and not self.setShader then
				self.setShader = true
				setVisibility(self.plane, true);
				setShaderParameter(self.plane, self.planeShaderParameterName, self.planeSpeedX, self.planeSpeedY, 0, 0, false);
			end
		elseif self.plane and self.setShader then
			self.setShader = nil
			setVisibility(self.plane, false);
			setShaderParameter(self.plane, self.planeShaderParameterName, 0, 0, 0, 0, false);
		end
	end
	
	if self.isCowManure or self.IsNotSilo then
		if g_currentMission:getIsServer()  then
			local trailer = self.Band.siloTrailer;
			if self.Band.fill >= 4 and trailer ~= nil and not self.Band.fillDone then
				trailer:resetFillLevelIfNeeded(self.Band.fillType);
				local fillLevel = trailer:getFillLevel(self.Band.fillType);
				if self.isCowManure then
					local siloAmount = g_currentMission.husbandries.cow.manureHeap.fillLevel;
					if siloAmount > 0 and trailer:allowFillType(self.Band.fillType, false) then
						local deltaFillLevel = math.min(self.Band.fillLitersPerSecond*0.001*dt, siloAmount);
						trailer:setFillLevel(fillLevel+deltaFillLevel, self.Band.fillType);
						local newFillLevel = trailer:getFillLevel(self.Band.fillType);
					
						if fillLevel ~= newFillLevel then
							local setFillLvl = math.max(siloAmount-(newFillLevel-fillLevel), 0);
							local object = g_currentMission:getNodeObject(g_currentMission.husbandries.cow.manureHeap.triggerId);
							object:setFillLevel(setFillLvl);
							self.Band:startFill();
						else
							self.Band.fillDone = true; -- trailer is full
							self.Band:stopFill();
						end;
			
					else
						self.Band.fillDone = true; -- silo is empty or trailer does not support fill type
						self.Band:stopFill();
					end;
				elseif self.IsNotSilo then
					if trailer:allowFillType(self.Band.fillType, false) then
						local deltaFillLevel = self.Band.fillLitersPerSecond*0.001*dt;
						trailer:setFillLevel(fillLevel+deltaFillLevel, self.Band.fillType);
						local newFillLevel = trailer:getFillLevel(self.Band.fillType);
					
						if fillLevel ~= newFillLevel then
							local delta = math.max((newFillLevel-fillLevel), 0);
							local fillTypeDesc = Fillable.fillTypeIndexToDesc[self.Band.fillType]
							if fillTypeDesc ~= nil then
								local price = delta*fillTypeDesc.pricePerLiter * g_currentMission.missionStats.difficulty;
								g_currentMission:addSharedMoney(-price, "other");
							end
							self.Band:startFill();
						else
							self.Band.fillDone = true; -- trailer is full
							self.Band:stopFill();
						end;

					else
						self.Band.fillDone = true; -- silo is empty or trailer does not support fill type
						self.Band:stopFill();
					end;
				end;
			end;
		end;
	end;

	if self.Stroh and self.Band.siloTrailer == nil then
		if g_currentMission:getSiloAmount(Fillable.FILLTYPE_BARLEY_WINDROW) > 0 then 
			self.Band.fillType = Fillable.FILLTYPE_BARLEY_WINDROW; 
		else
			self.Band.fillType = Fillable.FILLTYPE_WHEAT_WINDROW; 
		end;
	end;
end;
	
	g_onCreateUtil.addOnCreateFunction("FruitSiloBand", FruitSiloBand.onCreate);
	