--
--
--		MapAmpeln_drawPart
--@date: 02/10/2012
--@Author: Bluebaby210		www.mod-portal.com
--@Version: v1.0 		drawParts for traffic Lights, save state traffic lights/flashphoto
--
--darf in jede Map eingebaut werden, MapAmpeln.zip darf nicht neu hochgeladen werden
--
--Keine nderung ohne meine Erlaubnis
--No modification without my permission
--


MapAmpel = {};
MapAmpel.drawPart = {};
function MapAmpel:loadMap(name)

	self.mapName = g_currentMission.missionInfo.mapId
	
	local dir = getUserProfileAppPath() .. "savegame"..g_currentMission.missionInfo.savegameIndex;
	createFolder(dir);
	self.saveXMLFile = dir .. "/MapAmpeln.xml";
	if g_currentMission.missionStats.playTime == 0 then
		self.firstRun = false;
	else
		self.firstRun = true;
	end;

	if (g_server ~= nil and g_server.netIsRunning or g_client ~= nil and g_client.netIsRunning) then
		self.mpRun = false;
	else
		self.mpRun = true;
	end;
end;

function MapAmpel:deleteMap()
	for k=1,table.getn(MapAmpel.drawPart) do 
		MapAmpel.drawPart[k] = nil;
	end;
end;

function MapAmpel:mouseEvent(posX, posY, isDown, isUp, button)
end;

function MapAmpel:keyEvent(unicode, sym, modifier, isDown)
end;

function MapAmpel:update(dt)

		if self.firstRun and self.mpRun then
			MapAmpel:loadFromXML();
			self.firstRun = false;
			self.mpRun = false;
		end;
end;

function MapAmpel:draw()
	for i=1, table.getn(MapAmpel.drawPart) do
		MapAmpel.drawPart[i]:draw();
	end;
end;

local CareerScreenSaveSelectedGame = CareerScreen.saveSelectedGame;
CareerScreen.saveSelectedGame = function(self)
	CareerScreenSaveSelectedGame(self); 
	-- only save when Game is Singleplayer, not save in Multiplayer
	if g_server ~= nil then
		if g_server.netIsRunning == false then
			MapAmpel:saveToXML();
		end;
	end;
end;

function MapAmpel:loadFromXML()

	if fileExists(self.saveXMLFile) then
		local xmlFile = loadXMLFile("MapAmpeln", self.saveXMLFile);
		local a = getXMLString(xmlFile, "MapAmpeln#mapIdentifier");
			if (a == self.mapName) then	
				globaleVariable = Utils.getNoNil(getXMLBool(xmlFile, "MapAmpeln.TrafficLightsTurnedOn"),true);
				globaleTriggerVariable = Utils.getNoNil(getXMLBool(xmlFile, "MapAmpeln.TrafficLightsTurnedOn"),true);
				globaleScreenSave = Utils.getNoNil(getXMLBool(xmlFile, "MapAmpeln.SaveFlashPhoto"),true);
				globalPunishment = Utils.getNoNil(getXMLInt(xmlFile, "MapAmpeln.TotalFlashedInRed"), 0)+1;
				totalpay = Utils.getNoNil(getXMLInt(xmlFile, "MapAmpeln.TotalPay"), 0);
			else
				MapAmpel:saveToXML()
				print("Warning: MapAmpeln.XML can't load ", self.saveXMLFile, ": Name of the current map does not match the match in the savegame.");
			end;
			delete(xmlFile);
	--else
		--MapAmpel:saveToXML()
		--print("Warning: MapAmpeln.XML can't load ", self.saveXMLFile, ": Playing time is not 0, but Savegame XML does not exist.");
	end;


end;

function MapAmpel:saveToXML()

	local existDir = io.open (self.saveXMLFile, "w");	
	if existDir == nil then
		createXMLFile("MapAmpeln", self.saveXMLFile, "saveObject");
	end;
 
	local xmlFile = io.open (self.saveXMLFile, "w");
    if xmlFile ~= nil then
        xmlFile:write('<?xml version="1.0" encoding="utf-8" standalone="no" ?>\n');
		xmlFile:write('\n');
        xmlFile:write('<MapAmpeln  mapIdentifier="'..self.mapName..'">\n');
        xmlFile:write('	<TrafficLightsTurnedOn>'..tostring(globaleVariable)..'</TrafficLightsTurnedOn> \n');
        xmlFile:write('	<SaveFlashPhoto>'..tostring(globaleScreenSave)..'</SaveFlashPhoto> \n');
        xmlFile:write('	<TotalFlashedInRed>'..(globalPunishment - 1)..'</TotalFlashedInRed> \n');
        xmlFile:write('	<TotalPay>'..totalpay..'</TotalPay> \n');
        xmlFile:write("</MapAmpeln>");
        xmlFile:close();
    end;	

end;


addModEventListener(MapAmpel);
