﻿--
--		MapAmpeln_Ampeln2
--@date: 12/12/2012
--@Author: Bluebaby210		www.mod-portal.com
--@Version: v2.0	v1.0 Skript Standart
--					v2.0 RedLights over drive, payment, screenshot, save Screenshot on/off
--				newAttribute = <Attribute name="Punishment_Red_overdrive" type="integer" value="350"/>
--
--darf in jede Map eingebaut werden, MapAmpeln.zip darf nicht neu hochgeladen werden
--
--Keine Änderung ohne meine Erlaubnis
--No modification without my permission
--
--
--

	--print("   Map: TrafficLights Ampeln2 v2.0 by Bluebaby210 loaded!");

function onCreateAmpeln2(self, id)
	--print("created MapAmpelnTest, id: ", id);
	local Ampeln2er = Ampeln2:new(g_server ~= nil, g_client ~= nil);
    local index = g_currentMission:addOnCreateLoadedObject(Ampeln2er);
    Ampeln2er:load(id);
    Ampeln2er:register(true);
	table.insert(MapAmpel.drawPart, Ampeln2er);
end;

Ampeln2 = {}
Ampeln2_directory = g_currentModDirectory;
local Ampeln2_mt = Class(Ampeln2, Object);

function Ampeln2:new(isServer, isClient)
    local self = Object:new(isServer, isClient, Ampeln2_mt);
    self.className = "Ampeln2";
    return self;
end;

function Ampeln2:load(id)

	--Indexe der Lampen laden
	self.red21 = Utils.indexToObject(id, getUserAttribute(id, "TrafficLights2.1_Red"));
	self.red22 = Utils.indexToObject(id, getUserAttribute(id, "TrafficLights2.2_Red"));

	self.orange21 = Utils.indexToObject(id, getUserAttribute(id, "TrafficLights2.1_Orange"));
	self.orange22 = Utils.indexToObject(id, getUserAttribute(id, "TrafficLights2.2_Orange"));

	self.green21 = Utils.indexToObject(id, getUserAttribute(id, "TrafficLights2.1_Green"));
	self.green22 = Utils.indexToObject(id, getUserAttribute(id, "TrafficLights2.2_Green"));
	
	--Lampen gelb und grün ausschalten, sollten im GE nicht sichtbar sein, aber man kennt ja seine User...;-)
	setVisibility(self.red21,true);
	setVisibility(self.red22,true);

	setVisibility(self.orange21,false);
	setVisibility(self.orange22,false);

	setVisibility(self.green21,false);
	setVisibility(self.green22,false);
	
	--Collis Laden und collis hochsetzen sowie g_currentMission.nodeToVehicles setzen.
	self.colli21 = Utils.indexToObject(id, getUserAttribute(id, "TrafficLights2.1_Colli"));
	self.colli22 = Utils.indexToObject(id, getUserAttribute(id, "TrafficLights2.2_Colli"));

	x21, y21, z21 = getTranslation(self.colli21);
	x22, y22, z22 = getTranslation(self.colli22);

	setTranslation(self.colli21,x21,0,z21);
	g_currentMission.nodeToVehicle[self.colli21] = {};
	setTranslation(self.colli22,x22,0,z22);
	g_currentMission.nodeToVehicle[self.colli22] = {};

	self.trigger21 = Utils.indexToObject(id, getUserAttribute(id, "TrafficLights2.1_Trigger"));
	self.trigger22 = Utils.indexToObject(id, getUserAttribute(id, "TrafficLights2.2_Trigger"));

	addTrigger(self.trigger21, "Trigger21Callback", self);
	addTrigger(self.trigger22, "Trigger22Callback", self);
	
	x211, y211, z211 = getTranslation(self.trigger21);
	x222, y222, z222 = getTranslation(self.trigger22);


	self.redTime2 = getUserAttribute(id, "TrafficLights2_redTime");
	self.greenTime2 = getUserAttribute(id, "TrafficLights2_greenTime");

	if self.redTime2 < 5 or self.greenTime2 < 5 then
		self.redTime2 = 5;
		self.greenTime2 = 5;
		print ("Warning: Rotphase bzw Gruenphase sollte mindestens 5 sekunden sein ");
	end;

	self.TimerRed21 = (self.redTime2 * 1000) + 2000;
	self.TimerRed21Backup = self.TimerRed21;
	self.TimerGreen21 = (self.greenTime2 * 1000) + 3000;
	self.TimerGreen21Backup = self.TimerGreen21;
	self.TimerRed22 = (self.redTime2 * 1000) + 2000;
	self.TimerRed22Backup = self.TimerRed22;
	self.TimerGreen22 = (self.greenTime2 * 1000) + 3000;
	self.TimerGreen22Backup = self.TimerGreen22;
	self.red21Started = true;
	self.red22Started = false;
	self.green21Started = false;
	self.green22Started = false;
	
	self.orangeFlashing = true;
	self.orangeLightTimer = 2000;
	self.orangeLightTimerBackup = 2000;

	self.allowsControl = true;
		
	if (g_server ~= nil and g_server.netIsRunning or g_client ~= nil and g_client.netIsRunning) then
		self.allowsControl = false;
	end;
	
	self.MpStarted = 0;

	self.warnHud = Overlay:new("warnHudOverlay", (Ampeln2_directory.."red.png"), 0, 0, 1, 1); --alpha 153 alt
	self.overRedDriveHud = Overlay:new("overRedDriveOverlay", (Ampeln2_directory.."warning.png"), 0.3, 0.5, 0.4, 0.15);
	self.rowdy = Overlay:new("rowdyHudOverlay", (kreuzung3er_directory.."toMuch.png"), 0, 0, 1, 1); --alpha 153 alt

	self.timescreenshot = 0;
	self.showWarningTime21 = 0;
	self.showWarningTime22 = 0;

	self.showWarning = false;  

	self.enterTrigger21 = false;
	self.enterTrigger22 = false;
	self.totalPayCount21 = true;
	self.totalPayCount21 = true;

	self.screenshot = false;
	
	--<Attribute name="Punishment_Red_overdrive" type="integer" value="350"/>
	self.punishment = Utils.getNoNil(getUserAttribute(id, "Punishment_Red_overdrive"),350);  	
	if self.punishment == 0 then
		self.punishment = 350;
	end;
	
	self.payPunishment = 1;
	
	--Screenshot erstellen bzw pfad zum Ordner, thanks modelleicher
	local dir = getUserProfileAppPath();		--thanks modelleicher
	self.path = dir.."screenshots/redOverdrive/";

	local check = getFiles(self.path,"")
	if check == nil or check == 0 then 
		createFolder(dir.."screenshots/redOverdrive");
		--print("screenshots LS 13 Mod: Folder \"screenshots/redOverdrive\" in MyGames was createt");
	end; 

end;

function Ampeln2:delete()
	removeTrigger(self.trigger21);
	removeTrigger(self.trigger22);

end;

function Ampeln2:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Ampeln2:keyEvent(unicode, sym, modifier, isDown)
end;

function Ampeln2:Trigger21Callback(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
	if onEnter then
		if (g_currentMission.controlledVehicle ~= nil and otherId == g_currentMission.controlledVehicle.components[1].node) then
		self.enterTrigger21 = true;
		end;
	end;
end;
function Ampeln2:Trigger22Callback(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
	if onEnter then
		if (g_currentMission.controlledVehicle ~= nil and otherId == g_currentMission.controlledVehicle.components[1].node) then
		self.enterTrigger22 = true;
		end;
	end;
end;

function Ampeln2:update(dt)

	if self.allowsControl then
			if self.red21Started then
				self.TimerRed21 = self.TimerRed21 - dt;
					if self.TimerRed21 <= 2000 and self.TimerRed21 >= 1000 then
						setVisibility(self.orange21,true);
						self.payPunishment = 1;
					elseif self.TimerRed21 <= 1000 and self.TimerRed21 >= 0 then
						setVisibility(self.red21,false);
						setVisibility(self.orange21,false);
						setVisibility(self.green21,true);
						setTranslation(self.colli21,x21,-5,z21);
						setTranslation(self.trigger21,x211,-5,z211);
						self.green21Started = true;
						self.red21Started = false;
						self.TimerRed21 = self.TimerRed21Backup;
					end;
			elseif self.green21Started then
				self.TimerGreen21 = self.TimerGreen21 - dt;
					if self.TimerGreen21 <= 3000 and self.TimerGreen21 >= 2000 then
						setVisibility(self.green21,false);
						setVisibility(self.orange21,true);
					elseif self.TimerGreen21 <= 2000 and self.TimerGreen21 >= 1000 then
						self.red22Started = true;
						setVisibility(self.orange21,false);
						setVisibility(self.red21,true);
						setTranslation(self.colli21,x21,0,z21);
					elseif self.TimerGreen21 <= 0 then
						setTranslation(self.trigger21,x211,0,z211);
						self.enterTrigger21 = false;
						self.totalPayCount21 = true;
						self.showWarningTime21 = 0;
						self.green21Started = false;
						self.TimerGreen21 = self.TimerGreen21Backup;
					end;
			elseif self.red22Started then
				self.TimerRed22 = self.TimerRed22 - dt;
					if self.TimerRed22 <= 2000 and self.TimerRed22 >= 1000 then
						setVisibility(self.orange22,true);
					elseif self.TimerRed22 <= 1000 and self.TimerRed22 >= 0 then
						setVisibility(self.red22,false);
						setVisibility(self.orange22,false);
						setVisibility(self.green22,true);
						setTranslation(self.colli22,x22,-5,z22);
						setTranslation(self.trigger22,x222,-5,z222);
						self.green22Started = true;
						self.red22Started = false;
						self.TimerRed22 = self.TimerRed21Backup;
					end;
			elseif self.green22Started then
				self.TimerGreen22 = self.TimerGreen22 - dt;
					if self.TimerGreen22 <= 3000 and self.TimerGreen22 >= 2000 then
						setVisibility(self.green22,false);
						setVisibility(self.orange22,true);
					elseif self.TimerGreen22 <= 2000 and self.TimerGreen22 >= 1000 then
						setVisibility(self.orange22,false);
						setVisibility(self.red22,true);
						setTranslation(self.colli22,x22,0,z22);
					elseif self.TimerGreen22 <= 0 then
						setTranslation(self.trigger22,x222,0,z222);
						self.enterTrigger22 = false;
						self.totalPayCount22 = true;
						self.showWarningTime22 = 0;
						self.red21Started = true;
						self.green22Started = false;
						self.TimerGreen22 = self.TimerGreen22Backup;
					end;
			end;
	end;
		
	if not self.allowsControl then
		if self.MpStarted < 4000 then
			g_currentMission:addWarning(g_i18n:getText("Ampel_MP_W"));
			self.MpStarted = self.MpStarted + dt;
		end;
		if self.orangeFlashing then
			setVisibility(self.red21,false);
			setVisibility(self.red22,false);
			setVisibility(self.green21,false);
			setVisibility(self.green22,false);
			setTranslation(self.colli21,x21,-5,z21);
			setTranslation(self.colli22,x22,-5,z22);
			setTranslation(self.trigger21,x211,-5,z211);
			setTranslation(self.trigger22,x222,-5,z222);
			self.orangeFlashing = false;
		end;
		if self.orangeFlashing == false then
			if self.orangeLightTimer >= 0 then
				self.orangeLightTimer = self.orangeLightTimer - dt;
				if self.orangeLightTimer <= 2000 and self.orangeLightTimer >= 1000 then
					setVisibility(self.orange21,false);
					setVisibility(self.orange22,false);
				elseif self.orangeLightTimer <= 1000 and self.orangeLightTimer >= 0 then
					setVisibility(self.orange21,true);
					setVisibility(self.orange22,true);
				elseif self.orangeLightTimer <= 0 then
					self.orangeLightTimer = self.orangeLightTimerBackup;
				end;
			end;
		end;

	end;

	if self.screenshot then
		if self.timescreenshot < 200 then
				self.timescreenshot = self.timescreenshot + dt;
			if self.timescreenshot >= 200 then
				if globaleScreenSave then
					local file = getFiles(self.path,"");
					saveScreenshot(self.path.."fsScreen_RedLights_over_drive_"..file..".".."jpg");
				end;
				g_currentMission:addSharedMoney(-(self.punishment * self.payPunishment), "other");
			end;
		end;
	end;

	if self.enterTrigger21 then
		if self.totalPayCount21 then
			totalpay = totalpay + self.punishment;
			self.totalPayCount21 = false;
		end;
		if self.showWarningTime21 < 2000 then
			self.showWarning = true;
			self.showWarningTime21 = self.showWarningTime21 + dt;
				if self.showWarningTime21 >= 2000 then
					self.showWarning = false;
					self.screenshot = false;
					self.timescreenshot = 0;
					self.payPunishment = self.payPunishment + 1;
					globalPunishment = globalPunishment + 1;
				end;
		end;
	end;
	if self.enterTrigger22 then
		if self.totalPayCount22 then
			totalpay = totalpay + self.punishment;
			self.totalPayCount22 = false;
		end;
		if self.showWarningTime22 < 2000 then
			self.showWarning = true;
			self.showWarningTime22 = self.showWarningTime22 + dt;
				if self.showWarningTime22 >= 2000 then
					self.showWarning = false;
					self.screenshot = false;
					self.timescreenshot = 0;
					self.payPunishment = self.payPunishment + 1;
					globalPunishment = globalPunishment + 1;
				end;
		end;
	end;

end;

function Ampeln2:draw()
		if self.showWarning then
			self.warnHud:render();
			self.overRedDriveHud:render();
			setTextBold(true);
			setTextColor(1,1,1,1);
			renderText(0.32, 0.61, 0.022, g_i18n:getText("Over_Red_Drive"));
			renderText(0.32, 0.585, 0.022, g_i18n:getText("Over_Red_Drive1"));
			renderText(0.32, 0.56, 0.022, g_i18n:getText("Over_Red_Drive2"));
			setTextColor(1,0,0,1);
			renderText(0.41, 0.559, 0.022,tostring((self.punishment * self.payPunishment)).."€");
			setTextColor(1,1,1,1);
			renderText(0.46, 0.56, 0.022, g_i18n:getText("Over_Red_Drive3"));
			setTextBold(false);
			renderText(0.32, 0.542, 0.015, g_i18n:getText("Over_Red_Drive6").." "..tostring(globalPunishment));
			renderText(0.32, 0.528, 0.015, g_i18n:getText("Over_Red_Drive7").." "..tostring(totalpay).." ".."€"); 
			self.screenshot = true;
			if globaleScreenSave then
				setTextBold(false);
				renderText(0.32, 0.515, 0.015, g_i18n:getText("Over_Red_Drive4"));
			elseif globaleScreenSave == false then
				setTextBold(false);
				renderText(0.32, 0.515, 0.015, g_i18n:getText("Over_Red_Drive5"));			
			end;
			if globalPunishment == 50 or globalPunishment == 75 or globalPunishment == 100 or globalPunishment == 125 or globalPunishment == 150 then
				self.rowdy:render();
			end;
		end;

end;



