﻿--
--
--		MapAmpeln_AmpelTrigger
--@date: 02/10/2012
--@Author: Bluebaby210		www.mod-portal.com
--@Version: v1.0
--			v2.0 RedLights over drive, payment, screenshot, save Screenshot on/off
--
--darf in jede Map eingebaut werden, MapAmpeln.zip darf nicht neu hochgeladen werden
--
--Keine Änderung ohne meine Erlaubnis
--No modification without my permission

globaleVariable = true;
globaleTriggerVariable = true;
globaleScreenSave = true;
globalPunishment = 1;
totalpay = 0;
	print("   Map: Ampel Trigger v2.0  by Bluebaby210 loaded!");

function onCreateAmpelTrigger(self, id)
	--print("created AmpelTrigger, id: ", id);
	local instance = ampelTrigger:new(g_server ~= nil, g_client ~= nil);
    local index = g_currentMission:addOnCreateLoadedObject(instance);
    instance:load(id);
    instance:register(true);
	table.insert(MapAmpel.drawPart, ampelTrigger);
end;

ampelTrigger = {}
local ampelTrigger_mt = Class(ampelTrigger, Object);

function ampelTrigger:new(isServer, isClient)
    local self = Object:new(isServer, isClient, ampelTrigger_mt);
    self.className = "ampelTrigger";
    return self;
end;

function ampelTrigger:load(id)
	self.id = id;
	self.triggerId = id;
	addTrigger(self.triggerId, "TriggerCallback", self);
	self.playerInTrigger = false;
	self.allowsControl = true;
	
	if (g_server ~= nil and g_server.netIsRunning or g_client ~= nil and g_client.netIsRunning) then
		self.allowsControl = false;
		globaleVariable = false;
		globaleTriggerVariable = false;
	end;
	
	self.MpStarted = 0;

end;

function ampelTrigger:delete()
	removeTrigger(self.triggerId);
end;

function ampelTrigger:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ampelTrigger:keyEvent(unicode, sym, modifier, isDown)
end;

function ampelTrigger:TriggerCallback(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)

	if onEnter then
		if g_currentMission.player ~= nil and otherId == g_currentMission.player.rootNode then
			self.playerInTrigger = true;
		end;
	elseif onLeave then
		if g_currentMission.player ~= nil and otherId == g_currentMission.player.rootNode then
			self.playerInTrigger = false;
		end;
	end;
	
end;

function ampelTrigger:update(dt)

	if self.allowsControl and self.playerInTrigger then

		if globaleTriggerVariable then
			g_currentMission:addWarning(g_i18n:getText("Ampel_aus").." "..InputBinding.getKeyNamesOfDigitalAction(InputBinding.Ampel_change));
			g_currentMission:addHelpButtonText(g_i18n:getText("Ampel_aus"), InputBinding.Ampel_change);
		elseif globaleTriggerVariable == false then
			g_currentMission:addWarning(g_i18n:getText("Ampel_an").." "..InputBinding.getKeyNamesOfDigitalAction(InputBinding.Ampel_change)); 
			g_currentMission:addHelpButtonText(g_i18n:getText("Ampel_an"), InputBinding.Ampel_change); 
		end;

		if globaleScreenSave then
			g_currentMission:addHelpButtonText(g_i18n:getText("Save_Screen_true"), InputBinding.Save_Screen);
		elseif globaleScreenSave == false then
			g_currentMission:addHelpButtonText(g_i18n:getText("Save_Screen_false"), InputBinding.Save_Screen);
		end;

		if InputBinding.hasEvent(InputBinding.Ampel_change) then
			globaleVariable = (not globaleVariable);
			globaleTriggerVariable = (not globaleTriggerVariable);
		end;

		if InputBinding.hasEvent(InputBinding.Save_Screen) then
			globaleScreenSave = (not globaleScreenSave);
		end;
	end;
		

	if self.playerInTrigger and not self.allowsControl then
		g_currentMission:addWarning(g_i18n:getText("Ampel_MP_W"));
		g_currentMission:addExtraPrintText(g_i18n:getText("Ampel_MP"));
	end;

	if not self.allowsControl then
		if self.MpStarted < 4000 then
			g_currentMission:addWarning(g_i18n:getText("Ampel_MP_W"));
			self.MpStarted = self.MpStarted + dt;
		end;
	end;

end;

function ampelTrigger:draw()	
end;