--
-- henly 20 (Ls_uk Modteam)
-- 10.12.2010
--
-- > www.LS-UK.info
--
-- @complement by Amarlich (16.01.2013)
-- @edit by Burner

MHautosteer = {};

function MHautosteer.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Motorized, specializations) and SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function MHautosteer:load(xmlFile)

	self.setAutoSteer = SpecializationUtil.callSpecializationsFunction("setAutoSteer");
    self.maxRotatedTimeSpeed = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.wheels.maxRotatedTimeSpeed#value"), 2)*0.001;
	self.maxRotatedTimeSpeed = 0;
	self.steeringLocked = true;	

	self.autoRotateBackSpeedBackup = self.autoRotateBackSpeed;
end;

function MHautosteer:delete()
end;

function MHautosteer:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	local steeringLocked = getXMLBool(xmlFile, key.."#autoSteer");
	if steeringLocked ~= nil then
		self:setAutoSteer(steeringLocked);
	end;
	return BaseMission.VEHICLE_LOAD_OK;
end;

function MHautosteer:getSaveAttributesAndNodes(nodeIdent)
	local attributes = 'autoSteer="'..tostring(self.steeringLocked)..'"';
	return attributes, nil;
end;
  
function MHautosteer:readStream(streamId, connection)
	local lockedsteer = streamReadBool(streamId);
	self:setAutoSteer(lockedsteer, true);
end;

function MHautosteer:writeStream(streamId, connection)
      streamWriteBool(streamId, self.steeringLocked);
end;

function MHautosteer:mouseEvent(posX, posY, isDown, isUp, button)
end;

function MHautosteer:keyEvent(unicode, sym, modifier, isDown)
end;

function MHautosteer:update(dt)
	if self:getIsActiveForInput(false) then
		if InputBinding.hasEvent(InputBinding.RopaEuroTiger_AUTOSTEER) then
			self:setAutoSteer(not self.steeringLocked);
		end;
	end;
end;

function MHautosteer:updateTick(dt)

	if self.steeringLocked then
		self.autoRotateBackSpeed = self.autoRotateBackSpeedBackup;
		self.maxRotatedTimeSpeed = 2*0.001;
	else
		self.autoRotateBackSpeed = 0;
		self.maxRotatedTimeSpeed = 0;
	end;
end;

function MHautosteer:draw()
end;


function MHautosteer:onEnter()
end;

function MHautosteer:onLeave()
end;

function MHautosteer:setAutoSteer(lockedsteer, noEventSend)
	SetAutoSteerEvent.sendEvent(self, lockedsteer, noEventSend)
	self.steeringLocked = lockedsteer;
end;

SetAutoSteerEvent = {};
SetAutoSteerEvent_mt = Class(SetAutoSteerEvent, Event);
  
InitEventClass(SetAutoSteerEvent, "SetAutoSteerEvent");
  
function SetAutoSteerEvent:emptyNew()
	local self = Event:new(SetAutoSteerEvent_mt);
	self.className="SetAutoSteerEvent";
	return self;
end;
  
function SetAutoSteerEvent:new(object, lockedsteer)
	local self = SetAutoSteerEvent:emptyNew()
	self.object = object;
	self.lockedsteer = lockedsteer;
	return self;
end;
  
function SetAutoSteerEvent:readStream(streamId, connection)
	local id = streamReadInt32(streamId);
	self.lockedsteer = streamReadBool(streamId);
	self.object = networkGetObject(id);
	self:run(connection);
end;
  
function SetAutoSteerEvent:writeStream(streamId, connection)
	streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.lockedsteer);
end;
  
function SetAutoSteerEvent:run(connection)
	if not connection:getIsServer() then
		g_server:broadcastEvent(self, false, connection, self.object);
	end;
	self.object:setAutoSteer(self.lockedsteer, true);
end;
  
function SetAutoSteerEvent.sendEvent(vehicle, lockedsteer, noEventSend)
	if lockedsteer ~= vehicle.steeringLocked then
		if noEventSend == nil or noEventSend == false then
			if g_server ~= nil then
				g_server:broadcastEvent(SetAutoSteerEvent:new(vehicle, lockedsteer), nil, nil, vehicle);
			else
				g_client:getServerConnection():sendEvent(SetAutoSteerEvent:new(vehicle, lockedsteer));
			end;
		end;
	end;
end;