--
-- TipperCover
-- 
--
-- @author  Sven777b
-- @date  21/01/11
--

TipperCover = {};

function TipperCover.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Trailer, specializations);
end;

function TipperCover:load(xmlFile)
	self.setCoverState = SpecializationUtil.callSpecializationsFunction("setCoverState");
	if hasXMLProperty(xmlFile, "vehicle.cover") then
		self.cover = {};
		self.cover.opened = {};
		self.cover.closed = {};
		local i=0;
		while true do
			local ostring = string.format("vehicle.cover.opened(%d)#index",i);
			if not hasXMLProperty(xmlFile,ostring) then break; end;
			local ind = Utils.indexToObject(self.components, getXMLString(xmlFile, ostring));
			table.insert(self.cover.opened, ind);
			i=i+1;
		end;
		i=0;
		while true do
			local cstring = string.format("vehicle.cover.closed(%d)#index",i);
			if not hasXMLProperty(xmlFile,cstring) then break; end;
			local ind = Utils.indexToObject(self.components, getXMLString(xmlFile, cstring));
			table.insert(self.cover.closed, ind);
			i=i+1;
		end;
		self:setCoverState(false,true);
	end;
end;

function TipperCover:delete()
end;

function TipperCover:mouseEvent(posX, posY, isDown, isUp, button)
end;

function TipperCover:keyEvent(unicode, sym, modifier, isDown)
end;

function TipperCover:readStream(streamId, connection)
	local coverState = streamReadBool(streamId);
	self:setCoverState(coverState,true);
end;

function TipperCover:writeStream(streamId, connection)
	streamWriteBool(streamId, self.cover.state);
end;

function TipperCover:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
		local coverState = Utils.getNoNil(getXMLBool(xmlFile,key.."#cover"),false);
		self:setCoverState(coverState);
	end;
    return BaseMission.VEHICLE_LOAD_OK;
end;

function TipperCover:getSaveAttributesAndNodes(nodeIdent)
    local attributes = ' cover="'..tostring(self.cover.state)..'"';
    local node = nil;
    return attributes, node;
end;

function TipperCover:update(dt)
	if self:getIsActiveForInput() then
		if InputBinding.hasEvent(InputBinding.openCover) and self.cover ~= nil then
			self:setCoverState(not self.cover.state);
		end;
	end;
end;

function TipperCover:updateTick(dt)
end;

function TipperCover:setCoverState(coverState,noEventSend)
	if self.cover ~= nil then
		if self.cover.state ~= coverState then
			CoverStateEvent.sendEvent(self, coverState, noEventSend)
			self.cover.state = coverState;
		end;
		for _,ind in ipairs(self.cover.opened) do
			setVisibility(ind, not self.cover.state);
		end;
		for _,ind in ipairs(self.cover.closed) do
			setVisibility(ind, self.cover.state);
		end;
		self.allowFillFromAir = not self.cover.state;
	end;
end;

function TipperCover:draw()
	if self:getIsActiveForInput() then
		g_currentMission:addHelpButtonText(g_i18n:getText("openCover"), InputBinding.openCover);
	end;
end;

-----------------------------------------------------------------------------------------------------

CoverStateEvent = {};
CoverStateEvent_mt = Class(CoverStateEvent, Event);
InitEventClass(CoverStateEvent, "CoverStateEvent");

function CoverStateEvent:emptyNew()
    local self = Event:new(CoverStateEvent_mt);
    self.className="CoverStateEvent";
    return self;
end;

function CoverStateEvent:new(object, coverState)
    local self = CoverStateEvent:emptyNew()
    self.object = object;
	self.coverState = coverState;
    return self;
end;

function CoverStateEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.coverState = streamReadBool(streamId);
    self.object = networkGetObject(id);
    self:run(connection);
end;

function CoverStateEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
	streamWriteBool(streamId, self.coverState);
end;

function CoverStateEvent:run(connection)
	self.object:setCoverState(self.coverState, true);
    if not connection:getIsServer() then
        g_server:broadcastEvent(CoverStateEvent:new(self.object, self.coverState), nil, connection, self.object);
    end;	
end;

function CoverStateEvent.sendEvent(vehicle, coverState, noEventSend)
	if coverState ~= vehicle.cover.state then
		if noEventSend == nil or noEventSend == false then
			if g_server ~= nil then
				g_server:broadcastEvent(CoverStateEvent:new(vehicle, coverState), nil, nil, vehicle);
			else
				g_client:getServerConnection():sendEvent(CoverStateEvent:new(vehicle, coverState));
			end;
		end;
	end;
end;
