SampleModMap = {}

local SampleModMap_mt = Class(SampleModMap, Mission00);


function SampleModMap:new(baseDirectory, customMt)
    local mt = customMt;
    if mt == nil then
        mt = SampleModMap_mt;
    end;
    local self = SampleModMap:superClass():new(baseDirectory, mt);

    return self;
end;

function SampleModMap:delete()
    SampleModMap:superClass().delete(self);
end;

function SampleModMap:load()
    self:startLoadingTask();

    self.environment = Environment:new(Utils.getFilename("$data/sky/sky_day_night.i3d", self.baseDirectory), true, 8, true, true);

    self.helpIconsBase = nil;
    self.collectableGoldCoinsObject = nil;
    self.fieldDefinitionBase = nil;
    self.vehicleShopBase = nil;

    self:loadMap(Utils.getFilename("map/map01.i3d", self.baseDirectory), true, self.loadCareerMap01Finished, self);
end;

function SampleModMap:loadCareerMap01Finished(node, arguments)
    if self.cancelLoading then
        return;
    end
    local startedRepeat = startFrameRepeatMode();
    trcScreenFlip();
    self:loadMapXMLFile(Utils.getFilename("SampleModMap.xml", self.baseDirectory));
    trcScreenFlip(); 
    self:loadTyreTrackSystem(Utils.getFilename("$data/vehicles/shared/tyreTrackMaterialHolder.i3d", self.baseDirectory));       
    trcScreenFlip();
    self:loadI3D("$data/vehicles/particleAnimations/particle_materialHolder.i3d");
    trcScreenFlip();
    self:loadI3D("vehicles/particleAnimations/fertilizer/fertilizer_particleAnimations.i3d"); -- Dnger
    trcScreenFlip();
    self:loadI3D("vehicles/particleAnimations/kalk/kalk_particleAnimations.i3d"); -- Kalk
    trcScreenFlip();
    self:loadI3D("vehicles/particleAnimations/seeds/seeds_particleAnimations.i3d"); -- seeds
    trcScreenFlip();
    self:loadI3D("$data/vehicles/fillPlanes/fillPlane_materialHolder.i3d");
    trcScreenFlip();
    self:loadI3D("vehicles/fillPlanes/fertilizer/fertilizer.i3d"); -- Dngerplane
    trcScreenFlip();
    self:loadI3D("vehicles/fillPlanes/kalk/kalk.i3d"); -- Kalkplane
    trcScreenFlip();
    self:loadI3D("vehicles/fillPlanes/seeds/seeds.i3d"); -- seedsPlane
    trcScreenFlip();
    self.ingameMap:loadMap(Utils.getFilename("pda_map.png", self.baseDirectory), 2048, 2048);

	trcScreenFlip();
    g_statisticView:setMapViewsMap(Utils.getFilename("pda_map.png", self.baseDirectory), 2048, 2048);
	 
	trcScreenFlip();
    SampleModMap:superClass().load(self);

	trcScreenFlip();

    if startedRepeat then
        endFrameRepeatMode();
    end
    self:finishLoadingTask();
end;

function SampleModMap:onStartMission()
    SampleModMap:superClass().onStartMission(self);
end;

function SampleModMap:mouseEvent(posX, posY, isDown, isUp, button)
    SampleModMap:superClass().mouseEvent(self, posX, posY, isDown, isUp, button);
end;

function SampleModMap:keyEvent(unicode, sym, modifier, isDown)
    SampleModMap:superClass().keyEvent(self, unicode, sym, modifier, isDown);
end;

function SampleModMap:update(dt)
    SampleModMap:superClass().update(self, dt);
end;

function SampleModMap:draw()
    SampleModMap:superClass().draw(self);
end;
