-- Author: Hugo94Fr
-- date: 01.02.2015

PlacePlateEvent = {};
PlacePlateEvent_mt = Class(PlacePlateEvent, Event);
InitEventClass(PlacePlateEvent, "PlacePlateEvent");
function PlacePlateEvent:emptyNew()
    local self = Event:new(PlacePlateEvent_mt);
    self.className="PlacePlateEvent";
    return self;
end;

function PlacePlateEvent:new(object, player, plateIndex, x, y, z, rx, ry, rz)
    local self = PlacePlateEvent:emptyNew(); 
    self.object = object; 
	self.player = player;
	self.plateIndex = plateIndex;
	self.x = x;
	self.y = y;
	self.z = z;
	self.rx = rx;
	self.ry = ry;
	self.rz = rz;
    return self;
end;

function PlacePlateEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
    streamWriteInt32(streamId, networkGetObjectId(self.player));
    streamWriteInt8(streamId, self.plateIndex);
	streamWriteFloat32(streamId, self.x);
	streamWriteFloat32(streamId, self.y);
	streamWriteFloat32(streamId, self.z);
	streamWriteFloat32(streamId, self.rx);
	streamWriteFloat32(streamId, self.ry);
	streamWriteFloat32(streamId, self.rz);
end;

function PlacePlateEvent:readStream(streamId, connection)
    self.object = networkGetObject(streamReadInt32(streamId));
    self.player = networkGetObject(streamReadInt32(streamId));
	self.plateIndex = streamReadInt8(streamId);
	self.x = streamReadFloat32(streamId);
	self.y = streamReadFloat32(streamId);
	self.z = streamReadFloat32(streamId);
	self.rx = streamReadFloat32(streamId);
	self.ry = streamReadFloat32(streamId);
	self.rz = streamReadFloat32(streamId);
    self:run(connection);
end;

function PlacePlateEvent:run(connection)
	self.object:placePlate(self.player, self.plateIndex, self.x, self.y, self.z, self.rx, self.ry, self.rz, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(PlacePlateEvent:new(self.object, self.player, self.plateIndex, self.x, self.y, self.z, self.rx, self.ry, self.rz), nil, connection, self.object);
	end; 
end;

function PlacePlateEvent.sendEvent(object, player, plateIndex, x, y, z, rx, ry, rz, noEventSend)
	if noEventSend == nil or noEventSend == false then  
		if g_server ~= nil then   
			g_server:broadcastEvent(PlacePlateEvent:new(object, player, plateIndex, x, y, z, rx, ry, rz), nil, nil, object); 
		else  
			g_client:getServerConnection():sendEvent(PlacePlateEvent:new(object, player, plateIndex, x, y, z, rx, ry, rz)); 
		end;
	end;
end;