-- author: Hugo94Fr
-- date: 01.02.2015

PortableWarningPlateIndex = {};
PortableWarningPlateIndex_mt = Class(PortableWarningPlateIndex, Event);
InitEventClass(PortableWarningPlateIndex, "PortableWarningPlateIndex");
function PortableWarningPlateIndex:emptyNew()
    local self = Event:new(PortableWarningPlateIndex_mt);
    self.className="PortableWarningPlateIndex";
    return self;
end;

function PortableWarningPlateIndex:new(object, player, plateIndex, actionIndex)
    local self = PortableWarningPlateIndex:emptyNew(); 
    self.object = object; 
	self.player = player;
	self.plateIndex = plateIndex;
	self.actionIndex = actionIndex;
    return self;
end;

function PortableWarningPlateIndex:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.object));
    streamWriteInt32(streamId, networkGetObjectId(self.player));
	streamWriteInt8(streamId, self.plateIndex);
	streamWriteInt8(streamId, self.actionIndex);
end;

function PortableWarningPlateIndex:readStream(streamId, connection)
    self.object = networkGetObject(streamReadInt32(streamId));
    self.player = networkGetObject(streamReadInt32(streamId));
	self.plateIndex = streamReadInt8(streamId);
	self.actionIndex = streamReadInt8(streamId);
    self:run(connection);
end;

function PortableWarningPlateIndex:run(connection)
	if actionIndex == 1 then
		self.object:takePlate(self.player, self.plateIndex, true);
	elseif actionIndex == 2 then
		self.object:pickUpPlate(self.player, self.plateIndex, true);
	elseif actionIndex == 3 then
		self.object:putBackPlate(self.player, self.plateIndex, true);
	end;

	if not connection:getIsServer() then
		g_server:broadcastEvent(PortableWarningPlateIndex:new(self.object, self.player, self.plateIndex, self.actionIndex), nil, connection, self.object);
	end; 
end;

function PortableWarningPlateIndex.sendEvent(object, player, plateIndex, actionIndex, noEventSend)
	if noEventSend == nil or noEventSend == false then  
		if g_server ~= nil then   
			g_server:broadcastEvent(PortableWarningPlateIndex:new(object, player, plateIndex, actionIndex), nil, nil, object); 
		else  
			g_client:getServerConnection():sendEvent(PortableWarningPlateIndex:new(object, player, plateIndex, actionIndex)); 
		end;
	end;
end;