-- author: Hugo94Fr
-- date: 01.02.2015

PortableWarningPlate = {};
PortableWarningPlate.stored = 0;
PortableWarningPlate.carried = 1;
PortableWarningPlate.placed = 2;

function PortableWarningPlate.prerequisitesPresent(specializations)
    return true;
end;

function PortableWarningPlate:load(xmlFile)
	self.takePlate = SpecializationUtil.callSpecializationsFunction("takePlate");
	self.placePlate = SpecializationUtil.callSpecializationsFunction("placePlate");
	self.pickUpPlate = SpecializationUtil.callSpecializationsFunction("pickUpPlate");
	self.putBackPlate = SpecializationUtil.callSpecializationsFunction("putBackPlate");
	self.playerDetectTriggerCallback = PortableWarningPlate.playerDetectTriggerCallback;
	
	--self.writeUpdateStream = Utils.overwrittenFunction(Cylindered.writeUpdateStream, CylinderedFixes.writeUpdateStream);

	self.warningPlates = {}
	self.maxGrabDist = 2;
	self.canPutBackPlate = false;
	self.takePlateIndex = nil;
	self.pickUpPlateIndex = nil;
	
	local num = 0;
	while true do
		local key = "vehicle.portableWarningPlates.plate("..tostring(num)..")";
		if not hasXMLProperty(xmlFile, key) then
			break;
		end;
		
		local plate = {}
		plate.nodeId = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index"));
		plate.parentNode = getParent(plate.nodeId);
		plate.loadPos = {getTranslation(plate.nodeId)}
		plate.loadRot = {getRotation(plate.nodeId)}
		plate.currentPos = {0,0,0}
		plate.currentRot = {0,0,0}
		plate.carryPos = {0,-0.75,-2}
		plate.state = PortableWarningPlate.stored;
		plate.collisionMask = getCollisionMask(plate.nodeId);
		plate.centerOfMass = {Utils.getVectorFromString(getXMLString(xmlFile,  key.."#centerOfMass"))}
		setCenterOfMass(plate.nodeId, unpack(plate.centerOfMass));
		setCollisionMask(plate.nodeId, 0);
	
		g_currentMission.nodeToVehicle[plate.nodeId] = self;
	
		num = num + 1;
		table.insert(self.warningPlates, plate)
	end;
end;

function PortableWarningPlate:delete()
	for a=1, table.getn(self.warningPlates) do
		delete(self.warningPlates[a].nodeId);
	end;
end;

function PortableWarningPlate:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
		for a=1, table.getn(self.warningPlates) do
			local plate = self.warningPlates[a];
			local stored = getXMLBool(xmlFile, key..".warningPlate("..tostring(a-1)..")#stored");
			if stored ~= nil and not stored then
				local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, key..".warningPlate("..tostring(a-1)..")#pos"));
				local rx, ry, rz = Utils.getVectorFromString(getXMLString(xmlFile, key..".warningPlate("..tostring(a-1)..")#rot"));
				self:placePlate(nil, a, x, y+0.01, z, rx, ry, rz, true);
			end;
		end;
	end;
	return BaseMission.VEHICLE_LOAD_OK;
end;

function PortableWarningPlate:getSaveAttributesAndNodes(nodeIdent)
	local attributes, nodes = "", "";
	for a=1, table.getn(self.warningPlates) do
		local plate = self.warningPlates[a];
		nodes = nodes .. '	   <warningPlate stored="'..tostring(plate.state == PortableWarningPlate.stored)..'"';
		
		if plate.state ~= PortableWarningPlate.stored then
			local x, y, z = getWorldTranslation(plate.nodeId);
			local xr, yr, zr = getRotation(plate.nodeId);
			nodes = nodes .. ' pos="'..x..' '..y..' '..z..'"';
			nodes = nodes .. ' rot="'..xr..' '..yr..' '..zr..'"';
		end;
		nodes = nodes.."/>";
	end;
	return attributes, nodes;
end;
--[[
function PortableWarningPlate:readStream(streamId, connection)
	for a=1, table.getn(self.warningPlates) do
		local plate = self.warningPlates[a];
		
		if plate.state = 
	end;
end;]]

function PortableWarningPlate:mouseEvent(posX, posY, isDown, isUp, button)
end;

function PortableWarningPlate:keyEvent(unicode, sym, modifier, isDown)
end;

function PortableWarningPlate:update(dt)
	if g_currentMission.player ~= nil and not g_currentMission.missionDynamicInfo.isMultiplayer then
		if self.takePlateIndex ~= nil and g_currentMission.player.warningPlateIndex == nil and not g_currentMission.player.hasHandTool then
			g_currentMission:addHelpButtonText(g_i18n:getText("pickUpPlate"), InputBinding.IMPLEMENT_EXTRA4);
			if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA4) then
				if self.warningPlates[self.takePlateIndex].state == PortableWarningPlate.stored then
					self:takePlate(g_currentMission.player, self.takePlateIndex);
				end;
			end;
		end;
		
		if g_currentMission.player.warningPlateIndex ~= nil and g_currentMission.player.warningPlateVehicle == self then
			g_currentMission:addHelpButtonText(g_i18n:getText("placePlate"), InputBinding.IMPLEMENT_EXTRA2);
			if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA2) then
				local x, y, z = getWorldTranslation(self.warningPlates[g_currentMission.player.warningPlateIndex].nodeId);
				local rx, ry, rz = getWorldRotation(self.warningPlates[g_currentMission.player.warningPlateIndex].nodeId);
				self:placePlate(g_currentMission.player, g_currentMission.player.warningPlateIndex, x, y, z, rx, ry, rz);
			end;
		end;
		
		if self.pickUpPlateIndex ~= nil and not g_currentMission.player.hasHandTool then
			if g_currentMission.player.warningPlateIndex == nil and self.warningPlates[self.pickUpPlateIndex].state == PortableWarningPlate.placed then
				g_currentMission:addHelpButtonText(g_i18n:getText("pickUpPlate"), InputBinding.IMPLEMENT_EXTRA4);
				if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA4) then
					self:pickUpPlate(g_currentMission.player, self.pickUpPlateIndex);
				end;
			end;
		end;
		
		if self.canPutBackPlate and g_currentMission.player.warningPlateIndex ~= nil and g_currentMission.player.warningPlateVehicle == self then
			g_currentMission:addHelpButtonText(g_i18n:getText("putBackPlate"), InputBinding.IMPLEMENT_EXTRA);
			if InputBinding.hasEvent(InputBinding.IMPLEMENT_EXTRA) then
				self:putBackPlate(g_currentMission.player, g_currentMission.player.warningPlateIndex);
			end;
		end;
	end;
end;

function PortableWarningPlate:updateTick(dt)
	local player = g_currentMission.player;
	if player ~= nil and player.isEntered then
		if player.warningPlateIndex == nil then
			for a=1, table.getn(self.warningPlates) do
				local plate = self.warningPlates[a];
				
				local x, y, z = getWorldTranslation(plate.nodeId);
				local px, py, pz = getWorldTranslation(player.rootNode);
				local dist = Utils.vector3Length(x-px, y-py, z-pz);
				
				if dist < self.maxGrabDist then
					if plate.state == PortableWarningPlate.stored then
						self.takePlateIndex = a;
						break;
					else
						self.takePlateIndex = nil;
					end;
					
					if plate.state == PortableWarningPlate.placed then
						self.pickUpPlateIndex = a;
						break;
					else
						self.pickUpPlateIndex = nil;
					end;
				else
					self.pickUpPlateIndex = nil;
					self.takePlateIndex = nil;
				end;
			end;
		else
			local plate = self.warningPlates[g_currentMission.player.warningPlateIndex];
			
			local x, y, z = getWorldTranslation(plate.nodeId);
			local px, py, pz = getWorldTranslation(self.components[1].node);
			local dist = Utils.vector3Length(x-px, y-py, z-pz);
				
			if dist < self.maxGrabDist then
				self.canPutBackPlate = true;
			else
				self.canPutBackPlate = false;
				self.takePlateIndex = nil;
			end;
		end;
	end;
	
	--[[ MP updates
	for a=1, table.getn(self.portableWarningPlates) do
		local plate = self.portableWarningPlates[a];
		local x, y, z = getWorldTranslation(plate.nodeId);
		local rx, ry, rz = getWorldRotation(plate.nodeId);
		if Utils.vector3Length(x-plate.currentPos[1], y-plate.currentPos[2], z-plate.currentPos[3]) then
		
		
		
		end;
		
		plate.currentPos[1] = x;
		plate.currentPos[2] = y;
		plate.currentPos[3] = z;
		plate.currentRot[1] = rx;
		plate.currentRot[2] = ry;
		plate.currentRot[3] = rz;
	end;]]
end;

function PortableWarningPlate:draw()

end;

function PortableWarningPlate:takePlate(player, plateIndex, noEventSend)
	local plate = self.warningPlates[plateIndex];
	if plate.state ~= PortableWarningPlate.stored then
		print("only call method takePlate if plate is stored");
		printCallstack();
	end;
	
	unlink(plate.nodeId);
	link(player.cameraId, plate.nodeId);
	setTranslation(plate.nodeId, unpack(plate.carryPos));
	if self.isServer then
		setRigidBodyType(plate.nodeId, "Kinematic");
	end;
	player.warningPlateIndex = plateIndex;
	player.warningPlateVehicle = self;
	player.hasHandTool = true;
	self.takePlateIndex = nil;
	plate.state = PortableWarningPlate.carried;
	setCollisionMask(plate.nodeId, 0);

	if not noEventSend then
		PortableWarningPlateIndex.sendEvent(self, player, plateIndex, 1, noEventSend);
	end;
end;

function PortableWarningPlate:placePlate(player, plateIndex, x, y, z, rx, ry, rz, noEventSend)
	local plate = self.warningPlates[plateIndex];
	
	unlink(plate.nodeId);
	link(getRootNode(), plate.nodeId);
	setTranslation(plate.nodeId, x, y, z);
	
	if player ~= nil then
		player.warningPlateVehicle = nil;
		player.warningPlateIndex = nil;
		player.hasHandTool = false;
	end;
	
	setRotation(plate.nodeId, rx, ry, rz);
	if self.isServer then
		setRigidBodyType(plate.nodeId, "Dynamic");
	end;
	plate.state = PortableWarningPlate.placed;
	setCollisionMask(plate.nodeId, plate.collisionMask);
	setCenterOfMass(plate.nodeId, unpack(plate.centerOfMass));
	
	if not noEventSend and player ~= nil then
		PlacePlateEvent.sendEvent(self, player, plateIndex, x, y, z, rx, ry, rz, noEventSend);
	end;
end;

function PortableWarningPlate:pickUpPlate(player, plateIndex, noEventSend)
	local plate = self.warningPlates[plateIndex];
	if plate.state ~= PortableWarningPlate.placed then
		print("only call method pickUpPlate if plate is placed");
		printCallstack();
	end;
	
	unlink(plate.nodeId);
	link(player.cameraId, plate.nodeId);
	setTranslation(plate.nodeId, unpack(plate.carryPos));
	player.warningPlateVehicle = self;
	if self.isServer then
		setRigidBodyType(plate.nodeId, "Kinematic");
	end;
	setRotation(plate.nodeId, 0, 0, 0);
	player.warningPlateIndex = plateIndex;
	plate.state = PortableWarningPlate.carried;
	player.hasHandTool = true;
	setCollisionMask(plate.nodeId, 0);

	self.pickUpPlateIndex = nil;
	
	if not noEventSend then
		PortableWarningPlateIndex.sendEvent(self, player, plateIndex, 2, noEventSend);
	end;
end;

function PortableWarningPlate:putBackPlate(player, plateIndex, noEventSend)
	local plate = self.warningPlates[plateIndex];
	if plate.state ~= PortableWarningPlate.carried then
		print("only call method takePlate if plate is carried");
		printCallstack();
	end;
	
	unlink(plate.nodeId);
	link(plate.parentNode, plate.nodeId);
	player.warningPlateVehicle = self;
	setTranslation(plate.nodeId, unpack(plate.loadPos));
	setRotation(plate.nodeId, unpack(plate.loadRot));
	setCollisionMask(plate.nodeId, 0);
	
	player.warningPlateIndex = nil;
	plate.state = PortableWarningPlate.stored;
	player.hasHandTool = false;
	
	if not noEventSend then
		PortableWarningPlateIndex.sendEvent(self, player, plateIndex, 3, noEventSend);
	end;
end;

local oldPlayerDelete2 = Player.delete;
Player.delete = function(self)
	if self.isServer then
		if self.warningPlateVehicle ~= nil then
			self.warningPlateVehicle:putBackPlate(g_currentMission.player, g_currentMission.warningPlateIndex);
		end;
	end;
	oldPlayerDelete2(self);
end;