--[[ add grass squarebales

	Author: 	Ifko[nator]
	Datum: 		13.08.2015
	Version: 	1.0

	History: 	V 1.0 @ 13.08.2015 - intial release.
]]

if not g_modNameToDirectory["addBaleTypes"] then
	local baleFilename = g_currentModDirectory .. "squarebale/baleGrass240.i3d";
	
	--## Double Filename fix for mod balers. Inspired from the 'BaleExtension' Mod by Upsidedown.
	local fixLoadSharedI3DFile = Utils.loadSharedI3DFile;
	function Utils.loadSharedI3DFile(filename, baseDir, ...)
		local pos = string.find(filename, ":/", 1);
		if pos ~= nil then	
			baseDir = "";
		end;
		
		pos = string.find(filename, ":/", 3);
		
		if pos ~= nil then		
			filename = string.sub(filename, pos - 1);
		end;
		
		pos = string.find(filename, "/NewHollandBBG1290/squarebale/");
		if pos ~= nil then
			if not fileExists(Utils.getNoNil(baseDir, "") .. filename) then
				baseDir = "";
				filename = g_modsDirectory .. string.sub(filename, pos + 1);
			end;
		end;
		
		local fixedFilename = fixLoadSharedI3DFile(filename, baseDir, ...);
	
		return fixedFilename;
	end;
	
	if baleFilename ~= nil then
		BaleUtil.registerBaleType(baleFilename, "grass_windrow", 1.2, 0.9, 2.4, nil, false);
	
		local oldBalerLoad = Baler.load;
		Baler.load = function (self, xmlFile)
			oldBalerLoad(self, xmlFile);
			
			if self.fillTypes["grass_windrow"] == nil then
				self.fillTypes["grass_windrow"] = true;
			end;
		end;
	else
		print("[ERROR from the addGrassSquareBales.lua]: The Filename for the new grass squarebale is not exist! The 'addGrassSquareBales' Script is stopped now!");
	end;
else
	print("[INFO from the addGrassSquareBales.lua]: 'addBaleTypes' Mod by Ifko[nator] found! The 'addGrassSquareBales' Script is stopped now!");
end;