--
-- Haecksler
-- This is the specialization for Haeckslers
--
-- M@D Author  Headshot XXL
-- M@D date  31.05.2009
--
-- > Copyright (C) Headshot XXL - www.planet-ls.de < --

Haecksler = {};

print("Claas Jaguar 890 v1.0 loaded");

function Haecksler.prerequisitesPresent(specializations)
    Vehicle.registerJointType("cutter");
    return SpecializationUtil.hasSpecialization(Steerable, specializations);
end;

function Haecksler:load(xmlFile)

    self.startThreshing = SpecializationUtil.callSpecializationsFunction("startThreshing");
    self.stopThreshing = SpecializationUtil.callSpecializationsFunction("stopThreshing");
	self.callbackTrailerTrigger = Haecksler.callbackTrailerTrigger;
	
	self.trailerTrigger = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.trailerTrigger#index"));
	
	if self.trailerTrigger ~= nil then
		addTrigger(self.trailerTrigger, "callbackTrailerTrigger", self);
	end;

    local threshingStartSound = getXMLString(xmlFile, "vehicle.threshingStartSound#file");
    if threshingStartSound ~= nil and threshingStartSound ~= "" then
        threshingStartSound = Utils.getFilename(threshingStartSound, self.baseDirectory); 
        self.threshingStartSound = createSample("threshingStartSound");
        loadSample(self.threshingStartSound, threshingStartSound, false);
        self.threshingStartSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.threshingStartSound#pitchOffset"), 1);
        self.threshingStartSoundPitchScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.threshingStartSound#pitchScale"), 0);
        self.threshingStartSoundPitchMax = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.threshingStartSound#pitchMax"), 2.0);
    end;

    local threshingSound = getXMLString(xmlFile, "vehicle.threshingSound#file");
    if threshingSound ~= nil and threshingSound ~= "" then
        threshingSound = Utils.getFilename(threshingSound, self.baseDirectory); 
        self.threshingSound = createSample("threshingSound");
        loadSample(self.threshingSound, threshingSound, false);
        self.threshingSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.threshingSound#pitchOffset"), 1);
        self.threshingSoundPitchScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.threshingSound#pitchScale"), 0);
        self.threshingSoundPitchMax = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.threshingSound#pitchMax"), 2.0);
    end;

    local threshingStopSound = getXMLString(xmlFile, "vehicle.threshingStopSound#file");
    if threshingStopSound ~= nil and threshingStopSound ~= "" then
        threshingStopSound = Utils.getFilename(threshingStopSound, self.baseDirectory); 
        self.threshingStopSound = createSample("threshingStopSound");
        loadSample(self.threshingStopSound, threshingStopSound, false);
        self.threshingStopSoundPitchOffset = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.threshingStopSound#pitchOffset"), 1);
        self.threshingStopSoundPitchScale = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.threshingStopSound#pitchScale"), 0);
        self.threshingStopSoundPitchMax = Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.threshingStopSound#pitchMax"), 2.0);
    end;

    local count = getXMLInt(xmlFile, "vehicle.rotationParts#count");
	if count ~= nil then
		self.rotationParts = {}
		local rotationPart = self.rotationParts;
		for i=1, count do
			local varName = string.format("rotationPart" .. "%d", i);
			rotationPart[varName] = {};
			local rotationPartname = string.format("vehicle.rotationParts.rotationPart" .. "%d", i);
			rotationPart[varName].index = Utils.indexToObject(self.components, getXMLString(xmlFile, rotationPartname .. "#index"));
			local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, rotationPartname .. "#minRot"));
			rotationPart[varName].minRot = {};
			rotationPart[varName].minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
			rotationPart[varName].minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
			rotationPart[varName].minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));
			local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, rotationPartname .. "#maxRot"));
			rotationPart[varName].maxRot = {};
			rotationPart[varName].maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
			rotationPart[varName].maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
			rotationPart[varName].maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

			rotationPart[varName].rotTime = Utils.getNoNil(getXMLInt(xmlFile, rotationPartname .. "#rotTime"), 2)*1000;	
			rotationPart[varName].touchRotLimit = Utils.getNoNil(getXMLInt(xmlFile, rotationPartname .. "#touchRotLimit"), 1)/1000;	
		end;
		
		local hydraulic = getXMLString(xmlFile, "vehicle.hydraulic#indexHydraulic");
		if hydraulic ~= nil then
			self.hydraulic = {};
			self.hydraulic.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulic#indexHydraulic"));
			self.hydraulic.punch = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulic#indexPunch"));
			self.hydraulic.translationPunch = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulic#translationPunch"));
			local ax, ay, az = getWorldTranslation(self.hydraulic.punch);
			local bx, by, bz = getWorldTranslation(self.hydraulic.translationPunch);
			self.hydraulic.punchDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);

			self.hydraulic2 = {};
			self.hydraulic2.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulic2#indexHydraulic"));
			self.hydraulic2.punch = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulic2#indexPunch"));
			self.hydraulic2.translationPunch = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulic2#translationPunch"));
			local ax, ay, az = getWorldTranslation(self.hydraulic2.punch);
			local bx, by, bz = getWorldTranslation(self.hydraulic2.translationPunch);
			self.hydraulic2.punchDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			
			self.hydraulic3 = {};
			self.hydraulic3.node = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulic3#indexHydraulic"));
			self.hydraulic3.punch = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulic3#indexPunch"));
			self.hydraulic3.translationPunch = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulic3#translationPunch"));
			if self.hydraulic3.punch ~= nil then
				local ax, ay, az = getWorldTranslation(self.hydraulic3.punch);
				local bx, by, bz = getWorldTranslation(self.hydraulic3.translationPunch);
				self.hydraulic3.punchDistance = Utils.vector3Length(ax-bx, ay-by, az-bz);
			end;
			
			self.hydraulicPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulic#hydraulicPoint"));
			self.hydraulicPoint2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulic2#hydraulicPoint2"));
			self.hydraulicPoint3 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.hydraulic3#hydraulicPoint3"));
		end;
		self.pipeParticleSystems = {};
		self.pipeParticleSystemIndex = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.pipeParticleSystem#index"));
		Utils.loadParticleSystem(xmlFile, self.pipeParticleSystems, "vehicle.pipeParticleSystem", self.pipeParticleSystemIndex, false, "$data/vehicles/particleSystems/wheatParticleSystem.i3d", self.baseDirectory);
		self.pipeentladepoint2 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.pipeentladepoint2#index"));
	end;
	
	self.cutterHeightControlPoint = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.cutterHeightControlPoint#index"));
	
	local rollsCount = getXMLInt(xmlFile, "vehicle.rolls#count");
	self.rolls = {}
	if rollsCount ~= nil then		
		for i=1, rollsCount do
			local entry = {};
			local rollPartname = string.format("vehicle.rolls.roll" .. "%d", i);
			entry.index = Utils.indexToObject(self.components, getXMLString(xmlFile, rollPartname .. "#index"));
			entry.speedScale = Utils.getNoNil(getXMLInt(xmlFile, rollPartname .. "#speedScale"), 1)/1000;
			table.insert(self.rolls, entry);
		end;
	end;
	
    self.isThreshingStarted = false;

    self.combineSize = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.combineSize"), 1);
	self.literPerQmScale = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.literPerQmScale"), 2);
	
    self.isThreshing = false;
    self.pipeParticleActivated = false;

    self.threshingScale = 1;

    self.speedDisplayScale = 1.0;
    self.drawFillLevel = true;

    self.attachedCutters = {};
    self.numAttachedCutters = 0;

    self.lastArea = 0;
	
	self.combineTime2 = 0;
	self.combineTime3 = 0;

	self.trailerID = {};
	self.trailerIndex = 1;
	self.currentRotY = 0;
	
	self.cutterHeightControl = false;
	self.isHaecksler = true;
	
	self.pipeRaycastNode = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.pipe#raycastNodeIndex"));

	
end;

function Haecksler:delete()

	Utils.deleteParticleSystem(self.pipeParticleSystems);
    if self.threshingStartSound ~= nil then
        delete(self.threshingStartSound);
    end;
    if self.threshingSound ~= nil then
        delete(self.threshingSound);
    end;
    if self.threshingStopSound ~= nil then
        delete(self.threshingStopSound);
    end;
	
	if self.trailerTrigger ~= nil then
        removeTrigger(self.trailerTrigger);
    end;
	
end;

function Haecksler:mouseEvent(posX, posY, isDown, isUp, button)
end;

function Haecksler:keyEvent(unicode, sym, modifier, isDown)
end;

function Haecksler:update(dt)

    if self:getIsActive() then

        if self.isThreshingStarted then
            if self.playThreshingSound then
                if self:getIsActiveForSound() then
                    if self.threshingSound ~= nil and self.playThreshingSoundTime <= self.time then
                        playSample(self.threshingSound, 0, 1, 0);
                        self.playThreshingSound = false;
                        self.threshingSoundActive = true;
                    end;
                end;
            end;
        end;

        if self:getIsActiveForInput() then

			if InputBinding.hasEvent(InputBinding.ACTIVATE_THRESHING) then
				if self.isThreshing then
					self:stopThreshing();
				else
					self:startThreshing();
				end;
			end;
			if InputBinding.hasEvent(InputBinding.HAECKSLERPIPEAP) then
				self.pipeAP = not self.pipeAP;
            end;

        end;
		
        if self.isThreshing then		
		
			for i=1, table.getn(self.rolls) do				
				rotate(self.rolls[i].index, dt*self.rolls[i].speedScale, 0, 0);
			end;
		
            local lastArea = 0;
            local fruitType = FruitUtil.FRUITTYPE_UNKNOWN;
            for cutter,implement in pairs(self.attachedCutters) do
                if cutter.reelStarted then
                    if cutter.lastArea > 0 then
                        fruitType = cutter.currentFruitType;
                        lastArea = lastArea + cutter.lastArea;
                    end;
                end;
            end;
            self.lastArea = lastArea;
            if lastArea > 0 then
                local fruitDesc = FruitUtil.fruitIndexToDesc[fruitType];
				
                self.combineTime3 = 50;	
				self.combineTime2Start = true;
				
                -- 8000/1200 = 6.66 liter/meter
                -- 8000/1200 / 6 = 1.111 liter/m^2
                -- 8000/1200 / 6 / 2^2 = 0.277777 liter / density pixel (density is 4096^2, on a area of 2048m^2
                local pixelToQm = 2048 / 4096 * 2048 / 4096  / g_currentMission.maxFruitValue; -- 4096px are mapped to 2048m
                local literPerQm = self.literPerQmScale;
                if (fruitType ~= FruitUtil.FRUITTYPE_UNKNOWN) then
                    literPerQm = FruitUtil.fruitIndexToDesc[fruitType].literPerQm * self.literPerQmScale * g_currentMission.missionStats.difficulty;
                end;

                --local literPerPixel = 8000/1200 / 6 / (2*2);
                --literPerPixel = literPerPixel*1.5;
                local qm = lastArea*pixelToQm;
                local deltaLevel = qm*literPerQm*self.threshingScale;				
				
				if table.getn(self.trailerID) == 1 then
					self.trailerID[1]:setFillLevel(self.trailerID[1].fillLevel+deltaLevel, FruitUtil.FRUITTYPE_SILAGE);
				elseif table.getn(self.trailerID) > 1 and self.pipeAP then
					self.trailerID[self.trailerIndex]:setFillLevel(self.trailerID[self.trailerIndex].fillLevel+deltaLevel, FruitUtil.FRUITTYPE_SILAGE);
				end;
				
            end;
		else
			self.lastArea = 0;
        end;

		if self.pipeAP then
		
			if table.getn(self.trailerID) > 0 and not self.waitingForDischarge then
				
				local i = 1;				
				if self.trailerID[1].fillLevel >= self.trailerID[1].capacity and table.getn(self.trailerID) > 1 then
					i = 2;
				end;
				self.trailerIndex = i;
				
				local tx,ty,tz = getWorldTranslation(self.trailerID[i].rootNode);
				if self.trailerID[i].fillNode ~= nil then
					tx,ty,tz = getWorldTranslation(self.trailerID[i].fillNode);
				end;
				--print("trailer", tx, "|", ty, "|", tz)			
				local xw,yw,zw = worldToLocal(self.rootNode, tx, ty, tz);
				--print("node", xw, "|", yw, "|", zw)
				local pex,pey,pez = getTranslation(self.pipeentladepoint2);				
				setTranslation(self.pipeentladepoint2, xw, pey, zw);				
				
				local pxr,pyr,pzr = getRotation(self.rotationParts.rotationPart1.index);				
				local p1yr = math.atan2(-xw,-zw);
				local rotY = pyr;			
				if (p1yr - self.currentRotY)  > 0.001 and pyr < self.rotationParts.rotationPart1.minRot[2] then
					rotY = math.min(pyr + (self.rotationParts.rotationPart1.minRot[2]-self.rotationParts.rotationPart1.maxRot[2])/self.rotationParts.rotationPart1.rotTime * dt, p1yr)
				elseif (p1yr - self.currentRotY) < -0.001 and pyr > self.rotationParts.rotationPart1.maxRot[2]  then
					rotY = math.max(pyr - (self.rotationParts.rotationPart1.minRot[2]-self.rotationParts.rotationPart1.maxRot[2])/self.rotationParts.rotationPart1.rotTime * dt, p1yr)
				end;		
				self.currentRotY = rotY;
				setRotation(self.rotationParts.rotationPart1.index, pxr, rotY, pzr);
				
				local kxr3,kyr3,kzr3 = getRotation(self.rotationParts.rotationPart3.index);
				local kxr4,kyr4,kzr4 = getRotation(self.rotationParts.rotationPart4.index);	
				--local terrainDeltaY = ty - getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, tx, 0, tz);
				local px,py,pz = getWorldTranslation(self.rotationParts.rotationPart3.index);
				local kz =Utils.vector2Length(tx-px, tz-pz);
				--local kz = math.sqrt(xw^2+zw^2);
				
				local kxr = math.atan2(ty-py,kz);
				local kxr3 = kxr / 2;
				--print(kxr);				
				setRotation(self.rotationParts.rotationPart3.index, kxr3, kyr3, kzr3);
				setRotation(self.rotationParts.rotationPart4.index, kxr3, kyr4, kzr4);
			end;
		else
		
			if InputBinding.isPressed(InputBinding.HAECKSLERYPIPERIGHT) then
				local rotationPart = self.rotationParts.rotationPart1;
				local rot = {getRotation(rotationPart.index)};
				local newRot = Utils.getMovedLimitedValues(rot, rotationPart.maxRot, rotationPart.minRot, 3, rotationPart.rotTime, dt, true);
				setRotation(rotationPart.index, unpack(newRot));
				
				setRotation(self.pipeRaycastNode, 0, -newRot[2], 0);
			end;		
			if InputBinding.isPressed(InputBinding.HAECKSLERYPIPELEFT) then
				local rotationPart = self.rotationParts.rotationPart1;
				local rot = {getRotation(rotationPart.index)};
				local newRot = Utils.getMovedLimitedValues(rot, rotationPart.maxRot, rotationPart.minRot, 3, rotationPart.rotTime, dt, false);
				setRotation(rotationPart.index, unpack(newRot));
				
				setRotation(self.pipeRaycastNode, 0, -newRot[2], 0);
			end;  
			if InputBinding.isPressed(InputBinding.HAECKSLERXPIPEDOWN) then
				local rotationPart = self.rotationParts.rotationPart2;
				local rot = {getRotation(rotationPart.index)};
				local newRot = Utils.getMovedLimitedValues(rot, rotationPart.maxRot, rotationPart.minRot, 3, rotationPart.rotTime, dt, true);
				setRotation(rotationPart.index, unpack(newRot));
			end;
			if InputBinding.isPressed(InputBinding.HAECKSLERXPIPEUP) then
				local rotationPart = self.rotationParts.rotationPart2;
				local rot = {getRotation(rotationPart.index)};
				local newRot = Utils.getMovedLimitedValues(rot, rotationPart.maxRot, rotationPart.minRot, 3, rotationPart.rotTime, dt, false);
				setRotation(rotationPart.index, unpack(newRot));
			end;
			self.setPipeRotation = false;
			if InputBinding.isPressed(InputBinding.HAECKSLERKLAPPEDOWN) then
				local rotationPart = self.rotationParts.rotationPart3;
				local rot = {getRotation(rotationPart.index)};
				local newRot = Utils.getMovedLimitedValues(rot, rotationPart.maxRot, rotationPart.minRot, 3, rotationPart.rotTime, dt, true);
				setRotation(rotationPart.index, unpack(newRot));
				setRotation(self.rotationParts.rotationPart4.index, unpack(newRot));
				
				local x,y,z = getTranslation(self.pipeRaycastNode);
				local xt = 1.5 / math.tan(newRot[1]*2) ;
				setTranslation(self.pipeRaycastNode, x, y, xt);
			end;
			if InputBinding.isPressed(InputBinding.HAECKSLERKLAPPEUP) then
				local rotationPart = self.rotationParts.rotationPart3;
				local rot = {getRotation(rotationPart.index)};
				local newRot = Utils.getMovedLimitedValues(rot, rotationPart.maxRot, rotationPart.minRot, 3, rotationPart.rotTime, dt, false);
				setRotation(rotationPart.index, unpack(newRot));
				setRotation(self.rotationParts.rotationPart4.index, unpack(newRot));
				
				local x,y,z = getTranslation(self.pipeRaycastNode);
				local xt = 1.5 / math.tan(newRot[1]*2); 
				setTranslation(self.pipeRaycastNode, x, y, xt);
			end;

		end;

		if self.hydraulic ~= nil then
			local ax, ay, az = getWorldTranslation(self.hydraulic.node);
			local bx, by, bz = getWorldTranslation(self.hydraulicPoint);
			local x, y, z = worldDirectionToLocal(getParent(self.hydraulic.node), bx-ax, by-ay, bz-az);
			setDirection(self.hydraulic.node, x*-1, y*-1, z*-1, 0, 1, 0);
			if self.hydraulic.punch ~= nil then
				local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
				setTranslation(self.hydraulic.punch, 0, 0, (distance-self.hydraulic.punchDistance)*-1);
			end;
		end;
		if self.hydraulic2 ~= nil then
			local ax, ay, az = getWorldTranslation(self.hydraulic2.node);
			local bx, by, bz = getWorldTranslation(self.hydraulicPoint2);
			local x, y, z = worldDirectionToLocal(getParent(self.hydraulic2.node), bx-ax, by-ay, bz-az);
			setDirection(self.hydraulic2.node, x*-1, y*-1, z*-1, 0, 1, 0);
			if self.hydraulic2.punch ~= nil then
				local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
				setTranslation(self.hydraulic2.punch, 0, 0, (distance-self.hydraulic2.punchDistance)*-1);
			end;
		end;
		
		if self.hydraulic3 ~= nil then
			local ax, ay, az = getWorldTranslation(self.hydraulic3.node);
			local bx, by, bz = getWorldTranslation(self.hydraulicPoint3);
			local x, y, z = worldDirectionToLocal(getParent(self.hydraulic3.node), bx-ax, by-ay, bz-az);
			setDirection(self.hydraulic3.node, x*-1, y*-1, z*-1, 0, 1, 0);
			if self.hydraulic3.punch ~= nil then
				local distance = Utils.vector3Length(ax-bx, ay-by, az-bz);
				setTranslation(self.hydraulic3.punch, 0, 0, (distance-self.hydraulic3.punchDistance)*-1);
			end;
		end;
		
        if self.motor ~= nil then
            if self.motor.speedLevel == 1 then
                self.speedDisplayScale = 0.5;
            elseif self.motor.speedLevel == 2 then
                self.speedDisplayScale = 0.6;
            else
                self.speedDisplayScale = 1.0;
            end;
        end;
		
		if self.cutterHeightControl then
			local heightReference = {};
			for cutter,implement in pairs(self.attachedCutters) do
				if cutter.heightReferenceNode ~= nil then
					local x,y,z = getWorldTranslation(cutter.heightReferenceNode);
					heightReference = {x,y,z};
				end;
			end;
			if heightReference[1] ~= nil then
				for k, implement in pairs(self.attachedImplements) do
					local jointDesc = self.attacherJoints[implement.jointDescIndex];
					if jointDesc.rotationNode ~= nil and jointDesc.moveDown then
						local xtt, ytt, ztt = unpack(heightReference);
						local lengthC = ytt - getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, xtt, 0, ztt);
						local lengthA = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, xtt, 0, ztt);
						local xw,yw,zw = worldToLocal(self.rootNode, xtt, lengthA, ztt);
						setTranslation(self.cutterHeightControlPoint, xw, yw, zw)
						local xt, yt, zt =  getTranslation(jointDesc.rotationNode);
						local lengthB = Utils.vector3Length(xw-xt, yw-yt, zw-zt);
						local alpha = math.atan2(lengthC,lengthB)
						local x, y, z = getRotation(jointDesc.rotationNode);
						local rotX = math.min(x + (jointDesc.maxRot[1]-jointDesc.minRot[1])/jointDesc.moveTime * dt, alpha)
						setRotation(jointDesc.rotationNode, rotX,y,z);
					end;
				end;
			end;
		end;
		
    end;

	if self.numAttachedCutters > 0 then
		if self.lastArea == 0 then
			self.combineTime3 = self. combineTime3 - 1;		
		end;
	else
		self.combineTime3 = 0;
	end;
	if self.combineTime2Start then
		self.combineTime2 = self.combineTime2 + 1;
	end;
	if self.combineTime2 > 50 then
		self.pipeParticleActivated = true;
		self.combineTime2 = 51;
	end;
	if self.combineTime3 < 1 then
		self.pipeParticleActivated = false;
		self.combineTime2 = 0;
	end;

    Utils.setEmittingState(self.pipeParticleSystems, self.pipeParticleActivated);
end;

function Haecksler:draw()

    if self.numAttachedCutters > 0 then
        if self.isThreshing then
            g_currentMission:addHelpButtonText(g_i18n:getText("Turn_off_cutter"), InputBinding.ACTIVATE_THRESHING);
        else
            g_currentMission:addHelpButtonText(g_i18n:getText("Turn_on_cutter"), InputBinding.ACTIVATE_THRESHING);
        end;
    end;
	
	g_currentMission:addExtraPrintText("Auswurfrohr und Kruemmer Tasten: " ..InputBinding.getButtonKeyName(InputBinding.HAECKSLERYPIPERIGHT).. "/" ..InputBinding.getButtonKeyName(InputBinding.HAECKSLERYPIPELEFT).. "/" ..InputBinding.getButtonKeyName(InputBinding.HAECKSLERXPIPEDOWN).. "/" ..InputBinding.getButtonKeyName(InputBinding.HAECKSLERXPIPEUP).. "/" ..InputBinding.getButtonKeyName(InputBinding.HAECKSLERKLAPPEDOWN).. "/" ..InputBinding.getButtonKeyName(InputBinding.HAECKSLERKLAPPEUP));
	
	if self.pipeAP then
		g_currentMission:addExtraPrintText("PipeAP Ausschalten: " ..InputBinding.getButtonKeyName(InputBinding.HAECKSLERPIPEAP));
	else
		g_currentMission:addExtraPrintText("Auswurfrohr Hochfahren und PipeAP Einschalten: " ..InputBinding.getButtonKeyName(InputBinding.HAECKSLERPIPEAP));
	end;

end;

function Haecksler:onEnter()
    if self.isThreshingStarted then
        self.playThreshingSound = true;
    end;
end;

function Haecksler:onLeave()
    if self.deactivateOnLeave then
        Haecksler.onDeactivate(self);
    else
        Haecksler.onDeactivateSounds(self)
    end;
end;

function Haecksler:onDeactivate()
    self:stopThreshing();

    Haecksler.onDeactivateSounds(self)
end;

function Haecksler:onDeactivateSounds()
    if self.threshingSound ~= nil then
        stopSample(self.threshingSound);
    end;
end;

function Haecksler:attachImplement(implement)
    local object = implement.object;
    if object.attacherJoint.jointType == Vehicle.JOINTTYPE_CUTTER then
        self.attachedCutters[object] = implement;
        self.numAttachedCutters = self.numAttachedCutters+1;
    end;
end;

function Haecksler:detachImplement(implementIndex)
    local object = self.attachedImplements[implementIndex].object;
    if object.attacherJoint.jointType == Vehicle.JOINTTYPE_CUTTER then
        self.numAttachedCutters = self.numAttachedCutters-1;
        if self.numAttachedCutters == 0 then
            self:stopThreshing()
        end;
        self.attachedCutters[object] = nil;
    end;
end;

function Haecksler:startThreshing()

    if not self.isThreshing then
        if self.numAttachedCutters > 0 then
            self.isThreshing = true;
            for cutter,implement in pairs(self.attachedCutters) do
                local jointDesc = self.attacherJoints[implement.jointDescIndex];
                jointDesc.moveDown = true;				
                cutter:onStartReel();
				self.cutterHeightControl = true;
            end;

            if not self.isThreshingStarted then

                self.isThreshingStarted = true;

                local threshingSoundOffset = 0;
                if self.threshingStartSound ~= nil and self:getIsActiveForSound() then
                    setSamplePitch(self.threshingStartSound, self.threshingStartSoundPitchOffset);
                    playSample(self.threshingStartSound, 1, 1, 0);
                    threshingSoundOffset = getSampleDuration(self.threshingStartSound);
                end;

                self.playThreshingSound = true;
                self.playThreshingSoundTime = self.time+threshingSoundOffset;

            end;
        end;
    end;
end;

function Haecksler:stopThreshing()

    if self.isThreshing then
        self.isThreshingStarted = false;
        self.playThreshingSound = false;

        if self.threshingSound ~= nil then
            stopSample(self.threshingSound);
        end;

        if self.threshingStopSound ~= nil and self.threshingSoundActive and self:getIsActiveForSound() then
            setSamplePitch(self.threshingStopSound, self.threshingStopSoundPitchOffset);
            playSample(self.threshingStopSound, 1, 1, 0);
            self.threshingSoundActive = false;
        end;

        self.isThreshing = false;
        for cutter,implement in pairs(self.attachedCutters) do
            local jointDesc = self.attacherJoints[implement.jointDescIndex];
            jointDesc.moveDown = false;
            cutter:onStopReel();
			self.cutterHeightControl = false;
        end;
    end;

end;

function Haecksler:callbackTrailerTrigger(triggerId, otherId, onEnter, onLeave, onStay, otherShapeId)
	
	if onEnter then		
		if otherId ~= 0 then
			local enterTable = false;
			local vehicle = g_currentMission.objectToTrailer[otherId];
			if vehicle ~= nil then
				for i=0, table.getn(self.trailerID) do
					if self.trailerID[i] ~= vehicle and i < 2 then					
						enterTable = true;
					else
						enterTable = false;
					end;
				end;
				if enterTable then
					table.insert(self.trailerID, vehicle)
				end;
			end;			
		end;
	elseif onLeave then		
		local vehicle = g_currentMission.objectToTrailer[otherId];
		if vehicle ~= nil then
			for i=0, table.getn(self.trailerID) do
				if self.trailerID[i] == vehicle then
					table.remove(self.trailerID, i)
				end;
			end;
		end;
	end;
end;
