SpecializationUtil.registerSpecialization("ThreshingCounter", "ThreshingCounter", g_currentModDirectory.."ThreshingCounter.lua")

ThreshingCounter_Register = {};

function ThreshingCounter_Register:loadMap(name)
	if self.firstRun == nil then
		self.firstRun = false;
		
		print("-- registering threshing counter specialization by Manuel Leithner (SFM-Modding)");
		
		for k, v in pairs(VehicleTypeUtil.vehicleTypes) do
			if v ~= nil then
				local allowInsertion = true;
				for i = 1, table.maxn(v.specializations) do
					local vs = v.specializations[i];
					if vs ~= nil and vs == SpecializationUtil.getSpecialization("combine") then
						local v_name_string = v.name 
						local point_location = string.find(v_name_string, ".", nil, true)
						if point_location ~= nil then
							local _name = string.sub(v_name_string, 1, point_location-1);
							if rawget(SpecializationUtil.specializations, string.format("%s.ThreshingCounter", _name)) ~= nil then
								allowInsertion = false;
								--print(tostring(v.name)..": Specialization ThreshingCounter is present! ThreshingCounter was not inserted!");
							end;
						end;
						if allowInsertion then
							print("adding ThreshingCounter to "..tostring(v.name));
							table.insert(v.specializations, SpecializationUtil.getSpecialization("ThreshingCounter"));
						end;
					end;
				end;
			end;	
		end;
	end;
end;

function ThreshingCounter_Register:deleteMap()
  
end;

function ThreshingCounter_Register:keyEvent(unicode, sym, modifier, isDown)

end;

function ThreshingCounter_Register:mouseEvent(posX, posY, isDown, isUp, button)

end;

function ThreshingCounter_Register:update(dt)
	
end;

function ThreshingCounter_Register:draw()
  
end;

addModEventListener(ThreshingCounter_Register);