--
-- ThreshingCounter
-- Specialization for counting threshed hectars
--
-- @author:  	Manuel Leithner
-- @date:		23/10/12
-- @version:	v2.0
-- @history:	v2.0 - initial implementation
--
-- free for noncommerical-usage
--

ThreshingCounter = {};

local tc_directory = g_currentModDirectory;

function ThreshingCounter.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Combine, specializations);
end;

function ThreshingCounter:load(xmlFile)
	print("-- loading ThreshingCounter specialization");
	
	self.ThreshingCounter = {};
	self.ThreshingCounter.sessionHectars = 0;	
	self.ThreshingCounter.sessionHectarsSent = 0;
	self.ThreshingCounter.workedHectars = 0;
	self.ThreshingCounter.workedHectarsSent = 0;
		
	self.xPos = Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.ThreshingCounter#posX"), 0.59);
	self.yPos = Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.ThreshingCounter#posY"), 0.00);	
	self.tcOverlay = Overlay:new("hudTCOverlay", Utils.getFilename("ThreshingCounter_hud.png", tc_directory), self.xPos, self.yPos, 0.2371, 0.039525);	
	
	self.ThreshingCounter.DirtyFlag = self:getNextDirtyFlag();
end;

function ThreshingCounter:delete()
end;

function ThreshingCounter:readStream(streamId, connection)
	local session = streamReadFloat32(streamId);
	local total = streamReadFloat32(streamId);
		
	self.ThreshingCounter.sessionHectars = session;
	self.ThreshingCounter.workedHectars = total;
	self.ThreshingCounter.sessionHectarsSent = self.ThreshingCounter.sessionHectars;
	self.ThreshingCounter.workedHectarsSent = self.ThreshingCounter.workedHectars;
end;

function ThreshingCounter:writeStream(streamId, connection)	
	streamWriteFloat32(streamId, self.ThreshingCounter.sessionHectars);
	streamWriteFloat32(streamId, self.ThreshingCounter.workedHectars);
end;

function ThreshingCounter:readUpdateStream(streamId, timestamp, connection)
    if connection:getIsServer() then
        if streamReadBool(streamId) then
			self.ThreshingCounter.sessionHectars = streamReadFloat32(streamId);
			self.ThreshingCounter.workedHectars = streamReadFloat32(streamId);
        end;
    end;
end;

function ThreshingCounter:writeUpdateStream(streamId, connection, dirtyMask)
    if not connection:getIsServer() then
        if streamWriteBool(streamId, bitAND(dirtyMask, self.ThreshingCounter.DirtyFlag) ~= 0) then
			streamWriteFloat32(streamId, self.ThreshingCounter.sessionHectarsSent);
			streamWriteFloat32(streamId, self.ThreshingCounter.workedHectarsSent);
        end;
    end;
end;

function ThreshingCounter:mouseEvent(posX, posY, isDown, isUp, button)
end;

function ThreshingCounter:keyEvent(unicode, sym, modifier, isDown)
end;

function ThreshingCounter:update(dt)
end;

function ThreshingCounter:updateTick(dt)
end;

function ThreshingCounter:draw()
	local counterSession = math.floor(self.ThreshingCounter.sessionHectars*100) / 100;
	local counterTotal = math.floor(self.ThreshingCounter.workedHectars*10) / 10;
	local fullSession = math.floor(counterSession);
	local fullTotal = math.floor(counterTotal);
	local deciSession = math.floor((counterSession - fullSession)*100);
	if deciSession < 10 then
		deciSession = "0" .. deciSession;
	end;
	local deciTotal = math.floor((counterTotal - fullTotal)*10);
	
	self.tcOverlay:render();
	setTextAlignment(RenderText.ALIGN_RIGHT);
	setTextBold(true);	
	setTextColor(0, 0, 0, 1);
    renderText(self.xPos+0.083, 			self.yPos + 0.008, 0.022, tostring(fullTotal) .. ",");
	renderText(self.xPos+0.074+0.2371/2, self.yPos + 0.008, 0.022, tostring(fullSession) .. ",");
	setTextColor(1,1,1,1);
	renderText(self.xPos+0.083, 			self.yPos + 0.010, 0.022, tostring(fullTotal) .. ",");
	renderText(self.xPos+0.074+0.2371/2, self.yPos + 0.010, 0.022, tostring(fullSession) .. ",");
	setTextColor(0, 0, 0, 1);
    renderText(self.xPos+0.092, 			  self.yPos + 0.008, 0.023, tostring(deciTotal));
	renderText(self.xPos+0.092 + 0.2371/2, self.yPos + 0.008, 0.023, tostring(deciSession));
	setTextColor(0.95,0,0,1);
	renderText(self.xPos+0.092, 			  self.yPos + 0.010, 0.023, tostring(deciTotal));
	renderText(self.xPos+0.092 + 0.2371/2, self.yPos + 0.010, 0.023, tostring(deciSession));
	setTextColor(0, 0, 0, 1);
    renderText(self.xPos+0.112, 			self.yPos + 0.008, 0.023, "ha");
	renderText(self.xPos+0.112+0.2371/2, self.yPos + 0.008, 0.023, "ha");
	setTextColor(1,1,1,1);
	renderText(self.xPos+0.112, 			self.yPos + 0.010, 0.023, "ha");
	renderText(self.xPos+0.112+0.2371/2, self.yPos + 0.010, 0.023, "ha");
	setTextAlignment(RenderText.ALIGN_LEFT);
end;

function ThreshingCounter:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	local workedHectars = Utils.getNoNil(getXMLFloat(xmlFile, key .. "#workedHectars"), self.ThreshingCounter.workedHectars);
	self.ThreshingCounter.workedHectars = workedHectars;
	
    return BaseMission.VEHICLE_LOAD_OK;
end;

function ThreshingCounter:addCutterArea(cutter, area, realArea, inputFruitType, fruitType)
	if area > 0 and (self.lastCuttersFruitType == FruitUtil.FRUITTYPE_UNKNOWN or self.lastCuttersArea == 0 or self.lastCuttersFruitType == fruitType) then
		local pixelToSqm = g_currentMission:getFruitPixelsToSqm();
		local sqm = realArea*pixelToSqm;
		local ha = sqm/20000;			
		self.ThreshingCounter.sessionHectars = self.ThreshingCounter.sessionHectars + ha;		
		self.ThreshingCounter.workedHectars = self.ThreshingCounter.workedHectars + ha;	
		
		if math.abs(self.ThreshingCounter.sessionHectars - self.ThreshingCounter.sessionHectarsSent) > 0.01 or math.abs(self.ThreshingCounter.workedHectars - self.ThreshingCounter.workedHectarsSent) > 0.01 then
            self:raiseDirtyFlags(self.ThreshingCounter.DirtyFlag);
			self.ThreshingCounter.sessionHectarsSent = self.ThreshingCounter.sessionHectars;
			self.ThreshingCounter.workedHectarsSent = self.ThreshingCounter.workedHectars;
        end;
	end;
end;

Combine.addCutterArea = Utils.appendedFunction(ThreshingCounter.addCutterArea, Combine.addCutterArea);