--
-- strawBunches
-- Specialization for strawBunches
--
-- @author:		RivalBomb
-- @date:		24/12/15
-- @version:	v1.5
-- @history:	v1.0 - initial version
--				v1.5 - added different Fruit support @author Michi77
--
-- free for non-commercial usage

strawBunches = {};

function strawBunches.prerequisitesPresent(specializations)
    return true;
end;

function strawBunches:load(xmlFile)
	self.playerCallback = SpecializationUtil.callSpecializationsFunction("playerCallback");

	self.strawBunch = {};
	
	local i = 0;
	while true do
		local key = string.format("vehicle.strawBunches.strawBunch(%d)",i);
		if not hasXMLProperty(xmlFile, key) then
			break;
		end;

		local node = getXMLString(xmlFile, key.. "#index");
		if node == nil then
			break;
		end;
		local trigger = Utils.indexToObject(self.components, getXMLString(xmlFile, key.. "#trigger"));
		if trigger == nil then
			break;
		end;

		i = i + 1;
		self.strawBunch[i] = {};
		self.strawBunch[i].index = Utils.indexToObject(self.components, node);
		self.strawBunch[i].maxYtrans = Utils.getNoNil(getXMLFloat(xmlFile, key .. "#maxScale"), 1);
		self.strawBunch[i].fruitType = Utils.getNoNil(getXMLString(xmlFile, key .. "#fruitType"), "wheat");
		self.strawBunch[i].resetOnChopperSwitch = Utils.getNoNil(getXMLBool(xmlFile, key .. "#resetOnChopperSwitch"), false);
		self.strawBunch[i].curTrans = 0;
		self.strawBunch[i].trigger = trigger;
		self.strawBunch[i].plIR = false;
		
		addTrigger( trigger, "playerCallback", self );
	end;
end;
function strawBunches:delete()
	for i,j in pairs(self.strawBunch) do
		if j.trigger ~= nil then
			removeTrigger(j.trigger);
		end;
	end;
end;
function strawBunches:readStream(streamId, connection)
	for i=1, #self.strawBunch do
		self.strawBunch[i].curTrans = streamReadFloat32(streamId);
	end;
end;
function strawBunches:writeStream(streamId, connection)
	for i=1, #self.strawBunch do
		streamWriteFloat32(streamId, self.strawBunch[i].curTrans);
	end;
end;
function strawBunches:mouseEvent(posX, posY, isDown, isUp, button)
end;
function strawBunches:keyEvent(unicode, sym, modifier, isDown)
end;
function strawBunches:loadFromAttributesAndNodes(xmlFile, key, resetVehicles)
	if not resetVehicles then
		for i,j in pairs(self.strawBunch) do
			local s = Utils.getNoNil( getXMLFloat(xmlFile, key..string.format("#strawBunchScale%d",i) ), 0);
			self.strawBunch[i].curTrans = s;
		end;
	end;
    return BaseMission.VEHICLE_LOAD_OK;
end;

function strawBunches:getSaveAttributesAndNodes(nodeIdent)
    local attributes = '';
	for i,j in pairs(self.strawBunch) do
		attributes = attributes .. string.format('strawBunchScale%d="%s" ', i, tostring(j.curTrans));
	end;
    return attributes, nil;
end;
function strawBunches:update(dt)
	if self.isCutterSpeedLimitActive == nil then
		if self:getIsActive() then
			for i=1, #self.strawBunch do
				if self.currentFillType ~= Fillable.FILLTYPE_UNKNOWN then
					if FruitUtil.fruitIndexToDesc[self.currentFillType] ~= nil and FruitUtil.fruitIndexToDesc[self.currentFillType].literPerSqm ~= nil then
						if self.strawBunch[i].fruitType == FruitUtil.fruitIndexToDesc[self.currentFillType].name then
							if self.chopperPSenabled or self.strawPSenabled then
								
								if self.strawBunch[i].resetOnChopperSwitch then
									if not self.isStrawEnabled then
										self.strawBunch[i].curTrans = math.min(self.strawBunch[i].curTrans+0.000005, self.strawBunch[i].maxYtrans);
									end;
								else
									self.strawBunch[i].curTrans = math.min(self.strawBunch[i].curTrans+0.000005, self.strawBunch[i].maxYtrans);
								end;
							end;
							if self.isStrawEnabled and self.strawBunch[i].resetOnChopperSwitch then
								self.strawBunch[i].curTrans = 0;
							end;
						end;
					else
						if self.strawBunch[i].fruitType == FruitUtil.fruitIndexToDesc[1].name then
							if self.chopperPSenabled or self.strawPSenabled then
								
								if self.strawBunch[i].resetOnChopperSwitch then
									if not self.isStrawEnabled then
										self.strawBunch[i].curTrans = math.min(self.strawBunch[i].curTrans+0.000005, self.strawBunch[i].maxYtrans);
									end;
								else
									self.strawBunch[i].curTrans = math.min(self.strawBunch[i].curTrans+0.000005, self.strawBunch[i].maxYtrans);
								end;
							end;
							if self.isStrawEnabled and self.strawBunch[i].resetOnChopperSwitch then
								self.strawBunch[i].curTrans = 0;
							end;
						end;
					end;
				end;
			end;
		end;
	else
		if self:getCombine() ~= nil then
			local c = self:getCombine();
			for i=1, #self.strawBunch do
				if c.currentFillType ~= Fillable.FILLTYPE_UNKNOWN then
				--if c.currentFillType ~= Fillable.FILLTYPE_UNKNOWN  and c.currentFillType ~= nil and FruitUtil.fruitIndexToDesc[c.currentFillType] ~= nil and FruitUtil.fruitIndexToDesc[c.currentFillType].name ~= nil then
					if FruitUtil.fruitIndexToDesc[self.currentFillType] ~= nil and FruitUtil.fruitIndexToDesc[self.currentFillType].literPerSqm ~= nil then
						if self.strawBunch[i].fruitType == FruitUtil.fruitIndexToDesc[c.currentFillType].name then
							if c.chopperPSenabled or c.strawPSenabled then
								
								if self.strawBunch[i].resetOnChopperSwitch then
									if not c.isStrawEnabled then
										self.strawBunch[i].curTrans = math.min(self.strawBunch[i].curTrans+0.000005, self.strawBunch[i].maxYtrans);
									end;
								else
									self.strawBunch[i].curTrans = math.min(self.strawBunch[i].curTrans+0.000005, self.strawBunch[i].maxYtrans);
								end;
							end;
							if c.isStrawEnabled and self.strawBunch[i].resetOnChopperSwitch then
								self.strawBunch[i].curTrans = 0;
							end;
						end;
					else
						if self.strawBunch[i].fruitType == FruitUtil.fruitIndexToDesc[1].name then
							if c.chopperPSenabled or c.strawPSenabled then
								
								if self.strawBunch[i].resetOnChopperSwitch then
									if not c.isStrawEnabled then
										self.strawBunch[i].curTrans = math.min(self.strawBunch[i].curTrans+0.000005, self.strawBunch[i].maxYtrans);
									end;
								else
									self.strawBunch[i].curTrans = math.min(self.strawBunch[i].curTrans+0.000005, self.strawBunch[i].maxYtrans);
								end;
							end;
							if c.isStrawEnabled and self.strawBunch[i].resetOnChopperSwitch then
								self.strawBunch[i].curTrans = 0;
							end;
						end;	
					end;
				end;
			end;
		end;
	end;
	local plIR = false;
	local id = 0;
	for i,j in pairs(self.strawBunch) do
		if j.plIR and j.curTrans >= 0.1 then
			id = i;
			plIR = true;
			break;
		end;
	end;
	if plIR then
		g_currentMission:addHelpButtonText( g_i18n:getText("CLEAR_STRAW_BUNCH"), InputBinding.CLEAR_STRAW_BUNCH);
		if InputBinding.hasEvent(InputBinding.CLEAR_STRAW_BUNCH) then
			self.strawBunch[id].curTrans = 0;
		end;
	end;
	for i=1, #self.strawBunch do
		setScale(self.strawBunch[i].index, self.strawBunch[i].curTrans, self.strawBunch[i].curTrans, math.min(self.strawBunch[i].curTrans*2, self.strawBunch[i].maxYtrans));
	end;

end;
function strawBunches:updateTick(dt)
end;
function strawBunches:draw()
end;
function strawBunches:playerCallback(triggerId, otherId, onEnter, onLeave, onStay)
	local id = 0;
	for i,j in pairs(self.strawBunch) do
		if j.trigger == triggerId then
			id = i;
			break;
		end;
	end;
	
	if id ~= 0 then
		if onEnter and g_currentMission.controlPlayer and g_currentMission.player ~= nil and otherId == g_currentMission.player.rootNode then
			self.strawBunch[id].plIR = true;
		elseif onLeave then
			self.strawBunch[id].plIR = false;
		end;
	end
	
end;