--
-- lexion600Guiexion600
-- Specialization for a additional GUI for the Lexion 600
--
-- @author:		Michi77
-- @date:		24/12/15
-- @version:	v1.0
-- @history:	v1.0 - initial version
--
-- free for non-commercial usage
-- note: rafftnixGUI needed!!

lexion600Gui = {};

function lexion600Gui.prerequisitesPresent(specializations)
    return RafftnixGUI ~= nil;
end;

function lexion600Gui:load(xmlFile)
	--TODO: Move positioning to xml..
	self.gui = RafftnixGUI:new(nil, false, false);
	self.addBackupCam = SpecializationUtil.callSpecializationsFunction("addBackupCam");
	self.removeBackupCam = SpecializationUtil.callSpecializationsFunction("removeBackupCam");
	--self.chopperWidthButtonCallback = SpecializationUtil.callSpecializationsFunction("chopperWidthButtonCallback");
	self.doManualUnloadingCallback = SpecializationUtil.callSpecializationsFunction("doManualUnloadCallback");
	self.cameraButton1Callback = SpecializationUtil.callSpecializationsFunction("cameraButton1Callback");
	self.cameraButton2Callback = SpecializationUtil.callSpecializationsFunction("cameraButton2Callback");
	self.cameraButton3Callback = SpecializationUtil.callSpecializationsFunction("cameraButton3Callback");
	self.cameraButton4Callback = SpecializationUtil.callSpecializationsFunction("cameraButton4Callback");
	self.cameraButton5Callback = SpecializationUtil.callSpecializationsFunction("cameraButton5Callback");
	self.cameraNotAvailable = SpecializationUtil.callSpecializationsFunction("cameraNotAvailable");
	self.cameraButtonOffCallback = SpecializationUtil.callSpecializationsFunction("cameraButtonOffCallback");

	local posX = getXMLFloat(xmlFile, "vehicle.lexion600Gui.backGround#x");
	local posY = getXMLFloat(xmlFile, "vehicle.lexion600Gui.backGround#y");
	local width = getXMLFloat(xmlFile, "vehicle.lexion600Gui.backGround#width");
	self.blackBackgroundHeight = getXMLFloat(xmlFile, "vehicle.lexion600Gui.backGround#height");
	local fileName = getXMLString(xmlFile, "vehicle.lexion600Gui.backGround#fileName");
	self.blackBackground = self.gui:createImage(self.gui.baseElement, posX, posY, width, self.blackBackgroundHeight*2, fileName);
	
	self.backupCams = {};
	self.currentCam = 0;
	self.maxBackupCams = 5;
	local posX = getXMLFloat(xmlFile, "vehicle.lexion600Gui.position#x");
	local posY = getXMLFloat(xmlFile, "vehicle.lexion600Gui.position#y");
	local width = getXMLFloat(xmlFile, "vehicle.lexion600Gui.position#width");
	local height = getXMLFloat(xmlFile, "vehicle.lexion600Gui.position#height");
	local i = 0;
	while true do		
		local key = string.format("vehicle.backupCams.cam(%d)#index", i);
		if not hasXMLProperty(xmlFile, key) then
			break;
		end;
		local cam = Utils.indexToObject(self.components, getXMLString(xmlFile, string.format("vehicle.backupCams.cam(%d)#index", i)));
		local camOverlay = self.gui:createRenderOverlay(self.gui.baseElement, posX, posY+height, width, height, cam, 512, 512, getScreenAspectRatio());

		self:addBackupCam(cam, camOverlay);
		i = i + 1;
	end;
	
	
	local fileName1 = getXMLString(xmlFile, "vehicle.lexion600Gui#fileName");
	self.background1Image = self.gui:createImage(self.gui.baseElement, posX, posY, width, height, fileName1);
	self.warningZ = self.gui:createImage(self.gui.baseElement, posX, posY+0.07, 0.03, 0.03, "hud/warningZ.dds");
	self.warningY = self.gui:createImage(self.gui.baseElement, posX, posY+0.07, 0.03, 0.03, "hud/warningY.dds");
	self.warningZ.visibility = false;
	self.warningY.visibility = false;
	--self.chopper = self.gui:createText(self.gui.baseElement, posX+0.115, posY+0.00, width, height, g_i18n:getText("CHOPPER"), 0.01, {1,1,1,1});
	self.gui.chopperWidthButton = self.gui:createImgButton(self.gui.baseElement, posX+0.125, posY+0.01, 0.025, 0.025, "", self.chopperWidthButtonCallback, self);
	self.gui.chopperWidthButton.visibility = false;
	
	self.gui.doManualUnloadButton = self.gui:createImgButton(self.gui.baseElement, posX+0.125, posY+0.085, 0.025, 0.025, "hud/marker_diffuse.dds", self.doManualUnloadingCallback, self);
	self.gui.doManualUnloadButton.visibility = false;
	self.doManualUnloadingText = self.gui:createText(self.gui.baseElement, posX+0.105, posY+0.115, width, height, g_i18n:getText("DO_MANUAL_UNLOAD")..g_i18n:getText("NO"), 0.01, {1,1,1,1});
	--self.chopper.visibility = false;
	self.doManualUnloadingText.visibility = false;
	
	self.cameraNotAvailableText = self.gui:createText(self.gui.baseElement, posX+0.01, posY+height*1.5, width, height, g_i18n:getText("CAM_NOT_AVAILABLE"), 0.015, {1,1,1,1});
	self.cameraNotAvailableText.visibility = false;
	self:cameraButtonOffCallback();
	self.currentCam = 0;
	
	self.gui.cameraButton1 = self.gui:createImgButton(self.gui.baseElement, posX, posY+0.13, 0.025, 0.025, "hud/panel_button1_diffuse.dds", self.cameraButton1Callback, self);
	self.gui.cameraButton2 = self.gui:createImgButton(self.gui.baseElement, posX+1*0.0275, posY+0.13, 0.025, 0.025, "hud/panel_button2_diffuse.dds", self.cameraButton2Callback, self);
	self.gui.cameraButton3 = self.gui:createImgButton(self.gui.baseElement, posX+2*0.0275, posY+0.13, 0.025, 0.025, "hud/panel_button3_diffuse.dds", self.cameraButton3Callback, self);
	self.gui.cameraButton4 = self.gui:createImgButton(self.gui.baseElement, posX+3*0.0275, posY+0.13, 0.025, 0.025, "hud/panel_button4_diffuse.dds", self.cameraButton4Callback, self);
	self.gui.cameraButton5 = self.gui:createImgButton(self.gui.baseElement, posX+4*0.0275, posY+0.13, 0.025, 0.025, "hud/panel_button5_diffuse.dds", self.cameraButton5Callback, self);
	self.gui.cameraButtonOff = self.gui:createImgButton(self.gui.baseElement, posX+5*0.0275, posY+0.13, 0.025, 0.025, "hud/panel_button_onoff_diffuse.dds", self.cameraButtonOffCallback, self);

	self.isOpened = false;
end;

function lexion600Gui:delete()
end;

function lexion600Gui:chopperWidthButtonCallback()
	if self.currentAnim < 2 then
		self.currentAnim = self.currentAnim + 1;
	else
		self.currentAnim = 0;
	end;
	if self.currentAnim == 0 then
		self.chopperAnimName = self.chopperSName;
	elseif self.currentAnim == 1 then
		self.chopperAnimName = self.chopperMName;
	else
		self.chopperAnimName = self.chopperLName;
	end;
	self:changeChopperWidth(self.chopperAnimName);
end;

function lexion600Gui:addBackupCam(cam, overlay)
	if table.getn(self.backupCams) < self.maxBackupCams then
		self.backupCams[#self.backupCams + 1] = {};
		self.backupCams[#self.backupCams].index = cam;
		if overlay ~= nil then
			self.backupCams[#self.backupCams].overlay = overlay;
		else
			local camOverlay = self.gui:createRenderOverlay(self.gui.baseElement, 0.831, 0.185+0.166, 0.166, 0.166, cam, 512, 512, getScreenAspectRatio());
			self.backupCams[#self.backupCams].overlay = camOverlay;
			self.backupCams[#self.backupCams].overlay.visibility = false;
		end;
		--print("Cam Added: "..cam);
	else
		print("cam maximum reached");
	end;
end;

function lexion600Gui:removeBackupCam(cam)
	for i=1, #self.backupCams do
		if self.backupCams[i].index == cam then
			self.backupCams[i].overlay.visibility = false;
			table.remove(self.backupCams, i);
			break;
		end;
	end;
	if self.currentCam == 4 or  self.currentCam == 5 then
		self:cameraNotAvailable(true);
	end;
end;

function lexion600Gui:mouseEvent(posX, posY, isDown, isUp, button)
end;

function lexion600Gui:keyEvent(unicode, sym, modifier, isDown)
	if InputBinding.isPressed(InputBinding.ACTIVATE_CAMERAS) then
		self.isOpened = not self.isOpened;
		self.gui.mouseActive = self.isOpened; 
		self.gui.chopperWidthButton.visibility = not self.gui.chopperWidthButton.visibility;
		self.gui.doManualUnloadButton.visibility = not self.gui.doManualUnloadButton.visibility;
		
		self.doManualUnloadingText.visibility = not self.doManualUnloadingText.visibility;
		self.chopper.visibility = not self.chopper.visibility;
		if self.isOpened == false then
			InputBinding.setShowMouseCursor(false);
		end;
	end;
end;

function lexion600Gui:update(dt)
	if g_currentMission.showHudEnv == false then
		self.gui:close();
	elseif self.isEntered then
		self.gui:open();
	else
		self.gui:close();
	end;
	
	if self.doManualUnloading then
		self.doManualUnloadingText.text = g_i18n:getText("DO_MANUAL_UNLOAD")..g_i18n:getText("YES");
	else
		self.doManualUnloadingText.text = g_i18n:getText("DO_MANUAL_UNLOAD")..g_i18n:getText("NO");
	end;
	--self.chopper.text = g_i18n:getText("CHOPPER")..self.currentl10n;
end;

function lexion600Gui:draw()
	if self.gui.mouseActive then
		g_currentMission:addHelpButtonText(g_i18n:getText("HIDE_MOUSE"), InputBinding.SHOW_MOUSE); 
	else
		g_currentMission:addHelpButtonText(g_i18n:getText("SHOW_MOUSE"), InputBinding.SHOW_MOUSE); 
	end;
	
	local percentage = math.min(self.currentWidth/self.maxLoad, 1);
	if self.isBlocked then
		self.warningZ.visibility = true;
		self.warningY.visibility = false;
	elseif percentage > 0.85 then
		self.warningZ.visibility = false;
		self.warningY.visibility = true;
	else
		self.warningZ.visibility = false;
		self.warningY.visibility = false;
	end;
end;

function lexion600Gui:cameraNotAvailable(state)
	self.cameraNotAvailableText.visibility = state;
end;
function lexion600Gui:doManualUnloadCallback()
	SetDoManualUnloadEvent.sendEvent(self, self.doManualUnloading, noEventSend);
	local s = not self.doManualUnloading;
	self:setdoManualUnload(s, nil)
end;

function lexion600Gui:cameraButton1Callback()
	self:cameraButtonOffCallback();
	if self.backupCams[1] ~= nil then self.backupCams[1].overlay.visibility = true; self.currentCam = 1; else self:cameraNotAvailable(true); end;
	self.blackBackground.height = self.blackBackgroundHeight * 2;
end;
function lexion600Gui:cameraButton2Callback()
	self:cameraButtonOffCallback();
	if self.backupCams[2] ~= nil then self.backupCams[2].overlay.visibility = true; self.currentCam = 2; else self:cameraNotAvailable(true); end;
	self.blackBackground.height = self.blackBackgroundHeight * 2;
end;
function lexion600Gui:cameraButton3Callback()
	self:cameraButtonOffCallback();
	if self.backupCams[3] ~= nil then self.backupCams[3].overlay.visibility = true; self.currentCam = 3; else self:cameraNotAvailable(true); end;
	self.blackBackground.height = self.blackBackgroundHeight * 2;
end;
function lexion600Gui:cameraButton4Callback()
	self:cameraButtonOffCallback();
	if self.backupCams[4] ~= nil then self.backupCams[4].overlay.visibility = true; self.currentCam = 4; else self:cameraNotAvailable(true); end;
	self.blackBackground.height = self.blackBackgroundHeight * 2;
end;
function lexion600Gui:cameraButton5Callback()
	self:cameraButtonOffCallback();
	if self.backupCams[5] ~= nil then self.backupCams[5].overlay.visibility = true; self.currentCam = 5; else self:cameraNotAvailable(true); end;
	self.blackBackground.height = self.blackBackgroundHeight * 2;
end;
function lexion600Gui:cameraButtonOffCallback()
	self:cameraNotAvailable(false);
	if self.backupCams[1] ~= nil then self.backupCams[1].overlay.visibility = false; end;
	if self.backupCams[2] ~= nil then self.backupCams[2].overlay.visibility = false; end;
	if self.backupCams[3] ~= nil then self.backupCams[3].overlay.visibility = false; end;
	if self.backupCams[4] ~= nil then self.backupCams[4].overlay.visibility = false; end;
	if self.backupCams[5] ~= nil then self.backupCams[5].overlay.visibility = false; end;
	self.blackBackground.height = self.blackBackgroundHeight;
	self.currentCam = 0;
end;