--
-- dirtExtension
-- Specialization for dirtExtension
--
-- @author:		Michi77
-- @date:		24/12/15
-- @version:	v1.0
-- @history:	v1.0 - initial version
--
-- free for non-commercial usage

dirtExtension = {};

function dirtExtension.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(Washable, specializations);
end;

function dirtExtension:load(xmlFile)
	self.dirtMeshes = {}; 
	local i = 0; 
	while true do 
		local key = string.format("vehicle.dirtExtension.dirtMesh(%d)", i); 
		local index = Utils.indexToObject(self.components, getXMLString(xmlFile, key.."#index")); 
 		if index==nil then 
			break; 
		end; 
		table.insert(self.dirtMeshes, index); 
		i = i +1; 
	end; 
	
	self.vehicleID = getXMLString(xmlFile, "vehicle.dirtExtension#id"); 
	self.dirtMeshesById = {}; 
	local i2 = 0; 
	while true do 
		local key2 = string.format("vehicle.dirtExtension.dirtMesh(%d)", i2); 
		local id = getXMLString(xmlFile, key2.."#id"); 
		local index = Utils.indexToObject(self.components, getXMLString(xmlFile, key2.."#index")); 
 		if (index==nil) then 
			break; 
		end; 
		if(id ~= self.vehicleID and id ~=nil) then
			setVisibility(index, false);
		end;
		i2 = i2 +1; 
	end; 
end;

function dirtExtension:mouseEvent(posX, posY, isDown, isUp, button)
end;

function dirtExtension:keyEvent(unicode, sym, modifier, isDown)
end;

function dirtExtension:update(dt)
	local amount = self:getDirtAmount();
	for k,v in pairs(self.dirtMeshes ) do 
		if v ~= nil then 
			local x, y, z = getScale(v);
			if (amount<0.1) then
				setScale(v, x, 0.9, 0.9);
			else
				setScale(v, 0.9+(amount/10), 0.9+(amount/10), 0.9+(amount/10));
			end;
		end; 
	end; 
end;

function dirtExtension:updateTick(dt)
end;

function dirtExtension:draw()
end;

function dirtExtension:delete()
end;
