--
-- claasLexion600
-- Specialization for claasLexion600
--
-- @author:		Michi77
-- @date:		24/12/15
-- @version:	v1.0
-- @history:	v1.0 - initial version
--
-- free for non-commercial usage

claasLexion600 = {};

function claasLexion600.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(Combine, specializations);
end;

function claasLexion600:load(xmlFile)
	self.playAddAnimation = SpecializationUtil.callSpecializationsFunction("playAddAnimation");
	self.changeChopperWidth = SpecializationUtil.callSpecializationsFunction("changeChopperWidth");
	self.didAnimation = true;
	self.chopperSName = getXMLString(xmlFile, "vehicle.additionalChopper.chopperS#name");
	self.chopperMName = getXMLString(xmlFile, "vehicle.additionalChopper.chopperM#name");
	self.chopperLName = getXMLString(xmlFile, "vehicle.additionalChopper.chopperL#name");
	self.chopperSL10n = getXMLString(xmlFile, "vehicle.additionalChopper.chopperS#l10n");
	self.chopperML10n = getXMLString(xmlFile, "vehicle.additionalChopper.chopperM#l10n");
	self.chopperLL10n = getXMLString(xmlFile, "vehicle.additionalChopper.chopperL#l10n");
	self.chopperAnimName = self.chopperSName;
	self:changeChopperWidth(self.chopperSName, false);
	self.currentAnim = 0;
	self.currentl10n = self.chopperSL10n;
end;

function claasLexion600:mouseEvent(posX, posY, isDown, isUp, button)
end;

function claasLexion600:keyEvent(unicode, sym, modifier, isDown)
end;

function claasLexion600:update(dt)
	if self.didAnimation ~= self.isStrawEnabled then
		self.didAnimation = self.isStrawEnabled;
		self:playAddAnimation(self.isStrawEnabled, false, false);
	end;
	--[[if self:getIsActive() and self:getIsActiveForInput(false) and not self:hasInputConflictWithSelection() and InputBinding.hasEvent(InputBinding.TOGGLE_CHOPPERWIDTH) then
		if self.currentAnim < 2 then
			self.currentAnim = self.currentAnim + 1;
		else
			self.currentAnim = 0;
		end;
		if self.currentAnim == 0 then
			self.chopperAnimName = self.chopperSName;
		elseif self.currentAnim == 1 then
			self.chopperAnimName = self.chopperMName;
		else
			self.chopperAnimName = self.chopperLName;
		end;
		self:changeChopperWidth(self.chopperAnimName, nil)
		
	end;]]
end;

function claasLexion600:updateTick(dt)
end;

function claasLexion600:draw()
	if self.currentAnim == 0 then
		self.currentl10n = self.chopperSL10n;
	elseif self.currentAnim == 1 then
		self.currentl10n = self.chopperML10n;
	else
		self.currentl10n = self.chopperLL10n;
	end;
end;

function claasLexion600:delete()
end;

function claasLexion600:readStream(streamId, connection)
     local cw = streamReadString(streamId);
	 --self.chopperAnimName = cw;
	 self:changeChopperWidth(cw, true);
end;

function claasLexion600:writeStream(streamId, connection)   
	streamWriteString(streamId, self.chopperAnimName);
end;

function claasLexion600:startThreshing()
	self:playAddAnimation(self.isStrawEnabled, false, false);
end;

function claasLexion600:stopThreshing()
	self:playAddAnimation(self.isStrawEnabled, false, false);
end;

function claasLexion600:changeChopperWidth(name, noEventSend)
	self.chopperAnimName = name;
	self:playAddAnimation(self.isStrawEnabled, false, false);
	SetChopperWidth.sendEvent(self, name, noEventSend);
end;

function claasLexion600:playAddAnimation(isStrawEnabled, noEventSend, force) 
    if self:getIsActive() then 
        if self:getIsTurnedOn() then 
			if self.playAnimation ~= nil and self.chopperAnimName ~= nil then 
				local dir = -1; 
				--print("1");
				self:stopAnimation(self.chopperSName, true);
				self:stopAnimation(self.chopperMName, true);
				self:stopAnimation(self.chopperLName, true);
				self:playAnimation(self.chopperAnimName, 1, nil, true); 
			end;
		else
			--print("2");
			self:stopAnimation(self.chopperSName, true);
			self:stopAnimation(self.chopperMName, true);
			self:stopAnimation(self.chopperLName, true);
			self:stopAnimation(self.chopperAnimName, true);
		end;
	else
		--print("3");
		self:stopAnimation(self.chopperSName, true);
		self:stopAnimation(self.chopperMName, true);
		self:stopAnimation(self.chopperLName, true);
		self:stopAnimation(self.chopperAnimName, true);
	end;
end;