SetBlockedEvent = {};
SetBlockedEvent_mt = Class(SetBlockedEvent, Event);

InitEventClass(SetBlockedEvent, "SetBlockedEvent");

function SetBlockedEvent:emptyNew()
    local self = Event:new(SetBlockedEvent_mt);
    self.className="SetBlockedEvent";
    return self;
end;

function SetBlockedEvent:new(vehicle, state)
    local self = SetBlockedEvent:emptyNew()
    self.vehicle = vehicle;
	self.state = state;
	return self;
end;

function SetBlockedEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.state = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function SetBlockedEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
	streamWriteBool(streamId, self.state);
end;

function SetBlockedEvent:run(connection)
	self.vehicle:setIsBlocked(self.state, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(SetBlockedEvent:new(self.vehicle, self.state), nil, connection, self.object);
	end;
end;

function SetBlockedEvent.sendEvent(vehicle, state, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(SetBlockedEvent:new(vehicle, state), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(SetBlockedEvent:new(vehicle, state));
		end;
	end;
end;