DoManualUnloadEvent = {};
DoManualUnloadEvent_mt = Class(DoManualUnloadEvent, Event);

InitEventClass(DoManualUnloadEvent, "DoManualUnloadEvent");

function DoManualUnloadEvent:emptyNew()
    local self = Event:new(DoManualUnloadEvent_mt);
    self.className="DoManualUnloadEvent";
    return self;
end;

function DoManualUnloadEvent:new(vehicle, state)
    local self = DoManualUnloadEvent:emptyNew()
    self.vehicle = vehicle;
	self.state = state;
	return self;
end;

function DoManualUnloadEvent:readStream(streamId, connection)
    local id = streamReadInt32(streamId);
	self.state = streamReadBool(streamId);
    self.vehicle = networkGetObject(id);
    self:run(connection);
end;

function DoManualUnloadEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, networkGetObjectId(self.vehicle));	
	streamWriteBool(streamId, self.state);
end;

function DoManualUnloadEvent:run(connection)
	self.vehicle:setdoManualUnload(self.state, true);
	if not connection:getIsServer() then
		g_server:broadcastEvent(DoManualUnloadEvent:new(self.vehicle, self.state), nil, connection, self.object);
	end;
end;

function DoManualUnloadEvent.sendEvent(vehicle, state, noEventSend)
	if noEventSend == nil or noEventSend == false then
		if g_server ~= nil then
			g_server:broadcastEvent(DoManualUnloadEvent:new(vehicle, state), nil, nil, vehicle);
		else
			g_client:getServerConnection():sendEvent(DoManualUnloadEvent:new(vehicle, state));
		end;
	end;
end;