--
-- AdditionalBackupCam
-- Specialization for AdditionalBackupCam
--
-- SFM-Modding
-- @author  Manuel Leithner
-- @date:		03/03/11
-- @version:	v1.2
-- @history:	v1.0 - initial implementation
--
-- @author: 	Michi77
-- @history: 	v1.2 - added support for rafftnixGui
-- @date: 		24/12/15
--
-- free for noncommerical-usage
--

AdditionalBackupCam = {};

function AdditionalBackupCam.prerequisitesPresent(specializations)
    return SpecializationUtil.hasSpecialization(Attachable, specializations);
end;

function AdditionalBackupCam:load(xmlFile)
	self.additionalCams = {};
	self.addBackupCam = SpecializationUtil.callSpecializationsFunction("addBackupCam");
	local i = 0;
	
	while true do		
		local key = string.format("vehicle.backupCams.cam(%d)#index", i);
		if not hasXMLProperty(xmlFile, key) then
			break;
		end;
		local cam = Utils.indexToObject(self.components, getXMLString(xmlFile, string.format("vehicle.backupCams.cam(%d)#index", i)));
		local camOverlay = nil;
		self:addBackupCam(cam);
		i = i + 1;
	end;
	
	self.camAttacherBackup = nil;
end;

function AdditionalBackupCam:delete()
end;

function AdditionalBackupCam:mouseEvent(posX, posY, isDown, isUp, button)
end;

function AdditionalBackupCam:keyEvent(unicode, sym, modifier, isDown)
end;

function AdditionalBackupCam:update(dt)
end;

function AdditionalBackupCam:draw()
end;

function AdditionalBackupCam:addBackupCam(cam)
	self.additionalCams[#self.additionalCams + 1] = {};
	self.additionalCams[#self.additionalCams].index = cam;
	self.additionalCams[#self.additionalCams].overlay = nil;
end;

function AdditionalBackupCam:onAttach(attacherVehicle)
	self.camAttacherBackup = attacherVehicle;
	if attacherVehicle.addBackupCam ~= nil then
		for i=1, #self.additionalCams do
			attacherVehicle:addBackupCam(self.additionalCams[i].index, self.additionalCams[i].overlay);
		end;
	end;
end;

function AdditionalBackupCam:onDetach()
	if self.camAttacherBackup.removeBackupCam ~= nil then
		for i=1, #self.additionalCams do
			self.camAttacherBackup:removeBackupCam(self.additionalCams[i].index);
		end;
	end;
end;

