
cabinControls = {};

cabinControls.modDir = g_currentModDirectory;

function cabinControls.prerequisitesPresent(specializations)
    return true; 
end;

function cabinControls:load(xmlFile)
	-- Initialize our cabinControl object(?)(table?)
	self.CControls = {};
	-- Check joystick node
	self.CControls.joystick = {};
	self.CControls.joystick.node = Utils.indexToObject( self.components, getXMLString(xmlFile, "vehicle.cabinControls.joystick#node") );
	
	if self.CControls.joystick.node ~= nil then
		self.CControls.joystick.rotF = math.rad( Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.cabinControls.joystick#rotFront"), 0) );
		self.CControls.joystick.rotB = math.rad( Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.cabinControls.joystick#rotBack"), 0) );
		self.CControls.joystick.rotT = 0;
		self.CControls.joystick.rotC = 0;
	end;
	
	self.CControls.forceJoystick_time = 0;
	
	-- Check shuttle node
	self.CControls.shuttle = {};
	self.CControls.shuttle.node = Utils.indexToObject( self.components, getXMLString(xmlFile, "vehicle.cabinControls.shuttle#node") );
	
	if self.CControls.shuttle.node ~= nil then
		--Forward position
		self.CControls.shuttle.rotFwd = {0, 0, 0};
		local rx, ry, rz = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.cabinControls.shuttle#rotFwd"));
		if rx ~= nil and ry ~= nil and rz ~= nil then
			self.CControls.shuttle.rotFwd = {math.rad(rx), math.rad(ry), math.rad(rz)};
		end;
		--Backward position
		self.CControls.shuttle.rotBwd = {0, 0, 0};
		rx, ry, rz = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.cabinControls.shuttle#rotBwd"));
		if rx ~= nil and ry ~= nil and rz ~= nil then
			self.CControls.shuttle.rotBwd = {math.rad(rx), math.rad(ry), math.rad(rz)};
		end;
		--Neutral/handbrake position
		self.CControls.shuttle.rotNeut = {0, 0, 0};
		rx, ry, rz = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.cabinControls.shuttle#rotNeut"));
		if rx ~= nil and ry ~= nil and rz ~= nil then
			self.CControls.shuttle.rotNeut = {math.rad(rx), math.rad(ry), math.rad(rz)};
		end;
	end;
	
	-- Check handThrottle node
	self.CControls.handThrottle = {};
	self.CControls.handThrottle.node = Utils.indexToObject( self.components, getXMLString(xmlFile, "vehicle.cabinControls.handthrottle#node") );
	
	if self.CControls.handThrottle.node ~= nil then
		self.CControls.handThrottle.rotMinX = math.rad( Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.cabinControls.handthrottle#rotMinX"), 0) );
		self.CControls.handThrottle.rotMaxX = math.rad( Utils.getNoNil(getXMLFloat(xmlFile, "vehicle.cabinControls.handthrottle#rotMaxX"), 0) );
	end;
end;

function cabinControls:delete()

end;

function cabinControls:readStream(streamId, connection)
end;

function cabinControls:writeStream(streamId, connection)
end;

function cabinControls:mouseEvent(posX, posY, isDown, isUp, button)
end;

function cabinControls:keyEvent(unicode, sym, modifier, isDown)
end;

function cabinControls:update(dt)
	if self:getIsActive() then
		if self.isClient then
			--Joystick
			if self.CControls.joystick.node then
				cabinControls.updateJoystick(self, dt);
			end;
			
			--Shuttle
			if self.CControls.shuttle.node then
			
				local isOn = false;
				if self.mrGbMS ~= nil then
					isOn = self:mrGbMGetIsOnOff();
				end;
				if isOn then
					cabinControls.updateShuttleMrGbMS(self);
				elseif self.driveControl and self.driveControl.shuttle then
					cabinControls.updateShuttleDC(self);
				else
					cabinControls.updateShuttle(self);
				end
			end;
			
			--HandThrottle
			if self.CControls.handThrottle.node and self.mrGbMS ~= nil then
				cabinControls.updateHandThrottle(self, dt);
			end;
			--self.mrGbMS
			--self.mrGbMS.IsOn
			--shuttle
			--self.mrGbMS.NeutralActive
			--self.mrGbMS.ReverseActive
			
			
		--[[	
			local vehicle = self
			if g_currentMission ~= nil and g_currentMission.controlledVehicle ~= nil then
				vehicle = g_currentMission.controlledVehicle
			end
			local neutral = vehicle:mrGbMGetNeutralActive()
			vehicle:mrGbMGetReverseActive()
			vehicle:mrGbMGetSpeedLimiter()
			vehicle:mrGbMGetHandThrottle()
			--self.mrGbMS.HandThrottle
	]]--
		end;
	end;
	
	
	
	if self.motor.speedLevel ~= 0 then
	end;
	
end;

function cabinControls:updateTick(dt)

end;

function cabinControls:onLeave()
end;

function cabinControls:draw()
end;

-- Joystick --
function cabinControls.updateJoystick(self, dt)
	local axisForward = 0;
	axisForward = InputBinding.getDigitalInputAxis(InputBinding.AXIS_MOVE_FORWARD_VEHICLE);
	if InputBinding.isAxisZero(axisForward) then
		axisForward = InputBinding.getAnalogInputAxis(InputBinding.AXIS_MOVE_FORWARD_VEHICLE)
	end;
	if axisForward < 0 then
		self.CControls.joystick.rotT = -self.CControls.joystick.rotF*axisForward;
	elseif axisForward > 0 then
		self.CControls.joystick.rotT = self.CControls.joystick.rotB*axisForward;
	else
		self.CControls.joystick.rotT = 0;
	end
	
	if self.CControls.forceJoystick_time > self.time then
		if self.forceJoystick == true then
			self.CControls.joystick.rotT = self.CControls.joystick.rotF/2;
		else
			self.CControls.joystick.rotT = self.CControls.joystick.rotB/2;
		end;
	end;
	
	
	if self.CControls.joystick.rotC < self.CControls.joystick.rotT then
		self.CControls.joystick.rotC = self.CControls.joystick.rotC + dt/1000;
		if self.CControls.joystick.rotC > self.CControls.joystick.rotT then
			self.CControls.joystick.rotC = self.CControls.joystick.rotT;
		end;
	elseif self.CControls.joystick.rotC > self.CControls.joystick.rotT then
		self.CControls.joystick.rotC = self.CControls.joystick.rotC - dt/1000;
		if self.CControls.joystick.rotC < self.CControls.joystick.rotT then
			self.CControls.joystick.rotC = self.CControls.joystick.rotT;
		end;
	end;
	
	setRotation( self.CControls.joystick.node, self.CControls.joystick.rotC, 0, 0 );
end;

-- Shuttle --
-- GEARBOX -- 
function cabinControls.updateShuttleMrGbMS(self)
	if self:mrGbMGetNeutralActive() then
		setRotation( self.CControls.shuttle.node, self.CControls.shuttle.rotNeut[1], self.CControls.shuttle.rotNeut[2], self.CControls.shuttle.rotNeut[3] );
	elseif self:mrGbMGetReverseActive() then
		setRotation( self.CControls.shuttle.node, self.CControls.shuttle.rotBwd[1], self.CControls.shuttle.rotBwd[2], self.CControls.shuttle.rotBwd[3] );
	else
		setRotation( self.CControls.shuttle.node, self.CControls.shuttle.rotFwd[1], self.CControls.shuttle.rotFwd[2], self.CControls.shuttle.rotFwd[3] );
	end;
end;
-- DRIVE CONTROL --
function cabinControls.updateShuttleDC(self)
	--print(self.lastSpeed);
	if self.driveControl.shuttle.direction > 0 and self.lastSpeed > 0.0001 then
		setRotation( self.CControls.shuttle.node, self.CControls.shuttle.rotFwd[1], self.CControls.shuttle.rotFwd[2], self.CControls.shuttle.rotFwd[3] );
	elseif self.driveControl.shuttle.direction < 0 and self.lastSpeed > 0.0001 then
		setRotation( self.CControls.shuttle.node, self.CControls.shuttle.rotBwd[1], self.CControls.shuttle.rotBwd[2], self.CControls.shuttle.rotBwd[3] );
	else
		setRotation( self.CControls.shuttle.node, self.CControls.shuttle.rotNeut[1], self.CControls.shuttle.rotNeut[2], self.CControls.shuttle.rotNeut[3] );
	end;
end;
-- DEFAULT --
function cabinControls.updateShuttle(self)
	--print(self.movingDirection );
	if self.movingDirection  > 0.0001 then
		setRotation( self.CControls.shuttle.node, self.CControls.shuttle.rotFwd[1], self.CControls.shuttle.rotFwd[2], self.CControls.shuttle.rotFwd[3] );
	elseif self.movingDirection  < -0.0001 then
		setRotation( self.CControls.shuttle.node, self.CControls.shuttle.rotBwd[1], self.CControls.shuttle.rotBwd[2], self.CControls.shuttle.rotBwd[3] );
	else
		setRotation( self.CControls.shuttle.node, self.CControls.shuttle.rotNeut[1], self.CControls.shuttle.rotNeut[2], self.CControls.shuttle.rotNeut[3] );
	end;
end;

-- HAND THROTTLE --
function cabinControls.updateHandThrottle(self)
	local throttle = self:mrGbMGetHandThrottle();
	local maxRot = self.CControls.handThrottle.rotMaxX - self.CControls.handThrottle.rotMinX;
	local currRotation = self.CControls.handThrottle.rotMinX + maxRot * throttle;
	--print("throttle: "..throttle);
	setRotation(self.CControls.handThrottle.node, currRotation, 0, 0 );
	

end;
function cabinControls:realSetSpeedLimiterValue(increase)
	if increase then
		self.CControls.forceJoystick = true;
	else
		self.CControls.forceJoystick = false;
	end;	
	self.CControls.forceJoystick_time = self.time + 100;
end;